/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.config;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.lyof.sortilege.Sortilege;
import net.lyof.sortilege.config.ModConfig;
import org.jetbrains.annotations.Nullable;

public class ConfigEntry<T> {
    private final List<String> path;
    private final T fallback;

    public ConfigEntry(String path) {
        this(path, null);
    }

    public ConfigEntry(String path, @Nullable T fallback) {
        this.path = List.of(path.split("\\."));
        this.fallback = fallback;
    }

    public T get() {
        return this.get(this.fallback);
    }

    public T get(T fallback) {
        Map next = ModConfig.CONFIG;
        T result = null;
        for (String step : this.path) {
            try {
                next = (Map)next.get(step);
            }
            catch (Exception e) {
                if (Objects.equals(step, this.path.get(this.path.size() - 1))) {
                    result = (T)next.get(step);
                }
                Sortilege.log("Couldn't find config value for path : \"" + this.path + "\", defaulting to " + fallback);
                return fallback;
            }
            if (next != null) continue;
            Sortilege.log("Couldn't find config value for path : \"" + this.path + "\", defaulting to " + fallback);
            return fallback;
        }
        if (fallback instanceof Integer) {
            return (T)Integer.valueOf(Double.valueOf(String.valueOf(result)).intValue());
        }
        if (fallback instanceof Double) {
            return (T)Double.valueOf(String.valueOf(result));
        }
        if (fallback instanceof String) {
            return (T)String.valueOf(result);
        }
        if (fallback instanceof Boolean) {
            return (T)Boolean.valueOf(String.valueOf(result));
        }
        if (fallback instanceof Map) {
            return (T)next;
        }
        if (fallback instanceof List) {
            return result;
        }
        Sortilege.log("Couldn't find config value for path : \"" + this.path + "\", defaulting to " + fallback);
        return fallback;
    }
}

