/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.block;

import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.IBlockEntity;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.logistics.IRedstoneInteract;
import owmii.powah.lib.logistics.Redstone;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.lib.logistics.inventory.Inventory;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.lib.util.Stack;

public class AbstractTileEntity<V extends IVariant, B extends AbstractBlock<V, B>>
extends class_2586
implements IBlockEntity,
IRedstoneInteract {
    protected final Inventory inv = Inventory.createBlank();
    protected final Tank tank = new Tank(0);
    protected V variant;
    protected boolean isContainerOpen;
    private Redstone redstone = Redstone.IGNORE;

    public AbstractTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        this(type, pos, state, IVariant.getEmpty());
        this.tank.validate(stack -> true);
    }

    public AbstractTileEntity(class_2591<?> type, class_2338 pos, class_2680 state, V variant) {
        super(type, pos, state);
        this.variant = variant;
        if (this instanceof IInventoryHolder) {
            this.inv.setTile((IInventoryHolder)((Object)this));
        }
    }

    public B getBlock() {
        return (B)((AbstractBlock)this.method_11010().method_26204());
    }

    public V getVariant() {
        return this.variant;
    }

    public final void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.readSync(tag);
        if (!tag.method_10545("#c")) {
            this.loadServerOnly(tag);
        }
    }

    protected final void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.writeSync(tag);
        this.saveServerOnly(tag);
    }

    public final class_2487 method_16887() {
        class_2487 tag = this.method_38244();
        tag.method_10556("#c", true);
        return tag;
    }

    @Nullable
    public final class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void loadServerOnly(class_2487 compound) {
    }

    protected class_2487 saveServerOnly(class_2487 compound) {
        return compound;
    }

    protected void readSync(class_2487 nbt) {
        ITankHolder tankHolder;
        AbstractTileEntity abstractTileEntity;
        if (!this.variant.isEmpty() && nbt.method_10573("variant", 3)) {
            this.variant = (IVariant)this.variant.read(nbt, "variant");
        }
        if (this instanceof IInventoryHolder && !this.keepInventory()) {
            this.inv.deserializeNBT(nbt);
        }
        if ((abstractTileEntity = this) instanceof ITankHolder && !(tankHolder = (ITankHolder)((Object)abstractTileEntity)).keepFluid()) {
            this.tank.readFromNBT(nbt);
        }
        this.redstone = Redstone.values()[nbt.method_10550("redstone_mode")];
        this.readStorable(nbt);
    }

    protected class_2487 writeSync(class_2487 nbt) {
        ITankHolder tankHolder;
        AbstractTileEntity abstractTileEntity;
        if (!this.variant.isEmpty()) {
            this.variant.write(nbt, (Enum)((Enum)this.variant), "variant");
        }
        if (this instanceof IInventoryHolder && !this.keepInventory()) {
            nbt.method_10543(this.inv.serializeNBT());
        }
        if ((abstractTileEntity = this) instanceof ITankHolder && !(tankHolder = (ITankHolder)((Object)abstractTileEntity)).keepFluid()) {
            this.tank.writeToNBT(nbt);
        }
        nbt.method_10569("redstone_mode", this.redstone.ordinal());
        return this.writeStorable(nbt);
    }

    public void readStorable(class_2487 nbt) {
        ITankHolder tankHolder;
        AbstractTileEntity abstractTileEntity;
        if (this instanceof IInventoryHolder && this.keepInventory()) {
            this.inv.deserializeNBT(nbt);
        }
        if ((abstractTileEntity = this) instanceof ITankHolder && (tankHolder = (ITankHolder)((Object)abstractTileEntity)).keepFluid()) {
            this.tank.readFromNBT(nbt);
        }
    }

    public class_2487 writeStorable(class_2487 nbt) {
        ITankHolder tankHolder;
        AbstractTileEntity abstractTileEntity;
        if (this instanceof IInventoryHolder && this.keepInventory()) {
            nbt.method_10543(this.inv.serializeNBT());
        }
        if ((abstractTileEntity = this) instanceof ITankHolder && (tankHolder = (ITankHolder)((Object)abstractTileEntity)).keepFluid()) {
            this.tank.writeToNBT(nbt);
        }
        return nbt;
    }

    @Override
    public void onPlaced(class_1937 world, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2487 tag = Stack.getTagOrEmpty(stack);
        if (!tag.method_33133()) {
            this.readStorable(tag.method_10562("powah_tile_data"));
        }
    }

    @Override
    public void onRemoved(class_1937 world, class_2680 state, class_2680 newState, boolean isMoving) {
        if (!(state.method_26204() == newState.method_26204() || !(this instanceof IInventoryHolder) || this.keepInventory() && this.keepStorable())) {
            this.getInventory().drop(world, this.field_11867);
        }
    }

    public class_1799 storeToStack(class_1799 stack) {
        class_2487 nbt = this.writeStorable(new class_2487());
        class_2487 nbt1 = Stack.getTagOrEmpty(stack);
        if (!nbt.method_33133() && this.keepStorable()) {
            nbt1.method_10566("powah_tile_data", (class_2520)nbt);
            stack.method_7980(nbt1);
        }
        return stack;
    }

    public static <T extends AbstractTileEntity> T fromStack(class_1799 stack, T tile) {
        class_2487 nbt = stack.method_7941("powah_tile_data");
        if (nbt != null) {
            tile.readStorable(nbt);
        }
        return tile;
    }

    public boolean keepStorable() {
        return true;
    }

    protected boolean keepInventory() {
        return false;
    }

    public Tank getTank() {
        return this.tank;
    }

    @Override
    public Redstone getRedstoneMode() {
        return this.redstone;
    }

    @Override
    public void setRedstoneMode(Redstone mode) {
        this.redstone = mode;
    }

    public boolean checkRedstone() {
        Redstone redstoneMode = this.getRedstoneMode();
        if (Redstone.IGNORE.equals((Object)redstoneMode)) {
            return true;
        }
        boolean power = this.field_11863 != null && this.field_11863.method_49804(this.field_11867) > 0;
        return power && Redstone.ON.equals((Object)redstoneMode) || !power && Redstone.OFF.equals((Object)redstoneMode);
    }

    public void sync() {
        if (this.field_11863 instanceof class_3218) {
            class_2680 state = this.method_11010();
            this.field_11863.method_8413(this.field_11867, state, state, 3);
            this.method_5431();
        }
    }

    public boolean isRemote() {
        return this.field_11863 != null && this.field_11863.field_9236;
    }

    public void setContainerOpen(boolean value) {
        boolean b = this.isContainerOpen;
        this.isContainerOpen = value;
        if (b != value) {
            this.sync();
        }
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

