/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.fabric.transfer;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import owmii.powah.lib.logistics.energy.Energy;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.DelegatingEnergyStorage;

public class EnergyItemWrapper
implements EnergyStorage {
    private final ContainerItemContext ctx;
    private final long capacity;
    private final long maxInsert;
    private final long maxExtract;

    public static EnergyStorage create(ContainerItemContext ctx, long capacity, long maxInsert, long maxExtract) {
        StoragePreconditions.notNegative((long)capacity);
        StoragePreconditions.notNegative((long)maxInsert);
        StoragePreconditions.notNegative((long)maxExtract);
        class_1792 startingItem = ctx.getItemVariant().getItem();
        return new DelegatingEnergyStorage((EnergyStorage)new EnergyItemWrapper(ctx, capacity, maxInsert, maxExtract), () -> ctx.getItemVariant().isOf((Object)startingItem) && ctx.getAmount() > 0L);
    }

    private EnergyItemWrapper(ContainerItemContext ctx, long capacity, long maxInsert, long maxExtract) {
        this.ctx = ctx;
        this.capacity = capacity;
        this.maxInsert = maxInsert;
        this.maxExtract = maxExtract;
    }

    private boolean trySetEnergy(long energyAmountPerCount, long count, TransactionContext transaction) {
        class_1799 newStack = this.ctx.getItemVariant().toStack();
        new Energy.Item(newStack, this.capacity, this.maxExtract, this.maxInsert).setStoredAndWrite(energyAmountPerCount);
        ItemVariant newVariant = ItemVariant.of((class_1799)newStack);
        try (Transaction nested = transaction.openNested();){
            if (this.ctx.extract(this.ctx.getItemVariant(), count, (TransactionContext)nested) == count && this.ctx.insert(newVariant, count, (TransactionContext)nested) == count) {
                nested.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean supportsInsertion() {
        return this.maxInsert > 0L;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        long currentAmountPerCount;
        long count = this.ctx.getAmount();
        long maxAmountPerCount = maxAmount / count;
        long insertedPerCount = Math.min(this.maxInsert, Math.min(maxAmountPerCount, this.capacity - (currentAmountPerCount = this.getAmount() / count)));
        if (insertedPerCount > 0L && this.trySetEnergy(currentAmountPerCount + insertedPerCount, count, transaction)) {
            return insertedPerCount * count;
        }
        return 0L;
    }

    public boolean supportsExtraction() {
        return this.maxExtract > 0L;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        long currentAmountPerCount;
        long count = this.ctx.getAmount();
        long maxAmountPerCount = maxAmount / count;
        long extractedPerCount = Math.min(this.maxExtract, Math.min(maxAmountPerCount, currentAmountPerCount = this.getAmount() / count));
        if (extractedPerCount > 0L && this.trySetEnergy(currentAmountPerCount - extractedPerCount, count, transaction)) {
            return extractedPerCount * count;
        }
        return 0L;
    }

    public long getAmount() {
        return this.ctx.getAmount() * new Energy.Item(this.ctx.getItemVariant().toStack(), this.capacity, this.maxExtract, this.maxInsert).getStored();
    }

    public long getCapacity() {
        return this.ctx.getAmount() * this.capacity;
    }
}

