/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2791;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import owmii.powah.block.cable.CableTile;

public class CableNet {
    private static final Logger LOG = LoggerFactory.getLogger(CableNet.class);
    private static final Map<class_1937, Long2ObjectMap<Long2ObjectMap<CableTile>>> loadedCables = new WeakHashMap<class_1937, Long2ObjectMap<Long2ObjectMap<CableTile>>>();
    List<CableTile> cableList;

    static void addCable(CableTile cable) {
        long chunkPos = class_1923.method_37232((class_2338)cable.method_11016());
        CableTile previousCable = (CableTile)((Long2ObjectMap)loadedCables.computeIfAbsent(cable.method_10997(), l -> new Long2ObjectOpenHashMap()).computeIfAbsent(chunkPos, l -> new Long2ObjectOpenHashMap())).put(cable.method_11016().method_10063(), (Object)cable);
        if (previousCable != null) {
            throw new RuntimeException("Cable added to position %s, but there was already one there?".formatted(cable.method_11016()));
        }
        CableNet.updateAdjacentCables(cable);
    }

    static void removeCable(CableTile cable) {
        class_1937 level = cable.method_10997();
        if (level == null) {
            return;
        }
        Long2ObjectMap<Long2ObjectMap<CableTile>> levelMap = loadedCables.get(level);
        if (levelMap == null) {
            return;
        }
        class_2338 blockPos = cable.method_11016();
        long chunkPos = class_1923.method_37232((class_2338)blockPos);
        Long2ObjectMap chunkMap = (Long2ObjectMap)levelMap.get(chunkPos);
        if (chunkMap == null) {
            return;
        }
        if (chunkMap.remove(blockPos.method_10063()) != cable) {
            throw new RuntimeException("Removed wrong cable from position %s".formatted(blockPos));
        }
        if (chunkMap.isEmpty()) {
            levelMap.remove(chunkPos);
        }
        if (levelMap.isEmpty()) {
            loadedCables.remove(level);
        }
        CableNet.updateAdjacentCables(cable);
    }

    @Nullable
    private static CableTile getCableAt(Long2ObjectMap<Long2ObjectMap<CableTile>> levelMap, class_2338 pos) {
        Long2ObjectMap chunkMap = (Long2ObjectMap)levelMap.get(class_1923.method_37232((class_2338)pos));
        if (chunkMap == null) {
            return null;
        }
        return (CableTile)chunkMap.get(pos.method_10063());
    }

    static void updateAdjacentCables(CableTile cable) {
        Long2ObjectMap<Long2ObjectMap<CableTile>> levelMap = loadedCables.get(cable.method_10997());
        if (levelMap == null) {
            return;
        }
        for (class_2350 direction : class_2350.values()) {
            class_2338 adjPos = cable.method_11016().method_10093(direction);
            CableTile adjCable = CableNet.getCableAt(levelMap, adjPos);
            if (adjCable == null || adjCable.net == null) continue;
            adjCable.net.cableList.forEach(c -> {
                c.net = null;
            });
        }
    }

    static void calculateNetwork(CableTile cable) {
        Long2ObjectMap<Long2ObjectMap<CableTile>> levelMap = Objects.requireNonNull(loadedCables.get(cable.method_10997()), "No level map?");
        LinkedHashSet<CableTile> cables = new LinkedHashSet<CableTile>();
        ArrayDeque<CableTile> queue = new ArrayDeque<CableTile>();
        cables.add(cable);
        queue.add(cable);
        while (!queue.isEmpty()) {
            CableTile cur = (CableTile)queue.pop();
            for (class_2350 direction : class_2350.values()) {
                class_2338 adjPos = cur.method_11016().method_10093(direction);
                CableTile adjCable = CableNet.getCableAt(levelMap, adjPos);
                if (adjCable == null || !cables.add(adjCable)) continue;
                queue.add(adjCable);
            }
        }
        MutableBoolean insertionGuard = new MutableBoolean();
        CableNet net = new CableNet(new ArrayList<CableTile>(cables));
        for (CableTile tile : net.cableList) {
            tile.net = net;
            tile.netInsertionGuard = insertionGuard;
        }
    }

    CableNet(List<CableTile> cableList) {
        this.cableList = cableList;
    }

    public static void removeChunk(class_1937 level, class_2791 chunk) {
        Long2ObjectMap<Long2ObjectMap<CableTile>> levelMap = loadedCables.get(level);
        if (levelMap == null) {
            return;
        }
        Long2ObjectMap chunkMap = (Long2ObjectMap)levelMap.remove(chunk.method_12004().method_8324());
        if (chunkMap == null) {
            return;
        }
        if (levelMap.isEmpty()) {
            loadedCables.remove(level);
        }
        for (CableTile cable : chunkMap.values()) {
            cable.net = null;
        }
        for (CableTile cable : chunkMap.values()) {
            CableNet.updateAdjacentCables(cable);
        }
    }
}

