/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.world.level.block.data;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fuzs.blockrunner.BlockRunner;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public abstract class SpeedHolderValue {
    final double speedMultiplier;

    public SpeedHolderValue(double speedMultiplier) {
        this.speedMultiplier = class_3532.method_15350((double)speedMultiplier, (double)0.1, (double)8.0);
    }

    public abstract void addValues(Map<class_2248, Double> var1) throws JsonSyntaxException;

    abstract void serialize(JsonObject var1);

    public static class Builder {
        private final Set<SpeedHolderValue> entries = Sets.newHashSet();

        public Builder add(class_2248 block, double speedFactor) {
            this.entries.add(new BlockValue(block, speedFactor));
            return this;
        }

        public Builder add(class_6862<class_2248> tag, double speedFactor) {
            this.entries.add(new TagValue(tag, speedFactor));
            return this;
        }

        public Set<SpeedHolderValue> build() {
            return ImmutableSet.copyOf(this.entries);
        }
    }

    public static class TagValue
    extends SpeedHolderValue {
        private final class_6862<class_2248> tag;

        public TagValue(class_6862<class_2248> tag, double speed) {
            super(speed);
            this.tag = tag;
        }

        @Override
        public void addValues(Map<class_2248, Double> blocks) throws JsonSyntaxException {
            if (class_7923.field_41175.method_40266(this.tag).isPresent()) {
                for (class_6880 holder : class_7923.field_41175.method_40286(this.tag)) {
                    blocks.putIfAbsent((class_2248)holder.comp_349(), this.speedMultiplier);
                }
            } else {
                String allowedLocations = class_7923.field_41175.method_40273().map(class_6862::comp_327).map(class_2960::toString).collect(Collectors.joining(", "));
                BlockRunner.LOGGER.warn("Unknown block tag type '{}', valid types are: {}", (Object)this.tag.comp_327(), (Object)allowedLocations);
            }
        }

        @Override
        void serialize(JsonObject jsonObject) {
            jsonObject.addProperty("#" + this.tag.comp_327(), (Number)this.speedMultiplier);
        }
    }

    public static class BlockValue
    extends SpeedHolderValue {
        private final class_2248 block;

        public BlockValue(class_2248 block, double speed) {
            super(speed);
            this.block = block;
        }

        @Override
        public void addValues(Map<class_2248, Double> blocks) {
            blocks.put(this.block, this.speedMultiplier);
        }

        @Override
        void serialize(JsonObject jsonObject) {
            jsonObject.addProperty(class_7923.field_41175.method_10221((Object)this.block).toString(), (Number)this.speedMultiplier);
        }
    }
}

