/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.mixin;

import com.google.common.base.Objects;
import fuzs.blockrunner.world.level.block.data.BlockSpeedManager;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    private class_2338 field_6268;

    public LivingEntityMixin(class_1299<?> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getBlockSpeedFactor(CallbackInfoReturnable<Float> callback) {
        if (BlockSpeedManager.INSTANCE.hasBlockSpeed(this.method_37908().method_8320(this.method_23314()).method_26204())) {
            callback.setReturnValue((Object)Float.valueOf(1.0f));
        }
    }

    @Inject(method={"onChangedBlock"}, at={@At(value="TAIL")})
    protected void onChangedBlock(class_2338 pos, CallbackInfo callback) {
        this.blockrunner$onChangedBlock();
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    protected void checkFallDamage(double y, boolean onGround, class_2680 state, class_2338 pos, CallbackInfo callback) {
        if ((!this.method_37908().field_9236 || class_1309.class.cast((Object)this) instanceof class_1657) && onGround && this.field_6017 > 0.0f) {
            this.blockrunner$removeBlockSpeed();
            this.blockrunner$tryAddBlockSpeed();
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    public void baseTick(CallbackInfo callback) {
        class_2338 blockPos;
        if (this.method_37908().field_9236 && class_1309.class.cast((Object)this) instanceof class_1657 && !Objects.equal((Object)this.field_6268, (Object)(blockPos = this.method_24515()))) {
            this.field_6268 = blockPos;
            this.blockrunner$onChangedBlock();
        }
    }

    @Unique
    private void blockrunner$onChangedBlock() {
        if (this.method_29500(this.method_25936())) {
            this.blockrunner$removeBlockSpeed();
        }
        this.blockrunner$tryAddBlockSpeed();
    }

    @Unique
    private void blockrunner$removeBlockSpeed() {
        class_1324 attribute = this.method_5996(class_5134.field_23719);
        if (attribute != null && attribute.method_6199(BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID) != null) {
            attribute.method_6200(BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID);
        }
    }

    @Unique
    protected void blockrunner$tryAddBlockSpeed() {
        block6: {
            class_2680 blockStateOn;
            block5: {
                Object t = class_1309.class.cast((Object)this);
                if (!(t instanceof class_1657)) break block5;
                class_1657 player = (class_1657)t;
                if (player.method_31549().field_7479) break block6;
            }
            if (!(blockStateOn = this.method_25936()).method_26215()) {
                double speedFactor = BlockSpeedManager.INSTANCE.getSpeedFactor(blockStateOn.method_26204());
                class_1324 attribute = this.method_5996(class_5134.field_23719);
                if (attribute == null || speedFactor == 1.0) {
                    return;
                }
                double baseValue = attribute.method_6201();
                speedFactor = speedFactor * baseValue - baseValue;
                attribute.method_26835(new class_1322(BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID, "Block speed boost", speedFactor, class_1322.class_1323.field_6328));
            }
        }
    }

    @Shadow
    public abstract class_1324 method_5996(class_1320 var1);

    @Shadow
    protected abstract boolean method_29500(class_2680 var1);
}

