/*
 * Decompiled with CFR 0.152.
 */
package net.teamremastered.tlc.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.teamremastered.tlc.registries.LCStructures;

public class LostCastle
extends class_3195 {
    public static final Codec<LostCastle> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LostCastle.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, LostCastle::new)).codec();
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    private final class_6122 startHeight;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public LostCastle(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    private static int DistanceFromSpawn(class_1923 structurePos) {
        class_1923 spawnPointPos = new class_1923(0, 0);
        int structurePosX = structurePos.field_9181 << 4;
        int structurePosZ = structurePos.field_9180 << 4;
        int distanceFromSpawn = (int)Math.sqrt(Math.pow(structurePosX - spawnPointPos.field_9181, 2.0) + Math.pow(structurePosZ - spawnPointPos.field_9180, 2.0));
        System.out.println("Distance from spawn is: " + distanceFromSpawn);
        return distanceFromSpawn;
    }

    private static boolean extraSpawningChecks(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        int x = chunkPos.method_8326();
        int z = chunkPos.method_8328();
        int startHeight = context.comp_562().method_18028(x, z, class_2902.class_2903.field_13203, context.comp_569(), context.comp_564());
        int height1 = context.comp_562().method_18028(x + 78, z, class_2902.class_2903.field_13203, context.comp_569(), context.comp_564());
        int height2 = context.comp_562().method_18028(x - 78, z, class_2902.class_2903.field_13203, context.comp_569(), context.comp_564());
        int height3 = context.comp_562().method_18028(x, z + 78, class_2902.class_2903.field_13203, context.comp_569(), context.comp_564());
        int height4 = context.comp_562().method_18028(x, z - 78, class_2902.class_2903.field_13203, context.comp_569(), context.comp_564());
        return Math.abs(startHeight - height1) < 10 && Math.abs(startHeight - height2) < 10 && Math.abs(startHeight - height3) < 10 && Math.abs(startHeight - height4) < 10 && LostCastle.DistanceFromSpawn(chunkPos) > 5000;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (!LostCastle.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_1923 chunkPos = context.comp_568();
        int x = chunkPos.method_8326();
        int z = chunkPos.method_8328();
        class_2338 blockPos = new class_2338(x, startY, z);
        Optional structurePiecesGenerator = class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    public class_7151<?> method_41618() {
        return LCStructures.LOST_CASTLE;
    }
}

