/*
 * Decompiled with CFR 0.152.
 */
package net.teamremastered.tlc.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class TLCConfig {
    private static Path configFilePath;
    private static Gson gson;
    public static boolean GENERATE_STRONGHOLD;

    public static void load() {
        if (TLCConfig.getFilePath().toFile().exists()) {
            try {
                BufferedReader reader = Files.newBufferedReader(TLCConfig.getFilePath());
                Data data = (Data)gson.fromJson((Reader)reader, Data.class);
                GENERATE_STRONGHOLD = data.common.GENERATE_STRONGHOLD;
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        TLCConfig.save();
    }

    public static void save() {
        try {
            BufferedWriter writer = Files.newBufferedWriter(TLCConfig.getFilePath(), new OpenOption[0]);
            Data data = new Data(new Data.Common(GENERATE_STRONGHOLD));
            gson.toJson((Object)data, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path getFilePath() {
        if (configFilePath == null) {
            configFilePath = FabricLoader.getInstance().getConfigDir().resolve("tlc.json");
        }
        return configFilePath;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        GENERATE_STRONGHOLD = false;
    }

    private static class Data {
        private Common common;

        public Data(Common common) {
            this.common = common;
        }

        private static class Common {
            private final String Generate_Stronghold_Comment = "Enable/Disable the generation of the stronghold";
            private final boolean GENERATE_STRONGHOLD;

            private Common() {
                this.GENERATE_STRONGHOLD = false;
            }

            private Common(boolean USE_EYE_OF_ENDER) {
                this.GENERATE_STRONGHOLD = USE_EYE_OF_ENDER;
            }
        }
    }
}

