/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.core.AppEng;
import appeng.datagen.providers.tags.ConventionTags;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import com.google.common.math.StatsAccumulator;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6626;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.class_7151;
import net.minecraft.class_7924;

public class MeteoriteStructure
extends class_3195 {
    public static final class_2960 ID = AppEng.makeId("meteorite");
    public static final class_5321<class_7059> STRUCTURE_SET_KEY = class_5321.method_29179((class_5321)class_7924.field_41248, (class_2960)ID);
    public static final Codec<MeteoriteStructure> CODEC = MeteoriteStructure.method_42699(MeteoriteStructure::new);
    public static final class_5321<class_3195> KEY = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)ID);
    public static final class_6862<class_1959> BIOME_TAG_KEY = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)AppEng.makeId("has_meteorites"));
    public static class_7151<MeteoriteStructure> TYPE;

    public MeteoriteStructure(class_3195.class_7302 settings) {
        super(settings);
    }

    public class_7151<?> method_41618() {
        return TYPE;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2919 worldgenRandom = new class_2919((class_5819)new class_5820(0L));
        worldgenRandom.method_12663(context.comp_567(), context.comp_568().field_9181, context.comp_568().field_9180);
        if (!worldgenRandom.method_43056()) {
            return Optional.empty();
        }
        return MeteoriteStructure.method_41612((class_3195.class_7149)context, (class_2902.class_2903)class_2902.class_2903.field_13195, structurePiecesBuilder -> MeteoriteStructure.generatePieces(structurePiecesBuilder, context));
    }

    private static void generatePieces(class_6626 piecesBuilder, class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        class_2919 random = context.comp_566();
        class_5539 heightAccessor = context.comp_569();
        class_2794 generator = context.comp_562();
        int centerX = chunkPos.method_8326() + random.method_43048(16);
        int centerZ = chunkPos.method_8328() + random.method_43048(16);
        float meteoriteRadius = random.method_43057() * 6.0f + 2.0f;
        int yOffset = (int)Math.ceil(meteoriteRadius) + 1;
        Set t2 = generator.method_12098().method_8763(centerX, generator.method_16398(), centerZ, 0, context.comp_564().method_42371());
        class_6880 spawnBiome = (class_6880)t2.stream().findFirst().orElseThrow();
        boolean isOcean = spawnBiome.method_40220(ConventionTags.METEORITE_OCEAN);
        class_2902.class_2903 heightmapType = isOcean ? class_2902.class_2903.field_13195 : class_2902.class_2903.field_13194;
        StatsAccumulator stats = new StatsAccumulator();
        int scanRadius = (int)Math.max(1.0f, meteoriteRadius * 2.0f);
        for (int x = -scanRadius; x <= scanRadius; ++x) {
            for (int z = -scanRadius; z <= scanRadius; ++z) {
                int h = generator.method_16397(centerX + x, centerZ + z, heightmapType, heightAccessor, context.comp_564());
                stats.add((double)h);
            }
        }
        int centerY = (int)stats.mean();
        if (stats.populationVariance() > 5.0) {
            centerY = (int)((double)centerY - (stats.mean() - stats.min()) * 0.75);
        }
        centerY -= yOffset;
        centerY = Math.max(heightAccessor.method_31607() + yOffset, centerY);
        class_2338 actualPos = new class_2338(centerX, centerY, centerZ);
        boolean craterLake = MeteoriteStructure.locateWaterAroundTheCrater(actualPos, meteoriteRadius, context);
        CraterType craterType = MeteoriteStructure.determineCraterType(actualPos, (class_6880<class_1959>)spawnBiome, random);
        boolean pureCrater = random.method_43057() > 0.9f;
        FalloutMode fallout = FalloutMode.fromBiome((class_6880<class_1959>)spawnBiome);
        piecesBuilder.method_35462((class_3443)new MeteoriteStructurePiece(actualPos, meteoriteRadius, craterType, fallout, pureCrater, craterLake));
    }

    private static boolean locateWaterAroundTheCrater(class_2338 pos, float radius, class_3195.class_7149 context) {
        class_2794 generator = context.comp_562();
        class_5539 heightAccessor = context.comp_569();
        int seaLevel = generator.method_16398();
        int maxY = seaLevel - 1;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        blockPos.method_33098(maxY);
        for (int i = pos.method_10263() - 32; i <= pos.method_10263() + 32; ++i) {
            blockPos.method_33097(i);
            for (int k = pos.method_10260() - 32; k <= pos.method_10260() + 32; ++k) {
                int heigth;
                blockPos.method_33099(k);
                double dx = i - pos.method_10263();
                double dz = k - pos.method_10260();
                double h = (float)pos.method_10264() - radius + 1.0f;
                double distanceFrom = dx * dx + dz * dz;
                if (!((double)maxY > h + distanceFrom * 0.0175) || !((double)maxY < h + distanceFrom * 0.02) || (heigth = generator.method_16397(blockPos.method_10263(), blockPos.method_10260(), class_2902.class_2903.field_13200, heightAccessor, context.comp_564())) >= seaLevel) continue;
                return true;
            }
        }
        return false;
    }

    private static CraterType determineCraterType(class_2338 pos, class_6880<class_1959> biomeHolder, class_2919 random) {
        boolean lake;
        boolean specialMeteor;
        class_1959 biome = (class_1959)biomeHolder.comp_349();
        float temp = biome.method_8712();
        if (biomeHolder.method_40220(ConventionTags.METEORITE_OCEAN)) {
            return CraterType.NONE;
        }
        boolean bl = specialMeteor = random.method_43057() > 0.5f;
        if (!specialMeteor) {
            return CraterType.NORMAL;
        }
        boolean canSnow = biome.method_33599(pos);
        if (temp >= 1.0f) {
            boolean lava;
            boolean bl2 = lava = random.method_43057() > 0.5f;
            if (!biome.method_48163()) {
                return lava ? CraterType.LAVA : CraterType.NORMAL;
            }
            if (!canSnow) {
                boolean obsidian = random.method_43057() > 0.75f;
                CraterType alternativObsidian = obsidian ? CraterType.OBSIDIAN : CraterType.LAVA;
                return lava ? alternativObsidian : CraterType.NORMAL;
            }
        }
        if (temp < 1.0f && (double)temp >= 0.2) {
            boolean lava;
            lake = random.method_43057() > 0.25f;
            boolean bl3 = lava = random.method_43057() > 0.8f;
            if (!biome.method_48163()) {
                return lava ? CraterType.LAVA : CraterType.NORMAL;
            }
            if (!canSnow) {
                boolean obsidian = random.method_43057() > 0.75f;
                CraterType alternativObsidian = obsidian ? CraterType.OBSIDIAN : CraterType.LAVA;
                CraterType craterLake = lake ? CraterType.WATER : CraterType.NORMAL;
                return lava ? alternativObsidian : craterLake;
            }
            boolean snow = random.method_43057() > 0.75f;
            CraterType water = lake ? CraterType.WATER : CraterType.NORMAL;
            return snow ? CraterType.SNOW : water;
        }
        if ((double)temp < 0.2) {
            boolean frozen;
            lake = random.method_43057() > 0.25f;
            boolean lava = random.method_43057() > 0.95f;
            boolean bl4 = frozen = random.method_43057() > 0.25f;
            if (!biome.method_48163()) {
                return lava ? CraterType.LAVA : CraterType.NORMAL;
            }
            if (!canSnow) {
                CraterType frozenLake = frozen ? CraterType.ICE : CraterType.WATER;
                CraterType craterLake = lake ? frozenLake : CraterType.NORMAL;
                return lava ? CraterType.LAVA : craterLake;
            }
            CraterType snowCovered = lake ? CraterType.SNOW : CraterType.NORMAL;
            return lava ? CraterType.LAVA : snowCovered;
        }
        return CraterType.NORMAL;
    }
}

