/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.blockentity.misc.InterfaceBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.items.tools.NetworkToolItem;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.crafting.PatternProviderPart;
import appeng.parts.misc.InterfacePart;
import appeng.server.testplots.CraftingPatternHelper;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.PlotTestHelper;
import appeng.util.SettingsFrom;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public final class MemoryCardTestPlots {
    private MemoryCardTestPlots() {
    }

    @TestPlot(value="memcard_export_bus")
    public static void testExportBus(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        plot.creativeEnergyCell(origin.method_10074());
        plot.cable(origin).part(class_2350.field_11039, AEParts.EXPORT_BUS).part(class_2350.field_11034, AEParts.EXPORT_BUS);
        plot.test(helper -> {
            ExportBusPart fromPart = helper.getPart(class_2338.field_10980, class_2350.field_11039, ExportBusPart.class);
            ExportBusPart toPart = helper.getPart(class_2338.field_10980, class_2350.field_11034, ExportBusPart.class);
            class_1657 player = helper.method_36021();
            InternalInventory networkToolInv = MemoryCardTestPlots.addNetworkToolToPlayer(player);
            fromPart.getUpgrades().addItems(AEItems.REDSTONE_CARD.stack());
            fromPart.getUpgrades().addItems(AEItems.FUZZY_CARD.stack());
            fromPart.getUpgrades().addItems(AEItems.CRAFTING_CARD.stack());
            fromPart.getUpgrades().addItems(AEItems.CAPACITY_CARD.stack());
            fromPart.getConfig().addFilter((class_1935)class_1802.field_8600);
            fromPart.getConfig().addFilter((class_3611)class_3612.field_15910);
            fromPart.getConfigManager().putSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.SIGNAL_PULSE);
            fromPart.getConfigManager().putSetting(Settings.FUZZY_MODE, FuzzyMode.PERCENT_25);
            fromPart.getConfigManager().putSetting(Settings.CRAFT_ONLY, YesNo.YES);
            fromPart.getConfigManager().putSetting(Settings.SCHEDULING_MODE, SchedulingMode.RANDOM);
            MemoryCardTestPlots.copyUpgradesToNetworkInv(fromPart, networkToolInv);
            class_2487 settings = new class_2487();
            fromPart.exportSettings(SettingsFrom.MEMORY_CARD, settings);
            toPart.importSettings(SettingsFrom.MEMORY_CARD, settings, player);
            MemoryCardTestPlots.assertUpgradeEquals(origin, helper, fromPart, toPart);
            MemoryCardTestPlots.assertConfigEquals(origin, helper, fromPart, toPart);
            if (!toPart.getConfig().keySet().equals(Set.of(AEItemKey.of((class_1935)class_1802.field_8600), AEFluidKey.of((class_3611)class_3612.field_15910)))) {
                helper.method_35997("wrong filter", origin);
            }
            helper.method_36036();
        });
    }

    @TestPlot(value="memcard_interface")
    public static void testInterface(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        plot.cable(origin).part(class_2350.field_11039, AEParts.INTERFACE);
        plot.block(origin.method_10078(), AEBlocks.INTERFACE);
        plot.test(helper -> {
            InterfaceBlockEntity from = (InterfaceBlockEntity)helper.method_36014(class_2338.field_10980.method_10078());
            InterfacePart to = helper.getPart(class_2338.field_10980, class_2350.field_11039, InterfacePart.class);
            class_1657 player = helper.method_36021();
            InternalInventory networkToolInv = MemoryCardTestPlots.addNetworkToolToPlayer(player);
            from.getUpgrades().addItems(AEItems.FUZZY_CARD.stack());
            to.getUpgrades().addItems(AEItems.REDSTONE_CARD.stack());
            from.getConfig().setStack(0, new GenericStack(AEItemKey.of((class_1935)class_1802.field_8600), 1L));
            from.getConfig().setStack(1, new GenericStack(AEFluidKey.of((class_3611)class_3612.field_15910), 1L));
            from.getConfigManager().putSetting(Settings.FUZZY_MODE, FuzzyMode.PERCENT_25);
            MemoryCardTestPlots.copyUpgradesToNetworkInv(from, networkToolInv);
            class_2487 settings = new class_2487();
            from.exportSettings(SettingsFrom.MEMORY_CARD, settings, null);
            to.importSettings(SettingsFrom.MEMORY_CARD, settings, player);
            MemoryCardTestPlots.assertUpgradeEquals(origin, helper, from, to);
            MemoryCardTestPlots.assertConfigEquals(origin, helper, from, to);
            if (!Objects.equals(to.getConfig().getKey(0), AEItemKey.of((class_1935)class_1802.field_8600))) {
                helper.method_35997("missing stick in filter", origin);
            }
            if (!Objects.equals(to.getConfig().getKey(1), AEFluidKey.of((class_3611)class_3612.field_15910))) {
                helper.method_35997("missing water in filter", origin);
            }
            helper.method_36036();
        });
    }

    @TestPlot(value="memcard_pattern_provider")
    public static void testPatternProvider(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        plot.cable(origin).part(class_2350.field_11039, AEParts.PATTERN_PROVIDER);
        plot.block(origin.method_10078(), AEBlocks.PATTERN_PROVIDER);
        plot.test(helper -> {
            class_1799 processingPattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{new GenericStack(AEFluidKey.of((class_3611)class_3612.field_15910), 1L)}, new GenericStack[]{new GenericStack(AEFluidKey.of((class_3611)class_3612.field_15908), 1L)});
            class_1799 craftingPattern = CraftingPatternHelper.encodeShapelessCraftingRecipe((class_1937)helper.method_35943(), class_1802.field_8583.method_7854());
            class_1799 differentCraftingPattern = CraftingPatternHelper.encodeShapelessCraftingRecipe((class_1937)helper.method_35943(), class_1802.field_8684.method_7854());
            PatternProviderBlockEntity from = (PatternProviderBlockEntity)helper.method_36014(class_2338.field_10980.method_10078());
            PatternProviderPart to = helper.getPart(class_2338.field_10980, class_2350.field_11039, PatternProviderPart.class);
            class_1657 player = helper.method_36021();
            player.method_31548().method_7398(AEItems.BLANK_PATTERN.stack(64));
            InternalInventory fromPatternInv = from.getLogic().getPatternInv();
            fromPatternInv.addItems(processingPattern);
            fromPatternInv.addItems(craftingPattern);
            InternalInventory toPatternInv = to.getLogic().getPatternInv();
            toPatternInv.addItems(differentCraftingPattern.method_7972());
            toPatternInv.addItems(differentCraftingPattern.method_7972());
            toPatternInv.addItems(differentCraftingPattern.method_7972());
            int blankPatternsBefore = player.method_31548().method_18861((class_1792)AEItems.BLANK_PATTERN.method_8389());
            class_2487 settings = new class_2487();
            from.exportSettings(SettingsFrom.MEMORY_CARD, settings, null);
            to.importSettings(SettingsFrom.MEMORY_CARD, settings, player);
            int blankPatternsAfter = player.method_31548().method_18861((class_1792)AEItems.BLANK_PATTERN.method_8389());
            helper.check(blankPatternsAfter == blankPatternsBefore + 1, "Expected player to be given back one blank pattern");
            for (int i = 0; i < fromPatternInv.size(); ++i) {
                class_1799 toItem;
                class_1799 fromItem = fromPatternInv.getStackInSlot(i);
                if (class_1799.method_31577((class_1799)fromItem, (class_1799)(toItem = toPatternInv.getStackInSlot(i)))) continue;
                helper.method_35997("Mismatch in slot " + i, origin.method_10078());
            }
            helper.method_36036();
        });
    }

    private static InternalInventory addNetworkToolToPlayer(class_1657 player) {
        player.method_7270(AEItems.NETWORK_TOOL.stack());
        return NetworkToolItem.findNetworkToolInv(player).getInventory();
    }

    private static void assertUpgradeEquals(class_2338 origin, PlotTestHelper helper, Object fromPart, Object toPart) {
        if (fromPart instanceof IUpgradeableObject) {
            IUpgradeableObject upgradableFrom = (IUpgradeableObject)fromPart;
            IUpgradeableObject upgradeableTo = (IUpgradeableObject)toPart;
            for (class_1799 upgrade : upgradableFrom.getUpgrades()) {
                if (upgradableFrom.getInstalledUpgrades((class_1935)upgrade.method_7909()) == upgradeableTo.getInstalledUpgrades((class_1935)upgrade.method_7909())) continue;
                helper.method_35997(upgrade.method_7964().getString() + " mismatch", origin);
            }
        }
    }

    private static void assertConfigEquals(class_2338 origin, PlotTestHelper helper, Object fromPart, Object toPart) {
        if (fromPart instanceof IConfigurableObject) {
            IConfigurableObject fromConfigurable = (IConfigurableObject)fromPart;
            IConfigurableObject toConfigurable = (IConfigurableObject)toPart;
            IConfigManager fromConfig = fromConfigurable.getConfigManager();
            IConfigManager toConfig = toConfigurable.getConfigManager();
            for (Setting<?> setting : fromConfig.getSettings()) {
                if (((Enum)fromConfig.getSetting(setting)).equals(toConfig.getSetting(setting))) continue;
                helper.method_35997("Setting " + setting + " mismatch", origin);
            }
        }
    }

    private static void copyUpgradesToNetworkInv(Object fromPart, InternalInventory networkToolInv) {
        if (fromPart instanceof IUpgradeableObject) {
            IUpgradeableObject upgradeable = (IUpgradeableObject)fromPart;
            for (class_1799 upgrade : upgradeable.getUpgrades()) {
                networkToolInv.addItems(upgrade.method_7972());
            }
        }
    }
}

