/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.emi;

import appeng.api.config.CondenserOutput;
import appeng.api.features.P2PTunnelAttunementInternal;
import appeng.api.integrations.emi.EmiStackConverters;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.FacadeCreativeTab;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.core.localization.ItemModText;
import appeng.core.localization.LocalizationEnum;
import appeng.integration.abstraction.ItemListMod;
import appeng.integration.modules.emi.EmiAeBaseScreenDragDropHandler;
import appeng.integration.modules.emi.EmiAeBaseScreenExclusionZones;
import appeng.integration.modules.emi.EmiAeBaseScreenStackProvider;
import appeng.integration.modules.emi.EmiChargerRecipe;
import appeng.integration.modules.emi.EmiCondenserRecipe;
import appeng.integration.modules.emi.EmiEncodePatternHandler;
import appeng.integration.modules.emi.EmiEntropyRecipe;
import appeng.integration.modules.emi.EmiFacadeGenerator;
import appeng.integration.modules.emi.EmiFluidStackConverter;
import appeng.integration.modules.emi.EmiInscriberRecipe;
import appeng.integration.modules.emi.EmiItemListModAdapter;
import appeng.integration.modules.emi.EmiItemStackConverter;
import appeng.integration.modules.emi.EmiP2PAttunementRecipe;
import appeng.integration.modules.emi.EmiTransformRecipe;
import appeng.integration.modules.emi.EmiUseCraftingRecipeHandler;
import appeng.integration.modules.jeirei.ItemPredicates;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.me.items.WirelessCraftingTermMenu;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.transform.TransformRecipe;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiExclusionArea;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_6862;

@EmiEntrypoint
public class AppEngEmiPlugin
implements EmiPlugin {
    static final class_2960 TEXTURE = AppEng.makeId("textures/guis/jei.png");

    public void register(EmiRegistry registry) {
        ItemListMod.setAdapter(new EmiItemListModAdapter());
        EmiStackConverters.register(new EmiItemStackConverter());
        EmiStackConverters.register(new EmiFluidStackConverter());
        registry.addGenericExclusionArea((EmiExclusionArea)new EmiAeBaseScreenExclusionZones());
        registry.addGenericStackProvider((EmiStackProvider)new EmiAeBaseScreenStackProvider());
        registry.addGenericDragDropHandler((EmiDragDropHandler)new EmiAeBaseScreenDragDropHandler());
        this.registerWorkstations(registry);
        this.registerDescriptions(registry);
        registry.addRecipeHandler(PatternEncodingTermMenu.TYPE, new EmiEncodePatternHandler<PatternEncodingTermMenu>(PatternEncodingTermMenu.class));
        registry.addRecipeHandler(CraftingTermMenu.TYPE, new EmiUseCraftingRecipeHandler<CraftingTermMenu>(CraftingTermMenu.class));
        registry.addRecipeHandler(WirelessCraftingTermMenu.TYPE, new EmiUseCraftingRecipeHandler<WirelessCraftingTermMenu>(WirelessCraftingTermMenu.class));
        registry.addCategory(EmiInscriberRecipe.CATEGORY);
        registry.addWorkstation(EmiInscriberRecipe.CATEGORY, (EmiIngredient)EmiStack.of(AEBlocks.INSCRIBER));
        AppEngEmiPlugin.adaptRecipeType(registry, InscriberRecipe.TYPE, EmiInscriberRecipe::new);
        registry.addCategory(EmiChargerRecipe.CATEGORY);
        registry.addWorkstation(EmiChargerRecipe.CATEGORY, (EmiIngredient)EmiStack.of(AEBlocks.CHARGER));
        registry.addWorkstation(EmiChargerRecipe.CATEGORY, (EmiIngredient)EmiStack.of(AEBlocks.CRANK));
        AppEngEmiPlugin.adaptRecipeType(registry, ChargerRecipe.TYPE, EmiChargerRecipe::new);
        registry.addCategory(EmiP2PAttunementRecipe.CATEGORY);
        registry.addDeferredRecipes(this::registerP2PAttunements);
        registry.addCategory(EmiCondenserRecipe.CATEGORY);
        registry.addWorkstation(EmiCondenserRecipe.CATEGORY, (EmiIngredient)EmiStack.of(AEBlocks.CONDENSER));
        registry.addRecipe((EmiRecipe)new EmiCondenserRecipe(CondenserOutput.MATTER_BALLS));
        registry.addRecipe((EmiRecipe)new EmiCondenserRecipe(CondenserOutput.SINGULARITY));
        registry.addCategory(EmiEntropyRecipe.CATEGORY);
        registry.addWorkstation(EmiEntropyRecipe.CATEGORY, (EmiIngredient)EmiStack.of(AEItems.ENTROPY_MANIPULATOR));
        AppEngEmiPlugin.adaptRecipeType(registry, EntropyRecipe.TYPE, EmiEntropyRecipe::new);
        registry.addCategory(EmiTransformRecipe.CATEGORY);
        AppEngEmiPlugin.adaptRecipeType(registry, TransformRecipe.TYPE, EmiTransformRecipe::new);
        if (AEConfig.instance().isEnableFacadeRecipesInJEI()) {
            registry.addDeferredRecipes(this::registerFacades);
        }
        registry.removeEmiStacks(emiStack -> {
            class_1799 stack = emiStack.getItemStack();
            return !stack.method_7960() && ItemPredicates.shouldBeHidden(stack);
        });
    }

    private void registerWorkstations(EmiRegistry registry) {
        class_1799 craftingTerminal = AEParts.CRAFTING_TERMINAL.stack();
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((class_1799)craftingTerminal));
        class_1799 wirelessCraftingTerminal = AEItems.WIRELESS_CRAFTING_TERMINAL.stack();
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((class_1799)wirelessCraftingTerminal));
    }

    private void registerDescriptions(EmiRegistry registry) {
        this.addDescription(registry, AEItems.CERTUS_QUARTZ_CRYSTAL, GuiText.CertusQuartzObtain);
        if (AEConfig.instance().isSpawnPressesInMeteoritesEnabled()) {
            this.addDescription(registry, AEItems.LOGIC_PROCESSOR_PRESS, GuiText.inWorldCraftingPresses);
            this.addDescription(registry, AEItems.CALCULATION_PROCESSOR_PRESS, GuiText.inWorldCraftingPresses);
            this.addDescription(registry, AEItems.ENGINEERING_PROCESSOR_PRESS, GuiText.inWorldCraftingPresses);
            this.addDescription(registry, AEItems.SILICON_PRESS, GuiText.inWorldCraftingPresses);
        }
        this.addDescription(registry, AEBlocks.CRANK, ItemModText.CRANK_DESCRIPTION);
    }

    private void addDescription(EmiRegistry registry, ItemDefinition<?> item, LocalizationEnum ... lines) {
        EmiInfoRecipe info = new EmiInfoRecipe(List.of(EmiStack.of(item)), Arrays.stream(lines).map(LocalizationEnum::text).toList(), null);
        registry.addRecipe((EmiRecipe)info);
    }

    private static <C extends class_1263, T extends class_1860<C>> void adaptRecipeType(EmiRegistry registry, class_3956<T> recipeType, Function<T, ? extends EmiRecipe> adapter) {
        registry.getRecipeManager().method_30027(recipeType).stream().map(adapter).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }

    private void registerP2PAttunements(Consumer<EmiRecipe> recipeConsumer) {
        List all = EmiApi.getIndexStacks();
        for (P2PTunnelAttunementInternal.Resultant resultant : P2PTunnelAttunementInternal.getApiTunnels()) {
            List<EmiStack> inputs = all.stream().filter(stack -> resultant.stackPredicate().test(stack.getItemStack())).toList();
            if (inputs.isEmpty()) continue;
            recipeConsumer.accept((EmiRecipe)new EmiP2PAttunementRecipe(EmiIngredient.of(inputs), EmiStack.of((class_1935)resultant.tunnelType()), (class_2561)ItemModText.P2P_API_ATTUNEMENT.text().method_27693("\n").method_10852(resultant.description())));
        }
        for (Map.Entry entry : P2PTunnelAttunementInternal.getTagTunnels().entrySet()) {
            EmiIngredient ingredient = EmiIngredient.of((class_6862)((class_6862)entry.getKey()));
            if (ingredient.isEmpty()) continue;
            recipeConsumer.accept((EmiRecipe)new EmiP2PAttunementRecipe(ingredient, EmiStack.of((class_1935)((class_1935)entry.getValue())), (class_2561)ItemModText.P2P_TAG_ATTUNEMENT.text()));
        }
    }

    private void registerFacades(Consumer<EmiRecipe> recipeConsumer) {
        EmiFacadeGenerator generator = new EmiFacadeGenerator();
        for (class_1799 facade : FacadeCreativeTab.getDisplayItems()) {
            generator.getRecipeFor(facade).ifPresent(recipeConsumer);
        }
    }
}

