/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene;

import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.client.guidebook.color.SymbolicColor;
import appeng.client.guidebook.scene.ImplicitAnnotationStrategy;
import appeng.client.guidebook.scene.annotation.InWorldBoxAnnotation;
import appeng.client.guidebook.scene.annotation.SceneAnnotation;
import appeng.client.guidebook.scene.level.GuidebookLevel;
import appeng.core.localization.GuiText;
import appeng.parts.BusCollisionHelper;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PartAnnotationStrategy
implements ImplicitAnnotationStrategy {
    @Override
    @Nullable
    public SceneAnnotation getAnnotation(GuidebookLevel level, class_2680 blockState, class_3965 blockHitResult) {
        class_2338 pos = blockHitResult.method_17777();
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof IPartHost)) {
            return null;
        }
        IPartHost partHost = (IPartHost)be;
        SelectedPart partResult = partHost.selectPartWorld(blockHitResult.method_17784());
        if (partResult != null) {
            IPart part = partResult.part;
            IFacadePart facade = partResult.facade;
            class_238 aabb = null;
            class_5250 description = class_2561.method_43473();
            if (part != null) {
                aabb = this.getAABB(partResult.side, partResult.part::getBoxes);
                description = partResult.part.getPartItem().method_8389().method_7848();
            } else if (facade != null) {
                aabb = this.getAABB(partResult.side, bch -> partResult.facade.getBoxes((IPartCollisionHelper)bch, false));
                description = GuiText.Facade.text(partResult.facade.getItem().method_7848());
            }
            if (aabb != null) {
                InWorldBoxAnnotation annotation = new InWorldBoxAnnotation(new Vector3f((float)pos.method_10263() + (float)aabb.field_1323, (float)pos.method_10264() + (float)aabb.field_1322, (float)pos.method_10260() + (float)aabb.field_1321), new Vector3f((float)pos.method_10263() + (float)aabb.field_1320, (float)pos.method_10264() + (float)aabb.field_1325, (float)pos.method_10260() + (float)aabb.field_1324), SymbolicColor.IN_WORLD_BLOCK_HIGHLIGHT);
                annotation.setTooltipContent((class_2561)description);
                return annotation;
            }
        }
        return null;
    }

    @Nullable
    private class_238 getAABB(class_2350 side, Consumer<IPartCollisionHelper> collisionHelper) {
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        BusCollisionHelper bch = new BusCollisionHelper(boxes, side, true);
        collisionHelper.accept(bch);
        if (boxes.isEmpty()) {
            return null;
        }
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxZ = Double.MIN_VALUE;
        for (class_238 box : boxes) {
            minX = Math.min(minX, box.field_1323);
            minY = Math.min(minY, box.field_1322);
            minZ = Math.min(minZ, box.field_1321);
            maxX = Math.max(maxX, box.field_1320);
            maxY = Math.max(maxY, box.field_1325);
            maxZ = Math.max(maxZ, box.field_1324);
        }
        return new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

