/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler;

import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.compiler.IdUtils;
import appeng.client.guidebook.compiler.PageCompiler;
import java.net.URI;
import net.minecraft.class_151;
import net.minecraft.class_2960;

public final class LinkParser {
    private LinkParser() {
    }

    public static void parseLink(PageCompiler compiler, String href, Visitor visitor) {
        class_2960 pageId;
        URI uri;
        try {
            uri = URI.create(href);
        }
        catch (Exception ignored) {
            visitor.handleError("Invalid URL");
            return;
        }
        if (uri.isAbsolute()) {
            if (uri.getScheme().equals("http") || uri.getScheme().equalsIgnoreCase("https")) {
                visitor.handleExternal(uri);
                return;
            }
            try {
                pageId = new class_2960(uri.getScheme() + ":" + uri.getSchemeSpecificPart());
            }
            catch (class_151 ignored) {
                visitor.handleError("Invalid resource location");
                return;
            }
        }
        try {
            pageId = IdUtils.resolveLink(uri.getPath(), compiler.getPageId());
        }
        catch (class_151 ignored) {
            visitor.handleError("Invalid link");
            return;
        }
        if (!compiler.getPageCollection().pageExists(pageId)) {
            visitor.handleError("Page does not exist");
            return;
        }
        visitor.handlePage(new PageAnchor(pageId, uri.getFragment()));
    }

    public static interface Visitor {
        default public void handlePage(PageAnchor page) {
        }

        default public void handleExternal(URI uri) {
        }

        default public void handleError(String error) {
        }
    }
}

