/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.behaviors.EmptyingAction;
import appeng.api.config.ActionItems;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.common.MEStorageScreen;
import appeng.client.gui.me.common.StackSizeRenderer;
import appeng.client.gui.me.items.CraftingEncodingPanel;
import appeng.client.gui.me.items.EncodingModePanel;
import appeng.client.gui.me.items.ProcessingEncodingPanel;
import appeng.client.gui.me.items.SetProcessingPatternAmountScreen;
import appeng.client.gui.me.items.SmithingTableEncodingPanel;
import appeng.client.gui.me.items.StonecuttingEncodingPanel;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.TabButton;
import appeng.core.AEConfig;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.Tooltips;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.parts.encoding.EncodingMode;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class PatternEncodingTermScreen<C extends PatternEncodingTermMenu>
extends MEStorageScreen<C> {
    private final Map<EncodingMode, EncodingModePanel> modePanels = new EnumMap<EncodingMode, EncodingModePanel>(EncodingMode.class);
    private final Map<EncodingMode, TabButton> modeTabButtons = new EnumMap<EncodingMode, TabButton>(EncodingMode.class);

    public PatternEncodingTermScreen(C menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        for (EncodingMode mode : EncodingMode.values()) {
            EncodingModePanel panel = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case EncodingMode.CRAFTING -> new CraftingEncodingPanel(this, this.widgets);
                case EncodingMode.PROCESSING -> new ProcessingEncodingPanel(this, this.widgets);
                case EncodingMode.SMITHING_TABLE -> new SmithingTableEncodingPanel(this, this.widgets);
                case EncodingMode.STONECUTTING -> new StonecuttingEncodingPanel(this, this.widgets);
            };
            TabButton tabButton = new TabButton(panel.getTabIconItem(), panel.getTabTooltip(), btn -> ((PatternEncodingTermMenu)this.method_17577()).setMode(mode));
            tabButton.setStyle(TabButton.Style.HORIZONTAL);
            int modeIndex = this.modeTabButtons.size();
            this.widgets.add("modePanel" + modeIndex, panel);
            this.widgets.add("modeTabButton" + modeIndex, (class_339)tabButton);
            this.modeTabButtons.put(mode, tabButton);
            this.modePanels.put(mode, panel);
        }
        ActionButton encodeBtn = new ActionButton(ActionItems.ENCODE, act -> menu.encode());
        this.widgets.add("encodePattern", (class_339)encodeBtn);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        for (EncodingMode mode : EncodingMode.values()) {
            boolean selected = ((PatternEncodingTermMenu)this.field_2797).getMode() == mode;
            this.modeTabButtons.get((Object)mode).setSelected(selected);
            this.modePanels.get((Object)mode).setVisible(selected);
        }
    }

    @Override
    public boolean method_25402(double xCoord, double yCoord, int btn) {
        GenericStack currentStack;
        class_1735 slot;
        if (this.field_22787.field_1690.field_1871.method_1433(btn) && ((PatternEncodingTermMenu)this.field_2797).canModifyAmountForSlot(slot = this.method_2386(xCoord, yCoord)) && (currentStack = GenericStack.fromItemStack(slot.method_7677())) != null) {
            SetProcessingPatternAmountScreen screen = new SetProcessingPatternAmountScreen(this, currentStack, newStack -> NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, slot.field_7874, GenericStack.wrapInItemStack(newStack))));
            this.switchToScreen(screen);
            return true;
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    @Override
    protected void method_2380(class_332 guiGraphics, int x, int y) {
        if (((PatternEncodingTermMenu)this.field_2797).method_34255().method_7960() && ((PatternEncodingTermMenu)this.field_2797).canModifyAmountForSlot(this.field_2787)) {
            ArrayList<class_2561> itemTooltip = new ArrayList<class_2561>(this.method_51454(this.field_2787.method_7677()));
            GenericStack unwrapped = GenericStack.fromItemStack(this.field_2787.method_7677());
            if (unwrapped != null) {
                itemTooltip.add(Tooltips.getAmountTooltip(ButtonToolTips.Amount, unwrapped));
            }
            itemTooltip.add(Tooltips.getSetAmountTooltip());
            this.drawTooltip(guiGraphics, x, y, itemTooltip);
        } else {
            super.method_2380(guiGraphics, x, y);
        }
    }

    @Override
    protected EmptyingAction getEmptyingAction(class_1735 slot, class_1799 carried) {
        EmptyingAction emptyingAction;
        if (((PatternEncodingTermMenu)this.field_2797).isProcessingPatternSlot(slot) && (emptyingAction = ContainerItemStrategies.getEmptyingAction(carried)) != null) {
            return emptyingAction;
        }
        return super.getEmptyingAction(slot, carried);
    }

    @Override
    public void method_2385(class_332 guiGraphics, class_1735 s) {
        super.method_2385(guiGraphics, s);
        if (this.shouldShowCraftableIndicatorForSlot(s)) {
            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 100.0f);
            StackSizeRenderer.renderSizeLabel(guiGraphics, this.field_22793, (float)(s.field_7873 - 11), (float)(s.field_7872 - 11), "+", false);
            poseStack.method_22909();
        }
    }

    protected List<class_2561> method_51454(class_1799 stack) {
        ArrayList<class_5250> lines = super.method_51454(stack);
        if (this.field_2787 != null && this.shouldShowCraftableIndicatorForSlot(this.field_2787)) {
            lines = new ArrayList<class_5250>(lines);
            lines.add(ButtonToolTips.Craftable.text().method_27692(class_124.field_1063));
        }
        return lines;
    }

    private boolean shouldShowCraftableIndicatorForSlot(class_1735 s) {
        SlotSemantic semantic = ((PatternEncodingTermMenu)this.field_2797).getSlotSemantic(s);
        if (semantic == SlotSemantics.CRAFTING_GRID || semantic == SlotSemantics.PROCESSING_INPUTS || semantic == SlotSemantics.SMITHING_TABLE_ADDITION || semantic == SlotSemantics.SMITHING_TABLE_BASE || semantic == SlotSemantics.SMITHING_TABLE_TEMPLATE || semantic == SlotSemantics.STONECUTTING_INPUT) {
            GenericStack slotContent = GenericStack.fromItemStack(s.method_7677());
            if (slotContent == null) {
                return false;
            }
            return this.repo.isCraftable(slotContent.what());
        }
        return false;
    }

    public void method_25419() {
        if (AEConfig.instance().isClearGridOnClose()) {
            ((PatternEncodingTermMenu)this.method_17577()).clear();
        }
        super.method_25419();
    }
}

