/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.movable;

import appeng.api.movable.DefaultBlockEntityMoveStrategy;
import appeng.api.movable.IBlockEntityMoveStrategy;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2586;
import net.minecraft.class_2591;

public final class BlockEntityMoveStrategies {
    private static final IBlockEntityMoveStrategy DEFAULT_STRATEGY = new DefaultBlockEntityMoveStrategy(){

        @Override
        public boolean canHandle(class_2591<?> type) {
            return true;
        }
    };
    private static final List<IBlockEntityMoveStrategy> strategies = new ArrayList<IBlockEntityMoveStrategy>();
    private static final Map<class_2591<?>, IBlockEntityMoveStrategy> valid = new IdentityHashMap();

    public static synchronized void add(IBlockEntityMoveStrategy strategy) {
        Objects.requireNonNull(strategy, "handler");
        strategies.add(strategy);
    }

    public static synchronized IBlockEntityMoveStrategy get(class_2586 blockEntity) {
        Objects.requireNonNull(blockEntity, "blockEntity");
        IBlockEntityMoveStrategy result = valid.get(blockEntity.method_11017());
        if (result == null) {
            for (IBlockEntityMoveStrategy strategy : strategies) {
                if (!strategy.canHandle(blockEntity.method_11017())) continue;
                result = strategy;
                break;
            }
            if (result == null) {
                result = DEFAULT_STRATEGY;
            }
            valid.put(blockEntity.method_11017(), result);
        }
        return result;
    }

    public static IBlockEntityMoveStrategy getDefault() {
        return DEFAULT_STRATEGY;
    }
}

