/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.inventories;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.lookup.v1.custom.ApiProviderMap;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.jetbrains.annotations.Nullable;

public final class PartApiLookup {
    private static final ApiProviderMap<BlockApiLookup<?, ?>, Function<?, class_2350>> mappings = ApiProviderMap.create();
    private static final ApiProviderMap<BlockApiLookup<?, ?>, ApiProviderMap<Class<?>, PartApiProvider<?, ?, ?>>> providers = ApiProviderMap.create();
    private static final Set<BlockApiLookup<?, ?>> cableBusRegisteredLookups = ConcurrentHashMap.newKeySet();
    private static final Set<class_2591<? extends IPartHost>> hostTypes = ConcurrentHashMap.newKeySet();

    private PartApiLookup() {
    }

    public static <A, C> void registerCustomContext(BlockApiLookup<A, C> lookup, Function<C, class_2350> mappingFunction) {
        mappings.putIfAbsent(lookup, mappingFunction);
    }

    public static <A, C, P extends IPart> void register(BlockApiLookup<A, C> lookup, PartApiProvider<A, C, P> provider, Class<P> partClass) {
        Objects.requireNonNull(lookup, "Registered lookup may not be null.");
        if (partClass.isInterface()) {
            throw new IllegalArgumentException("Part lookup cannot be registered for interface:" + partClass.getCanonicalName());
        }
        providers.putIfAbsent(lookup, (Object)ApiProviderMap.create());
        ApiProviderMap toProviderMap = (ApiProviderMap)providers.get(lookup);
        if (toProviderMap.putIfAbsent(partClass, provider) != null) {
            throw new IllegalArgumentException("Duplicate provider registration for part class " + partClass.getCanonicalName());
        }
        if (cableBusRegisteredLookups.add(lookup)) {
            for (class_2591<? extends IPartHost> hostType : hostTypes) {
                PartApiLookup.registerLookup(hostType, lookup);
            }
        }
    }

    private static <A, C> void registerLookup(class_2591<? extends IPartHost> hostType, BlockApiLookup<A, C> lookup) {
        lookup.registerForBlockEntities((be, context) -> {
            @Nullable class_2350 location = PartApiLookup.mapContext(lookup, context);
            if (location == null) {
                return null;
            }
            IPartHost partHost = (IPartHost)be;
            IPart part = partHost.getPart(location);
            if (part != null) {
                return PartApiLookup.find(lookup, context, part);
            }
            return null;
        }, new class_2591[]{hostType});
    }

    public static <T extends class_2586> void addHostType(class_2591<T> hostType) {
        if (hostTypes.add(hostType)) {
            for (BlockApiLookup<?, ?> api : cableBusRegisteredLookups) {
                PartApiLookup.registerLookup(hostType, api);
            }
        }
    }

    @Nullable
    public static <C> class_2350 mapContext(BlockApiLookup<?, C> lookup, C context) {
        Function mapping = (Function)mappings.get(lookup);
        if (mapping != null) {
            return (class_2350)mapping.apply(context);
        }
        if (context instanceof class_2350) {
            class_2350 direction = (class_2350)context;
            return direction;
        }
        return null;
    }

    @Nullable
    public static <A, C> A find(BlockApiLookup<A, C> lookup, C context, IPart part) {
        ApiProviderMap toProviderMap = (ApiProviderMap)providers.get(lookup);
        if (lookup == null) {
            return null;
        }
        for (Class<?> klass = part.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            Object instance;
            PartApiProvider provider = (PartApiProvider)toProviderMap.get(klass);
            if (provider == null || (instance = provider.find(part, context)) == null) continue;
            return instance;
        }
        return null;
    }

    @FunctionalInterface
    public static interface PartApiProvider<A, C, P extends IPart> {
        @Nullable
        public A find(P var1, C var2);
    }
}

