/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.util;

import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;

public class Platform {
    public static void executeDist(Environment env, Supplier<Runnable> runnableSupplier) {
        if (Platform.getEnvironment() == env) {
            runnableSupplier.get().run();
        }
    }

    public static boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    public static Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static List<Mod> getModList() {
        return FabricLoader.getInstance().getAllMods().stream().map(mod -> new Mod((ModContainer)mod){
            final /* synthetic */ ModContainer val$mod;
            {
                this.val$mod = modContainer;
            }

            @Override
            public String getId() {
                return this.val$mod.getMetadata().getId();
            }

            @Override
            public String getVersion() {
                return this.val$mod.getMetadata().getVersion().getFriendlyString();
            }

            @Override
            public Version getFabricVersion() {
                return this.val$mod.getMetadata().getVersion();
            }
        }).sorted(Comparator.comparing(Mod::getId)).collect(Collectors.toList());
    }

    public static Environment getEnvironment() {
        switch (FabricLoader.getInstance().getEnvironmentType()) {
            case CLIENT: {
                return Environment.CLIENT;
            }
            case SERVER: {
                return Environment.SERVER;
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean mpucAuthor() {
        return Platform.getGameDir().resolve(".mpuc-author").toFile().exists();
    }

    public static enum Environment {
        CLIENT,
        SERVER;

    }

    public static interface Mod {
        public String getId();

        public String getVersion();

        public Version getFabricVersion();
    }
}

