/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget.flow.markdown;

import com.jab125.mpuc.client.gui.widget.flow.markdown.ExtendedListFeature;
import com.jab125.mpuc.client.gui.widget.flow.markdown.HeaderFeature;
import com.jab125.mpuc.client.gui.widget.flow.markdown.ImageFeature;
import com.jab125.mpuc.client.gui.widget.flow.markdown.LinkFeature;
import com.jab125.mpuc.client.gui.widget.flow.widgets.AbstractWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.FlexFlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.FlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.HeaderFlexFlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.ImageWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.QuotedFlexFlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.TextWidget;
import com.jab125.mpuc.client.util.TextureSizeLookup;
import com.jab125.mpuc.server.util.Widths;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.MarkdownProcessor;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import dev.jab125.lavendermd.feature.BasicFormattingFeature;
import dev.jab125.lavendermd.feature.BlockQuoteFeature;
import dev.jab125.lavendermd.feature.ColorFeature;
import dev.jab125.lavendermd.util.TextBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Stack;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class WidgetCompiler
implements MarkdownCompiler<AbstractWidget> {
    private final TextBuilder builder = new TextBuilder();
    private final FlowWidget widget;
    private final Stack<FlowWidget> widgets;
    private final int assumedOutputWidth;
    private int quoteDepth = 0;
    private int listDepth = 0;
    private int headerDepth = 0;

    public WidgetCompiler() {
        this(50, 0, 0);
    }

    public WidgetCompiler(int assumedOutputWidth, int maxWidth, int maxHeight) {
        this(assumedOutputWidth, maxWidth, maxHeight, class_124.field_1080);
    }

    public WidgetCompiler(int assumedOutputWidth, int maxWidth, int maxHeight, class_124 formatting) {
        this.assumedOutputWidth = assumedOutputWidth;
        this.widget = new FlexFlowWidget(class_310.method_1551(), maxWidth, maxHeight, FlowWidget.Direction.VERTICAL);
        this.widgets = ((Supplier<Stack>)() -> {
            Stack<FlowWidget> widgets = new Stack<FlowWidget>();
            widgets.push(this.widget);
            return widgets;
        }).get();
        if (formatting != null) {
            this.visitStyle(a -> a.method_10977(formatting));
        }
    }

    public void visitText(String text) {
        if (this.listDepth != 0 && text.contains("\n")) {
            if (text.equals("\n")) {
                this.builder.append(class_2561.method_43470((String)("\n   " + "  ".repeat(this.listDepth - 1))));
            } else {
                String[] lines = text.split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    this.builder.append(class_2561.method_43470((String)((i > 0 ? "\n   " : "   ") + "  ".repeat(this.listDepth - 1))).method_10852((class_2561)class_2561.method_43470((String)lines[i])));
                }
            }
        } else {
            this.builder.append(class_2561.method_43470((String)text));
        }
    }

    public void visitStyle(UnaryOperator<class_2583> style) {
        this.builder.pushStyle(style);
    }

    public void visitStyleEnd() {
        this.builder.popStyle();
    }

    public void visitBlockQuote() {
        ++this.quoteDepth;
        this.addText(this.builder.build());
        QuotedFlexFlowWidget f = new QuotedFlexFlowWidget(class_310.method_1551(), FlowWidget.Direction.VERTICAL);
        this.widgets.peek().addChild(f);
        this.widgets.push(f);
        this.builder.pushStyle(style -> style.method_10977(class_124.field_1063));
    }

    public void visitBlockQuoteEnd() {
        this.builder.popStyle();
        this.addText(this.builder.build());
        this.widgets.pop();
        --this.quoteDepth;
        if (this.quoteDepth <= 0) {
            this.builder.append(class_2561.method_43470((String)"\n"));
        }
    }

    public void visitHeader(int num) {
        this.headerDepth += num;
        this.addText(this.builder.build());
        HeaderFlexFlowWidget f = new HeaderFlexFlowWidget(class_310.method_1551(), FlowWidget.Direction.VERTICAL, this.headerDepth);
        this.widgets.peek().addChild(f);
        this.widgets.push(f);
    }

    public void visitHeaderEnd(int num) {
        class_5250 build = this.builder.build();
        this.addText(build);
        this.widgets.pop();
        this.headerDepth -= num;
        if (this.headerDepth > 0) {
            // empty if block
        }
    }

    private class_5250 quoteMarker() {
        return class_2561.method_43470((String)("\n >" + ">".repeat(this.quoteDepth) + " ")).method_27692(class_124.field_1063);
    }

    public void visitHorizontalRule() {
        this.builder.append(class_2561.method_43470((String)"-".repeat(this.assumedOutputWidth / Widths.WIDTH_CACHE.get('-'))).method_27692(class_124.field_1063));
    }

    public void visitImage(class_2960 image, String description, boolean fit) {
        this.addText(this.builder.build());
        TextureSizeLookup.Size size = TextureSizeLookup.sizeOf(image);
        if (fit) {
            this.widgets.peek().addChild(new ImageWidget(this.widgets.peek().client, image, 100, 100));
        } else {
            this.widgets.peek().addChild(new ImageWidget(this.widgets.peek().client, image, size.width(), size.height()));
        }
    }

    private void addText(class_5250 build) {
        ArrayList<TextWidget> text = new ArrayList<TextWidget>();
        List texts = this.widgets.peek().client.field_1772.method_27527().method_27495((class_5348)build, this.assumedOutputWidth, class_2583.field_24360);
        for (class_5348 class_53482 : texts) {
            class_310 class_3102 = this.widgets.peek().client;
            int n = this.widgets.peek().client.field_1772.method_27525(class_53482);
            Objects.requireNonNull(this.widgets.peek().client.field_1772);
            TextWidget text2 = new TextWidget(class_3102, class_53482, n, 9, 1.0, false);
            text.add(text2);
        }
        for (AbstractWidget abstractWidget : text) {
            this.widgets.peek().addChild(abstractWidget);
        }
    }

    public void visitListItem(OptionalInt ordinal) {
        String listPrefix;
        String string = listPrefix = ordinal.isPresent() ? " " + ordinal.getAsInt() + ". " : " \u2022 ";
        if (this.listDepth > 0) {
            this.builder.append(class_2561.method_43470((String)("\n" + "   ".repeat(this.listDepth) + listPrefix)));
        } else {
            this.builder.append(class_2561.method_43470((String)listPrefix));
        }
        ++this.listDepth;
    }

    public void visitListItemEnd() {
        --this.listDepth;
        if (this.listDepth > 0) {
            this.builder.append(class_2561.method_43470((String)"   ".repeat(this.listDepth)));
        } else {
            this.builder.append(class_2561.method_43470((String)"\n"));
        }
    }

    public AbstractWidget compile() {
        this.addText(this.builder.build());
        return this.widget;
    }

    public String name() {
        return "mpuc_flow";
    }

    public static MarkdownProcessor<AbstractWidget> widget(int assumedOutputWidth, int maxWidth, int maxHeight) {
        return WidgetCompiler.widget(assumedOutputWidth, maxWidth, maxHeight, class_124.field_1080);
    }

    public static MarkdownProcessor<AbstractWidget> widget(int assumedOutputWidth, int maxWidth, int maxHeight, class_124 formatting) {
        return new MarkdownProcessor(() -> new WidgetCompiler(assumedOutputWidth, maxWidth, maxHeight, formatting), new MarkdownFeature[]{new BasicFormattingFeature(), new ColorFeature(), new LinkFeature(), new ExtendedListFeature(), new BlockQuoteFeature(), new ImageFeature(), new HeaderFeature()});
    }
}

