/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.utils;

import elocindev.eldritch_end.api.CorruptionAPI;
import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.corruption.corruption_effect.CEEyeSpawn;
import elocindev.eldritch_end.corruption.corruption_effect.CETentacleSpawn;
import elocindev.eldritch_end.entity.ominous_eye.OminousEyeEntity;
import elocindev.eldritch_end.entity.tentacle.TentacleEntity;
import elocindev.eldritch_end.registry.EntityRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerUtils {
    private static CETentacleSpawn TENTACLE_CFG = Configs.Mechanics.CORRUPTION.corruption_effects.tentacle_spawn;
    private static CEEyeSpawn EYE_CFG = Configs.Mechanics.CORRUPTION.corruption_effects.ominous_eye_spawn;

    public static boolean hasValidTentacleConditions(class_3222 serverPlayer) {
        return CorruptionAPI.getAffectedCorruptionLevel((class_1309)serverPlayer) >= (double)TENTACLE_CFG.getStartingLevel() && serverPlayer.field_6012 - serverPlayer.method_6083() <= TENTACLE_CFG.getCombatDurationTicks() && serverPlayer.method_6051().method_43057() <= TENTACLE_CFG.getSpawnChance();
    }

    public static boolean hasValidEyeConditions(class_3222 serverPlayer) {
        return CorruptionAPI.getAffectedCorruptionLevel((class_1309)serverPlayer) >= (double)EYE_CFG.getStartingLevel() && serverPlayer.field_6012 - serverPlayer.method_6083() >= EYE_CFG.getCombatDurationTicks() && serverPlayer.method_6051().method_43057() <= EYE_CFG.getSpawnChance();
    }

    public static void summonTentacle(class_3222 serverPlayer, class_1937 world) {
        TentacleEntity tentacle = (TentacleEntity)EntityRegistry.TENTACLE.method_5883(world);
        if (TENTACLE_CFG.getStartingLevel() <= -1 || tentacle == null || serverPlayer == null || !serverPlayer.method_24828()) {
            return;
        }
        tentacle.method_33574(serverPlayer.method_19538());
        world.method_8649((class_1297)tentacle);
        serverPlayer.method_18800(0.0, (double)TENTACLE_CFG.getLaunchVelocity(), 0.0);
        serverPlayer.field_6037 = true;
    }

    public static void summonOminousEye(class_3222 serverPlayer, class_1937 world) {
        for (int i = 0; i <= EYE_CFG.getEyeAmount(); ++i) {
            class_1297 ominousEye = EntityRegistry.OMINOUS_EYE.method_5883(world);
            if (EYE_CFG.getStartingLevel() <= -1 || ominousEye == null || serverPlayer == null) {
                return;
            }
            class_243 pos = serverPlayer.method_19538();
            ominousEye.method_33574(pos.method_1031(0.0, 3.0, 0.0));
            world.method_8649(ominousEye);
            if (!(ominousEye instanceof OminousEyeEntity)) continue;
            OminousEyeEntity livingOminousEye = (OminousEyeEntity)ominousEye;
            livingOminousEye.method_5980((class_1309)serverPlayer);
        }
    }

    public static void healthDrainCheck(MinecraftServer server) {
        for (class_3222 serverPlayer : server.method_3760().method_14571()) {
            if (!(CorruptionAPI.getAffectedCorruptionLevel((class_1309)serverPlayer) >= (double)Configs.Mechanics.CORRUPTION.corruption_effects.madness_consumed.getStartingLevel())) continue;
            serverPlayer.method_5643(serverPlayer.method_48923().method_48830(), serverPlayer.method_6063() * Configs.Mechanics.CORRUPTION.corruption_effects.madness_consumed.getMaxHealthPerSecond());
        }
    }

    public static void tentacleSummonCheck(MinecraftServer server) {
        for (class_3222 serverPlayer : server.method_3760().method_14571()) {
            if (!ServerUtils.hasValidTentacleConditions(serverPlayer)) continue;
            ServerUtils.summonTentacle(serverPlayer, serverPlayer.method_37908());
        }
    }

    public static void ominousEyeSummonCheck(MinecraftServer server) {
        for (class_3222 serverPlayer : server.method_3760().method_14571()) {
            if (!ServerUtils.hasValidEyeConditions(serverPlayer)) continue;
            ServerUtils.summonOminousEye(serverPlayer, serverPlayer.method_37908());
        }
    }
}

