/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.item.relics;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import elocindev.eldritch_end.api.infusion.InfusableItemMaterial;
import elocindev.eldritch_end.api.infusion.InfusionAttributeHolder;
import elocindev.eldritch_end.client.particle.EldritchParticles;
import elocindev.eldritch_end.config.Configs;
import elocindev.eldritch_end.effects.Corruption;
import elocindev.eldritch_end.item.relics.base.CorruptionRelic;
import elocindev.eldritch_end.registry.AttributeRegistry;
import elocindev.eldritch_end.registry.ItemRegistry;
import elocindev.eldritch_end.registry.SoundEffectRegistry;
import elocindev.eldritch_end.worldgen.util.TextUtils;
import elocindev.necronomicon.api.text.TextAPI;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class Xal
extends CorruptionRelic
implements InfusableItemMaterial {
    private final String ATTACK_PROGRESS = "attackProgress";
    private final String TARGET_X = "targetX";
    private final String TARGET_Y = "targetY";
    private final String TARGET_Z = "targetZ";
    private final int ATTACK_DURATION = 94;

    public Xal(class_1792.class_1793 settings) {
        super(settings);
    }

    private int getSurgeProgress(class_1799 stack) {
        return stack.method_7969().method_10550("attackProgress");
    }

    private void shadowSurge(class_1657 player, class_1799 stack, class_1937 world) {
        int targetX = stack.method_7969().method_10550("targetX");
        int targetY = stack.method_7969().method_10550("targetY");
        int targetZ = stack.method_7969().method_10550("targetZ");
        world.method_43128((class_1657)null, (double)targetX, (double)targetY, (double)targetZ, SoundEffectRegistry.ORB_EVENT, player.method_5634(), 1.0f, 1.0f);
        for (class_1297 entity2 : world.method_8390(class_1297.class, new class_238(new class_2338(targetX, targetY, targetZ)).method_1009(6.0, 3.0, 6.0), entity -> true)) {
            entity2.method_5643(Corruption.of(world, Corruption.DAMAGE), Configs.Items.XAL.DAMAGE_PER_STRIKE);
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (stack.method_7969() == null || entity.method_37908().field_9236 || !(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (this.getSurgeProgress(stack) == 43 || this.getSurgeProgress(stack) == 52 || this.getSurgeProgress(stack) == 63) {
            this.shadowSurge(player, stack, world);
        }
        if (this.getSurgeProgress(stack) < 94) {
            stack.method_7969().method_10569("attackProgress", this.getSurgeProgress(stack) + 1);
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_5250 type = TextAPI.Styles.getGradient((class_2561)class_2561.method_43471((String)"item.eldritch_end.xal.type"), (int)1, (int)6043781, (int)9326287, (float)1.0f);
        class_5250 ability_icon = class_2561.method_43473().method_27693("\ua996 ");
        class_5250 ability_damage = class_2561.method_43473().method_27693(Configs.Items.XAL.DAMAGE_PER_STRIKE + " damage").method_10862(TextUtils.Styles.DAMAGE_CORRUPTION);
        tooltip.add((class_2561)type.method_27696(type.method_10866().method_30938(Boolean.valueOf(true))));
        tooltip.add(this.emptyLine());
        class_5250 shadowburst = class_2561.method_43473().method_27693("Shadowburst");
        shadowburst.method_10862(TextUtils.Styles.CORRUPTION_ABILITY);
        ability_icon.method_10852((class_2561)shadowburst);
        tooltip.add((class_2561)ability_icon);
        class_5250 description1 = class_2561.method_43471((String)"item.eldritch_end.xal.shadowburst.1").method_10862(TextUtils.Styles.DESCRIPTION);
        class_5250 description2 = class_2561.method_43471((String)"item.eldritch_end.xal.shadowburst.2").method_10862(TextUtils.Styles.DESCRIPTION);
        tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)description1).method_10852((class_2561)class_2561.method_43470((String)" \ua997 ").method_10852((class_2561)ability_damage)));
        tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)description2));
        tooltip.add(this.emptyLine());
        String appliesto = Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_armor && Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_weapons ? "infusion.eldritch_end.applies_to_all" : (Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_armor ? "infusion.eldritch_end.applies_to_armor" : "infusion.eldritch_end.applies_to_weapons");
        tooltip.add((class_2561)class_2561.method_43471((String)"infusion.eldritch_end.infusable").method_10852((class_2561)class_2561.method_43471((String)appliesto)).method_27693(" (Tier III)").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
    }

    private class_2561 emptyLine() {
        return class_2561.method_43470((String)" ");
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        HashMultimap modifiers = HashMultimap.create((Multimap)super.method_7844(slot));
        UUID uuid = UUID.fromString("399fe278-8564-11ee-b9d1-0242ac120002");
        if (slot == class_1304.field_6173 || slot == class_1304.field_6171) {
            modifiers.put((Object)AttributeRegistry.CORRUPTION, (Object)new class_1322(uuid, "Corruption modifier", 10.0, class_1322.class_1323.field_6328));
        }
        return modifiers;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (itemStack.method_7969() == null) {
            this.createStackNBT(itemStack);
        }
        if (itemStack.method_7969().method_10550("attackProgress") == 94) {
            itemStack.method_7969().method_10569("attackProgress", 0);
            itemStack.method_7969().method_10569("targetX", (int)user.method_19538().field_1352);
            itemStack.method_7969().method_10569("targetY", (int)user.method_19538().field_1351);
            itemStack.method_7969().method_10569("targetZ", (int)user.method_19538().field_1350);
        }
        EldritchParticles.playEffek("shadowsurge", world, user.method_19538(), true, 0.3f).bindOnEntity((class_1297)user);
        user.method_7357().method_7906((class_1792)this, Configs.Items.XAL.COOLDOWN_TICKS);
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    private void createStackNBT(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        nbtCompound.method_10569("attackProgress", 0);
    }

    @Override
    public List<InfusionAttributeHolder> getInfusionAttributes() {
        return List.of(new InfusionAttributeHolder(AttributeRegistry.CORRUPTION, 35.0, InfusionAttributeHolder.Presets.CORRUPTION));
    }

    @Override
    public class_1792 getInfusionTemplate() {
        return ItemRegistry.CORRUPTION_INFUSION_TEMPLATE;
    }

    @Override
    public boolean applyToArmor() {
        return Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_armor;
    }

    @Override
    public boolean applyToWeapons() {
        return Configs.Mechanics.INFUSIONS.corruption_infusion.can_apply_to_weapons;
    }
}

