/*
 * Decompiled with CFR 0.152.
 */
package winterly.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import winterly.Winterly;

public class UpdateChecker {
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().build();
    private static Instant lastCheck = Instant.now().minus(4L, ChronoUnit.HOURS);
    private static String cachedLatest = "0";
    public static boolean updated = false;
    public static class_2561 text = null;

    public static boolean check() {
        if (Winterly.config.updateCheckerEnabled) {
            String string = UpdateChecker.getLocalVersion();
            String string2 = UpdateChecker.getLatestRemote();
            int n = Integer.parseInt(string.replaceAll("\\.", ""));
            int n2 = Integer.parseInt(string2.replaceAll("\\.", ""));
            if (n2 > n) {
                String string3 = class_2477.method_10517().method_48307("itemGroup.winterly.items.button.updated");
                string3 = string3.replaceAll("%local_version%", string);
                string3 = string3.replaceAll("%remote_version%", string2);
                text = class_2561.method_30163((String)string3);
                updated = true;
            }
        }
        return updated;
    }

    static String getLatestRemote() {
        if (ChronoUnit.HOURS.between(lastCheck, Instant.now()) >= 4L) {
            String string = "0";
            Optional<ArrayList<ProjectVersion>> optional = UpdateChecker.getModrinthVersions();
            if (optional.isPresent() && !optional.get().isEmpty()) {
                string = optional.get().get((int)0).versionNumber;
            }
            cachedLatest = string;
            lastCheck = Instant.now();
        }
        return cachedLatest;
    }

    static String getLocalVersion() {
        String string = "1000";
        Optional optional = FabricLoader.getInstance().getModContainer("winterly");
        if (optional.isPresent()) {
            string = ((ModContainer)optional.get()).getMetadata().getVersion().getFriendlyString();
        }
        return string;
    }

    static Optional<ArrayList<ProjectVersion>> getModrinthVersions() {
        try {
            HttpRequest httpRequest = HttpRequest.newBuilder().GET().uri(new URI("https://api.modrinth.com/v2/project/winterly/version")).headers("User-Agent", "tyap-lyap/winterly/" + UpdateChecker.getLocalVersion()).build();
            HttpResponse<InputStream> httpResponse = HTTP_CLIENT.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
            InputStreamReader inputStreamReader = new InputStreamReader(httpResponse.body());
            ProjectVersion[] projectVersionArray = (ProjectVersion[])GSON.fromJson((Reader)inputStreamReader, ProjectVersion[].class);
            ArrayList arrayList = new ArrayList();
            Arrays.asList(projectVersionArray).forEach(projectVersion -> {
                if (projectVersion.gameVersions.contains(class_155.method_16673().method_48019())) {
                    arrayList.add(projectVersion);
                }
            });
            return Optional.of(arrayList);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return Optional.empty();
        }
        catch (Exception exception) {
            Winterly.LOGGER.info("Failed to parse modrinth project versions due to an exception:\n" + exception);
            return Optional.empty();
        }
    }

    static class ProjectVersion {
        public String id = "";
        @SerializedName(value="project_id")
        public String projectId = "";
        @SerializedName(value="author_id")
        public String authorId = "";
        public boolean featured = false;
        public String name = "";
        @SerializedName(value="version_number")
        public String versionNumber = "";
        public String changelog = "";
        @SerializedName(value="changelog_url")
        public String changelogUrl = "";
        @SerializedName(value="date_published")
        public String published = "";
        public int downloads = 0;
        @SerializedName(value="version_type")
        public String versionType = "";
        @SerializedName(value="game_versions")
        public ArrayList<String> gameVersions = new ArrayList();
        public ArrayList<String> loaders = new ArrayList();

        ProjectVersion() {
        }
    }
}

