/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.util;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.content.oxygen.IChargeMode;
import ad_astra_giselle_addon.common.fluid.FluidHelper;
import ad_astra_giselle_addon.common.registry.ObjectRegistry;
import ad_astra_giselle_addon.common.util.ModHooks;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7924;

public class TranslationUtils {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    public static final int DEFAULT_DIGITS = 1;
    private static final Map<CanUseTuple, List<class_2561>> CAN_USES = new HashMap<CanUseTuple, List<class_2561>>();
    private static final Map<Boolean, class_2561> CAN_USE_AVAILABLES = new HashMap<Boolean, class_2561>();
    public static final String CAN_USE = AdAstraGiselleAddon.tl("description", "can_use");
    public static final String CAN_USE_COLD = AdAstraGiselleAddon.tl("description", "can_use.cold");
    public static final String CAN_USE_HOT = AdAstraGiselleAddon.tl("description", "can_use.hot");
    public static final String CAN_USE_AVAILABLE = AdAstraGiselleAddon.tl("can_use", "available");
    public static final String CAN_USE_UNAVAILABLE = AdAstraGiselleAddon.tl("can_use", "unavailable");
    private static final Map<IChargeMode, class_2561> CHANGE_MODES = new HashMap<IChargeMode, class_2561>();
    public static final String CHARGE_MODE = AdAstraGiselleAddon.tl("description", "charge_mode");
    private static final Map<Boolean, class_2561> CREATIVE_OXYGENS = new HashMap<Boolean, class_2561>();
    public static final String CREATIVE_OXYGEN = AdAstraGiselleAddon.tl("description", "creative_oxygen");
    public static final String CREATIVE_OXYGEN_EMPTY = AdAstraGiselleAddon.tl("creative_oxygen", "empty");
    public static final String CREATIVE_OXYGEN_INFINITY = AdAstraGiselleAddon.tl("creative_oxygen", "infinity");

    public static class_2561 getItemTooltip(class_2960 id) {
        return TranslationUtils.getItemTooltip(id.method_12836(), id.method_12832(), "");
    }

    public static class_2561 getItemTooltip(class_2960 id, String suffix) {
        return TranslationUtils.getItemTooltip(id.method_12836(), id.method_12832(), suffix);
    }

    public static class_2561 getItemTooltip(String namespace, String path, String suffix) {
        String tooltipKey = "item." + namespace + "." + path + ".tooltip" + suffix;
        return TranslationUtils.styleItemTooltip((class_2561)class_2561.method_43471((String)tooltipKey));
    }

    public static class_2561 styleItemTooltip(class_2561 component) {
        return class_2561.method_43473().method_10852(component).method_10862(class_2583.field_24360.method_10977(class_124.field_1068));
    }

    public static class_2561 description(String key, class_2561 component) {
        class_5250 value = class_2561.method_43470((String)"").method_27692(class_124.field_1068).method_10852(component);
        return class_2561.method_43471((String)key).method_27692(class_124.field_1078).method_27693(": ").method_10852((class_2561)value);
    }

    public static List<class_2561> descriptionCanUse(boolean canUseOnCold, boolean canUseOnHot) {
        return CAN_USES.computeIfAbsent(new CanUseTuple(canUseOnCold, canUseOnHot), k -> List.of(TranslationUtils.descriptionCanUse(CAN_USE_COLD, k.canUseOnCold()), TranslationUtils.descriptionCanUse(CAN_USE_HOT, k.canUseOnHot())));
    }

    private static class_2561 descriptionCanUse(String key, boolean canUse) {
        return CAN_USE_AVAILABLES.computeIfAbsent(canUse, k -> TranslationUtils.description(key, (class_2561)class_2561.method_43471((String)(k != false ? CAN_USE_AVAILABLE : CAN_USE_UNAVAILABLE)).method_27692(k != false ? class_124.field_1060 : class_124.field_1061)));
    }

    public static class_2561 descriptionChargeMode(IChargeMode mode) {
        if (mode == null) {
            return class_2561.method_43473();
        }
        return CHANGE_MODES.computeIfAbsent(mode, k -> TranslationUtils.description(CHARGE_MODE, k.getDisplayName()));
    }

    public static class_2561 oxygenStorage(long amount, long capacity) {
        long amountMB = FluidConstants.toMillibuckets((long)amount);
        long capacityMB = FluidConstants.toMillibuckets((long)capacity);
        class_2583 style = class_2583.field_24360.method_10977(amountMB > 0L ? class_124.field_1060 : class_124.field_1061);
        return class_2561.method_43469((String)"tooltip.ad_astra.space_suit", (Object[])new Object[]{amountMB, capacityMB}).method_10862(style);
    }

    public static class_2561 descriptionCreativeOxygen(boolean empty) {
        return CREATIVE_OXYGENS.computeIfAbsent(empty, k -> TranslationUtils.description(CREATIVE_OXYGEN, (class_2561)class_2561.method_43471((String)(k != false ? CREATIVE_OXYGEN_EMPTY : CREATIVE_OXYGEN_INFINITY)).method_27692(k != false ? class_124.field_1061 : class_124.field_1060)));
    }

    public static List<class_2561> fluid(FluidContainer container) {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        int size = container.getSize();
        List fluids = container.getFluids();
        for (int i = 0; i < size; ++i) {
            FluidHolder fluid = (FluidHolder)fluids.get(i);
            long capacity = container.getTankCapacity(i);
            list.addAll(TranslationUtils.fluid(fluid, capacity));
        }
        return list;
    }

    public static List<class_2561> fluid(FluidHolder fluid, long capacity) {
        String modid = ObjectRegistry.get(class_7924.field_41270).getId(fluid.getFluid()).method_12836();
        class_2561 name = FluidHelper.getDisplayName(fluid);
        long amountMB = FluidConstants.toMillibuckets((long)fluid.getFluidAmount());
        long capacityMB = FluidConstants.toMillibuckets((long)capacity);
        class_5250 storage = class_2561.method_43469((String)"gauge_text.ad_astra.liquid_storage", (Object[])new Object[]{amountMB, capacityMB});
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add((class_2561)storage.method_10862(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852(class_2561.method_30163((String)", ")).method_10852(name));
        list.add((class_2561)class_2561.method_43470((String)ModHooks.getName(modid)).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1078)));
        return list;
    }

    public static class_2561 formatPercent(double ratio) {
        return class_2561.method_43470((String)NUMBER_FORMAT.format(ratio * 100.0)).method_27693("%");
    }

    private TranslationUtils() {
    }

    static {
        NUMBER_FORMAT.setMinimumFractionDigits(1);
        NUMBER_FORMAT.setMaximumFractionDigits(1);
    }

    private record CanUseTuple(boolean canUseOnCold, boolean canUseOnHot) {
    }
}

