/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.proof;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.content.proof.EntityProofDurationAccessor;
import ad_astra_giselle_addon.common.content.proof.ProofFunction;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2960;

public abstract class ProofAbstractUtils {
    private static final List<ProofAbstractUtils> _PROOFS = new ArrayList<ProofAbstractUtils>();
    public static final List<ProofAbstractUtils> PROOFS = Collections.unmodifiableList(_PROOFS);
    public static final String KEY_PROOF_DURATION = AdAstraGiselleAddon.rl("proof_duration").toString();
    public static final int GENERAL_PROOF_INTERVAL = 10;
    public static final int OXYGEN_PROOF_INTERVAL = 30;
    public static final long OXYGEN_PROOF_USING = FluidConstants.fromMillibuckets((long)1L);
    private final class_2960 id;
    private final String dataKey;
    private final List<ProofFunction> listeners;

    public static void reduceProofDuration(class_1297 entity) {
        for (ProofAbstractUtils proof : PROOFS) {
            int currentDuration = proof.getProofDuration(entity);
            if (currentDuration <= 0) continue;
            proof.setProofDuration(entity, currentDuration - 1);
        }
    }

    protected ProofAbstractUtils(class_2960 id) {
        this.id = id;
        this.dataKey = id.toString();
        this.listeners = new ArrayList<ProofFunction>();
        _PROOFS.add(this);
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getDataKey() {
        return this.dataKey;
    }

    public int getProofDuration(class_1297 entity) {
        return ((EntityProofDurationAccessor)entity).ad_astra_giselle_addon$getProofDuration(this);
    }

    public void setProofDuration(class_1297 entity, int proofDuration) {
        ((EntityProofDurationAccessor)entity).ad_astra_giselle_addon$setProofDuration(this, proofDuration);
    }

    public boolean tryProvideProof(class_1297 entity) {
        if (this.getProofDuration(entity) > 0) {
            return true;
        }
        int proofDuration = this.post(entity);
        if (proofDuration > 0) {
            this.setProofDuration(entity, proofDuration);
            return true;
        }
        return false;
    }

    public void register(ProofFunction event) {
        this.listeners.add(event);
    }

    public boolean unregister(ProofFunction event) {
        return this.listeners.remove(event);
    }

    public int post(class_1297 entity) {
        for (ProofFunction event : this.listeners) {
            int proofFunction = event.provide(entity);
            if (proofFunction <= 0) continue;
            return proofFunction;
        }
        return 0;
    }
}

