/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.compat.CompatibleManager;
import ad_astra_giselle_addon.common.compat.create.BacktankOxygenStorage;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenStorage;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenStorageItem;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.item.CreativeOxygenCanItem;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.item.OxygenCanItem;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class OxygenStorageUtils {
    public static OptionalDouble getStoredRatio(class_1309 living) {
        return OxygenStorageUtils.getStoredRatio(OxygenStorageUtils.stream(living));
    }

    public static OptionalDouble getStoredRatio(Stream<ItemStackHolder> items) {
        ItemStackHolder[] array;
        for (ItemStackHolder stack : array = (ItemStackHolder[])items.toArray(ItemStackHolder[]::new)) {
            if (!OxygenStorageUtils.isInfinifySource(stack.getStack())) continue;
            return OptionalDouble.of(Double.POSITIVE_INFINITY);
        }
        long stored = 0L;
        long capacity = 0L;
        for (ItemStackHolder item : array) {
            IOxygenStorage oxygenStorage;
            if (item.getStack().method_7909() instanceof CreativeOxygenCanItem || (oxygenStorage = OxygenStorageUtils.get(item)) == null) continue;
            stored += oxygenStorage.getOxygenAmount();
            capacity += oxygenStorage.getOxygenCapacity();
        }
        if (capacity == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((double)stored / (double)capacity);
    }

    @Nullable
    public static IOxygenStorage firstExtractable(class_1309 living, long extracting) {
        return OxygenStorageUtils.streamExtractable(living, extracting).findFirst().orElse(null);
    }

    @Nullable
    public static Stream<ItemStackHolder> stream(class_1309 living) {
        class_1937 level = living.method_37908();
        class_2338 pos = living.method_24515();
        boolean isCold = TemperatureApi.API.isCold(level, pos);
        boolean isHot = TemperatureApi.API.isHot(level, pos);
        List<ItemStackReference> items = LivingHelper.getInventoryItems(living);
        return Stream.concat(items.stream().filter(item -> OxygenStorageUtils.isInfinifySource(item.getStack())), items.stream().filter(item -> !(item.getStack().method_7909() instanceof CreativeOxygenCanItem)).filter(item -> {
            IOxygenStorage oxygenStorage = OxygenStorageUtils.get(item);
            return oxygenStorage != null && oxygenStorage.canUse(isCold, isHot);
        }));
    }

    @Nullable
    public static Stream<IOxygenStorage> streamExtractable(class_1309 living, long extracting) {
        return OxygenStorageUtils.stream(living).map(OxygenStorageUtils::get).filter(oxygenStorage -> {
            long extract = oxygenStorage.extractOxygen(living, extracting, true);
            return extract >= extracting;
        });
    }

    public static boolean isInfinifySource(class_1799 item) {
        CreativeOxygenCanItem type;
        class_1792 class_17922 = item.method_7909();
        return class_17922 instanceof CreativeOxygenCanItem && !(type = (CreativeOxygenCanItem)class_17922).getFluidContainer(item).isEmpty();
    }

    @Nullable
    public static IOxygenStorage get(ItemStackHolder item) {
        IOxygenStorage storage;
        class_1792 class_17922 = item.getStack().method_7909();
        if (class_17922 instanceof IOxygenStorageItem) {
            IOxygenStorageItem oxygenStorageItem = (IOxygenStorageItem)class_17922;
            return oxygenStorageItem.getOxygenStorage(item);
        }
        if (CompatibleManager.Create.isLoaded() && (storage = BacktankOxygenStorage.getOxygenStroage(item)) != null) {
            return storage;
        }
        return null;
    }

    public static long insert(class_1309 living, long amount) {
        for (ItemStackReference item : LivingHelper.getSlotItems(living)) {
            if (amount <= 0L) break;
            if (!(item.getStack().method_7909() instanceof OxygenCanItem)) continue;
            ItemFluidContainer tank = FluidContainer.of((ItemStackHolder)item);
            FluidHolder containedStack = tank.getFirstFluid();
            class_3611 insertingFluid = (class_3611)ModFluids.OXYGEN.get();
            if (!containedStack.isEmpty()) {
                insertingFluid = containedStack.getFluid();
            }
            FluidHolder inserting = FluidHolder.of((class_3611)insertingFluid, (long)amount, null);
            long inserted = tank.insertFluid(inserting, false);
            amount -= inserted;
        }
        return amount;
    }

    private OxygenStorageUtils() {
    }
}

