/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.compat.create;

import ad_astra_giselle_addon.common.content.oxygen.IOxygenStorage;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import net.minecraft.class_1309;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class BacktankOxygenStorage
implements IOxygenStorage {
    private final ItemStackHolder holder;
    private final class_1741 material;

    public static IOxygenStorage getOxygenStroage(ItemStackHolder holder) {
        class_1792 class_17922 = holder.getStack().method_7909();
        if (class_17922 instanceof BacktankItem) {
            BacktankItem item = (BacktankItem)class_17922;
            return new BacktankOxygenStorage(holder, item.method_7686());
        }
        return null;
    }

    public BacktankOxygenStorage(ItemStackHolder holder, class_1741 material) {
        this.holder = holder;
        this.material = material;
    }

    @Override
    public long extractOxygen(@Nullable class_1309 living, long amount, boolean simulate) {
        class_1799 stack = this.getHolder().getStack();
        float air = BacktankUtil.getAir((class_1799)stack);
        float neededAir = this.toAir(amount);
        float usingAir = Math.min(air, neededAir);
        if (!simulate) {
            BacktankUtil.consumeAir((class_1309)living, (class_1799)stack, (float)usingAir);
            this.getHolder().setStack(stack);
        }
        return this.toAmount(usingAir);
    }

    @Override
    public long getOxygenAmount() {
        class_1799 stack = this.getHolder().getStack();
        float air = BacktankUtil.getAir((class_1799)stack);
        return this.toAmount(air);
    }

    @Override
    public long getOxygenCapacity() {
        class_1799 stack = this.getHolder().getStack();
        float air = BacktankUtil.maxAir((class_1799)stack);
        return this.toAmount(air);
    }

    private float toAir(long amount) {
        return (float)(FluidConstants.toMillibuckets((long)amount) * 30L) / 20.0f;
    }

    private long toAmount(float air) {
        return (long)(air * 20.0f * (float)FluidConstants.fromMillibuckets((long)1L) / 30.0f);
    }

    @Override
    public boolean canUseOnCold() {
        return true;
    }

    @Override
    public boolean canUseOnHot() {
        return this.getMaterial() == class_1740.field_21977;
    }

    public ItemStackHolder getHolder() {
        return this.holder;
    }

    public class_1741 getMaterial() {
        return this.material;
    }
}

