/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.IWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.content.proof.GravityProofUtils;
import ad_astra_giselle_addon.common.menu.GravityNormalizerMenu;
import ad_astra_giselle_addon.common.registry.AddonProofs;
import ad_astra_giselle_addon.common.util.Vec3iUtils;
import com.mojang.serialization.DynamicOps;
import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GravityNormalizerBlockEntity
extends EnergyContainerMachineBlockEntity
implements IWorkingAreaBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY));
    public static final String DATA_LENGTH_KEY = "length";
    public static final String DATA_OFFSET_KEY = "offset";
    public static final String DATA_TIMER_KEY = "timer";
    public static final String DATA_WORKINGAREA_VISIBLE_KEY = "workingAreaVisible";
    public static final int CONTAINER_SIZE = 1;
    private class_2382 length = new class_2382(3, 3, 3);
    private class_2382 offset = GravityNormalizerBlockEntity.offsetFromLength(this.length);
    private int timer = 0;
    private boolean workingAreaVisible = false;

    public GravityNormalizerBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, 1);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.length = (class_2382)class_2382.field_25123.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580(DATA_LENGTH_KEY)).result().get();
        this.offset = (class_2382)class_2382.field_25123.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580(DATA_OFFSET_KEY)).result().get();
        this.timer = tag.method_10550(DATA_TIMER_KEY);
        this.workingAreaVisible = tag.method_10577(DATA_WORKINGAREA_VISIBLE_KEY);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566(DATA_LENGTH_KEY, (class_2520)class_2382.field_25123.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.length).result().get());
        tag.method_10566(DATA_OFFSET_KEY, (class_2520)class_2382.field_25123.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.offset).result().get());
        tag.method_10569(DATA_TIMER_KEY, this.timer);
        tag.method_10556(DATA_WORKINGAREA_VISIBLE_KEY, this.workingAreaVisible);
    }

    @Nullable
    public class_1703 createMenu(int windowId, class_1661 inv, class_1657 player) {
        return new GravityNormalizerMenu(windowId, inv, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer == null) {
            this.energyContainer = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachinesConfig.GRAVITY_NORMALIZER_ENERGY_CAPACITY, MachinesConfig.GRAVITY_NORMALIZER_ENERGY_CAPACITY)));
        }
        return this.energyContainer;
    }

    public void tick(class_1937 level, long time, class_2680 state, class_2338 pos) {
        super.tick(level, time, state, pos);
        if (this.canFunction()) {
            int timer = this.getTimer();
            if (--timer <= 0) {
                timer = this.getMaxTimer();
                class_238 workingArea = this.getWorkingArea();
                this.doNormalize(workingArea);
                this.sync();
                this.method_5431();
            }
            this.setTimer(timer);
        }
    }

    protected void doNormalize(class_238 workingArea) {
        class_1937 level = this.method_10997();
        GravityProofUtils proof = AddonProofs.GRAVITY;
        long energyUsing = this.getEnergyUsing(workingArea);
        WrappedBlockEnergyContainer energyStorage = this.getEnergyStorage();
        if (energyStorage.internalExtract(energyUsing, true) < energyUsing) {
            return;
        }
        List entities = level.method_8335(null, workingArea);
        if (entities.size() <= 0) {
            return;
        }
        energyStorage.internalExtract(energyUsing, false);
        int proofDuration = this.getMaxTimer() + 1;
        for (class_1297 entity : entities) {
            if (proof.getProofDuration(entity) > proofDuration) continue;
            proof.setProofDuration(entity, proofDuration);
        }
    }

    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pullEnergyNearby((ContainerMachineBlockEntity)this, (class_2338)pos, (long)this.getEnergyStorage().maxInsert(), (ConfigurationEntry)sideConfig.get(0), filter);
    }

    public long getEnergyUsing() {
        return this.getEnergyUsing(this.getWorkingArea());
    }

    public long getEnergyUsing(class_238 workingArea) {
        double blocks = workingArea.method_17939() * workingArea.method_17940() * workingArea.method_17941();
        return (long)(MachinesConfig.GRAVITY_NORMALIZER_ENERGY_PER_BLOCKS * blocks);
    }

    public static int getMinLength() {
        return 1;
    }

    public static int getMaxLength() {
        return MachinesConfig.GRAVITY_NORMALIZER_MAX_LENGTH;
    }

    public class_2382 getLength() {
        return this.length;
    }

    public void setLength(class_2382 length) {
        length = Vec3iUtils.clamp(length, GravityNormalizerBlockEntity.getMinLength(), GravityNormalizerBlockEntity.getMaxLength());
        if (!this.getLength().equals((Object)length)) {
            this.length = length;
            this.sync();
            this.method_5431();
        }
    }

    public static int half(int length) {
        return (length - 1) / 2;
    }

    public static int offsetFromLength(int length) {
        return -GravityNormalizerBlockEntity.half(length);
    }

    public static class_2382 offsetFromLength(class_2382 length) {
        int x = GravityNormalizerBlockEntity.offsetFromLength(length.method_10263());
        int y = 0;
        int z = GravityNormalizerBlockEntity.offsetFromLength(length.method_10260());
        return new class_2382(x, y, z);
    }

    public static int getMinOffset() {
        return -GravityNormalizerBlockEntity.half(MachinesConfig.GRAVITY_NORMALIZER_MAX_LENGTH);
    }

    public static int getMaxOffset() {
        return GravityNormalizerBlockEntity.half(MachinesConfig.GRAVITY_NORMALIZER_MAX_LENGTH);
    }

    public class_2382 getOffset() {
        return this.offset;
    }

    public void setOffset(class_2382 offset) {
        offset = Vec3iUtils.clamp(offset, GravityNormalizerBlockEntity.getMinOffset(), GravityNormalizerBlockEntity.getMaxOffset());
        if (!this.getOffset().equals((Object)offset)) {
            this.offset = offset;
            this.sync();
            this.method_5431();
        }
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int timer) {
        timer = Math.max(timer, 0);
        if (this.getTimer() != timer) {
            this.timer = timer;
        }
    }

    public int getMaxTimer() {
        return MachinesConfig.GRAVITY_NORMALIZER_PROOF_DURATION;
    }

    @Override
    public class_238 getWorkingArea() {
        return this.getWorkingArea(this.method_11016());
    }

    @Override
    public class_238 getWorkingArea(class_2338 pos) {
        class_2382 length = this.getLength();
        class_2382 offset = this.getOffset();
        double x = ((double)length.method_10263() - 1.0) / 2.0;
        double y = ((double)length.method_10264() - 1.0) / 2.0;
        double z = ((double)length.method_10260() - 1.0) / 2.0;
        return new class_238(pos).method_1009(x, y, z).method_989(x + (double)offset.method_10263(), y + (double)offset.method_10264(), z + (double)offset.method_10260());
    }

    @Override
    public boolean isWorkingAreaVisible() {
        return this.workingAreaVisible;
    }

    @Override
    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.workingAreaVisible = visible;
            this.sync();
            this.method_5431();
        }
    }

    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return new int[0];
    }
}

