/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.IRangedWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.entity.VehicleFuelInformation;
import ad_astra_giselle_addon.common.entity.VehicleHelper;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.FluidUtils2;
import ad_astra_giselle_addon.common.item.ItemStackUtils;
import ad_astra_giselle_addon.common.menu.FuelLoaderMenu;
import ad_astra_giselle_addon.common.world.ContainerHelper;
import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.entities.vehicles.Vehicle;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidBlock;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedBlockFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class FuelLoaderBlockEntity
extends ContainerMachineBlockEntity
implements BotariumFluidBlock<WrappedBlockFluidContainer>,
IRangedWorkingAreaBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS), new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_SLOTS), new ConfigurationEntry(ConfigurationType.FLUID, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_FLUID));
    public static final String DATA_WORKINGAREA_VISIBLE_KEY = "workingAreaVisible";
    public static final int[] FLUID_SOURCE_SLOTS = new int[]{0};
    public static final int[] FLUID_SINK_SLOTS = new int[]{1};
    public static final int[] FLUID_SLOTS = ArrayUtils.addAll((int[])FLUID_SOURCE_SLOTS, (int[])FLUID_SINK_SLOTS);
    public static final int CONTAINER_SIZE = FLUID_SLOTS.length;
    private boolean workingAreaVisible;
    private WrappedBlockFluidContainer fluidTank;

    public static List<class_6862<class_3611>> getFluidTags() {
        ArrayList<class_6862<class_3611>> list = new ArrayList<class_6862<class_3611>>();
        list.add(ModFluidTags.TIER_1_ROVER_FUEL);
        Rocket.ROCKET_TO_PROPERTIES.values().stream().map(i -> i.fuel()).forEach(list::add);
        return list;
    }

    public static boolean isFuel(FluidHolder fluidHolder) {
        return FuelLoaderBlockEntity.isFuel(fluidHolder.getFluid());
    }

    public static boolean isFuel(class_3611 fluid) {
        return FuelLoaderBlockEntity.getFluidTags().stream().anyMatch(tag -> FluidPredicates.hasTag(fluid, (class_6862<class_3611>)tag));
    }

    public FuelLoaderBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, CONTAINER_SIZE);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.workingAreaVisible = tag.method_10577(DATA_WORKINGAREA_VISIBLE_KEY);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10556(DATA_WORKINGAREA_VISIBLE_KEY, this.workingAreaVisible);
    }

    @Nullable
    public class_1703 createMenu(int windowId, class_1661 inv, class_1657 player) {
        return new FuelLoaderMenu(windowId, inv, this);
    }

    public WrappedBlockFluidContainer getFluidContainer() {
        if (this.fluidTank == null) {
            this.fluidTank = new WrappedBlockFluidContainer((class_2586)this, (FluidContainer)new SimpleFluidContainer(tank -> FluidConstants.fromMillibuckets((long)MachinesConfig.FUEL_LOADER_FLUID_CAPACITY), 1, (tank, fluid) -> FuelLoaderBlockEntity.isFuel(fluid)));
        }
        return this.fluidTank;
    }

    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
        super.tickSideInteractions(pos, filter, sideConfig);
        TransferUtils.pushItemsNearby((ContainerMachineBlockEntity)this, (class_2338)pos, (int[])FLUID_SOURCE_SLOTS, (ConfigurationEntry)sideConfig.get(0), filter);
        TransferUtils.pullItemsNearby((ContainerMachineBlockEntity)this, (class_2338)pos, (int[])FLUID_SOURCE_SLOTS, (ConfigurationEntry)sideConfig.get(0), filter);
        TransferUtils.pushItemsNearby((ContainerMachineBlockEntity)this, (class_2338)pos, (int[])FLUID_SINK_SLOTS, (ConfigurationEntry)sideConfig.get(1), filter);
        TransferUtils.pullItemsNearby((ContainerMachineBlockEntity)this, (class_2338)pos, (int[])FLUID_SINK_SLOTS, (ConfigurationEntry)sideConfig.get(1), filter);
        WrappedBlockFluidContainer fluidContainer = this.getFluidContainer();
        long fluidCapacity = FluidConstants.fromMillibuckets((long)MachinesConfig.FUEL_LOADER_FLUID_CAPACITY);
        TransferUtils.pushFluidNearby((ContainerMachineBlockEntity)this, (class_2338)pos, (WrappedBlockFluidContainer)fluidContainer, (long)fluidCapacity, (int)0, (ConfigurationEntry)sideConfig.get(2), filter);
        TransferUtils.pullFluidNearby((ContainerMachineBlockEntity)this, (class_2338)pos, (WrappedBlockFluidContainer)fluidContainer, (long)fluidCapacity, (int)0, (ConfigurationEntry)sideConfig.get(2), filter);
    }

    public int method_5444() {
        return 1;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        stack = ItemStackUtils.deriveCount(stack, 1);
        if (ArrayUtils.contains((int[])FLUID_SOURCE_SLOTS, (int)slot)) {
            ItemFluidContainer fluidContainer = FluidContainer.of((ItemStackHolder)new ItemStackHolder(stack));
            if (fluidContainer != null) {
                return fluidContainer.getFluids().stream().anyMatch(FuelLoaderBlockEntity::isFuel);
            }
            return false;
        }
        if (ArrayUtils.contains((int[])FLUID_SINK_SLOTS, (int)slot)) {
            return dir == null;
        }
        return super.method_5492(slot, stack, dir);
    }

    public boolean method_5493(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (ArrayUtils.contains((int[])FLUID_SOURCE_SLOTS, (int)slot)) {
            ItemFluidContainer fluidContainer = FluidContainer.of((ItemStackHolder)new ItemStackHolder(stack));
            if (fluidContainer != null) {
                return !fluidContainer.getFluids().stream().anyMatch(FuelLoaderBlockEntity::isFuel);
            }
        } else if (ArrayUtils.contains((int[])FLUID_SINK_SLOTS, (int)slot)) {
            return dir == null;
        }
        return super.method_5493(slot, stack, dir);
    }

    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        super.serverTick(level, time, state, pos);
        if (this.canFunction()) {
            this.processTank();
            this.exchangeFuelItemAround();
        }
    }

    public void processTank() {
        FluidContainer tank = FluidContainer.of((class_2586)this, null);
        for (int slot : FLUID_SOURCE_SLOTS) {
            ItemFluidContainer source = FluidContainer.of((ItemStackHolder)ContainerHelper.getItem((class_1263)this, slot));
            if (source == null) continue;
            FluidUtils2.moveFluidAny((FluidContainer)source, tank, FuelLoaderBlockEntity::isFuel, false);
        }
        for (int slot : FLUID_SINK_SLOTS) {
            ItemFluidContainer sink = FluidContainer.of((ItemStackHolder)ContainerHelper.getItem((class_1263)this, slot));
            if (sink == null) continue;
            FluidUtils2.moveFluidAny(tank, (FluidContainer)sink, null, false);
        }
    }

    public void exchangeFuelItemAround() {
        class_1937 level = this.method_10997();
        class_238 workingArea = this.getWorkingArea();
        List vehicles = level.method_18467(Vehicle.class, workingArea);
        for (Vehicle vehicle : vehicles) {
            this.giveFuel(vehicle);
        }
    }

    @Override
    public boolean isWorkingAreaVisible() {
        return this.workingAreaVisible;
    }

    @Override
    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.workingAreaVisible = visible;
            this.sync();
            this.method_5431();
        }
    }

    @Override
    public int getWorkingRange() {
        return MachinesConfig.FUEL_LOADER_WORKING_RANGE;
    }

    @Override
    public class_238 getWorkingArea(double range) {
        return this.getWorkingArea(this.method_11016(), range);
    }

    public FluidHolder giveFuel(Vehicle vehicle) {
        return this.giveFuel(vehicle, FluidConstants.fromMillibuckets((long)MachinesConfig.FUEL_LOADER_FLUID_TRANSFER));
    }

    private FluidHolder giveFuel(Vehicle vehicle, long transfer) {
        VehicleFuelInformation fuelInfo = VehicleHelper.getFuelInformation(vehicle);
        if (fuelInfo != null) {
            FluidContainer from = FluidContainer.of((class_2586)this, null);
            FluidHolder moved = FluidUtils2.moveFluidAny(from, fuelInfo.fuelTank(), fluid -> fluid.is(fuelInfo.fuelTag()), transfer, false);
            return moved;
        }
        return FluidHolder.empty();
    }

    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int[] method_5494(class_2350 pSide) {
        return FLUID_SLOTS;
    }
}

