/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client.overlay;

import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.OxygenChargerUtils;
import ad_astra_giselle_addon.common.content.oxygen.OxygenStorageUtils;
import ad_astra_giselle_addon.common.event.EventSystem;
import ad_astra_giselle_addon.common.registry.AddonEnchantments;
import ad_astra_giselle_addon.common.registry.AddonItems;
import ad_astra_giselle_addon.common.util.TranslationUtils;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.client.screens.player.OverlayScreen;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import java.util.Objects;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_746;

public class OxygenCanOverlay {
    public static final EventSystem<ShouldRenderEventListener> SHOULD_RENDER_EVENT = new EventSystem();
    public static final String OXYGENCAN_DESCRIPTION_ID = class_156.method_646((String)"item", (class_2960)AddonItems.OXYGEN_CAN.getId());
    public static final class_2561 INFINITY_TEXT = class_2561.method_43471((String)TranslationUtils.CREATIVE_OXYGEN_INFINITY);

    public static class_2561 getOxygenComponent(double ratio) {
        class_2561 text = OxygenCanOverlay.getRatioText(ratio);
        return class_2561.method_43471((String)OXYGENCAN_DESCRIPTION_ID).method_27693(": ").method_10852(text).method_27694(s -> s.method_36139(class_3532.method_15369((float)((float)(ratio / 3.0)), (float)1.0f, (float)1.0f)));
    }

    public static class_2561 getRatioText(double ratio) {
        return ratio == Double.POSITIVE_INFINITY ? INFINITY_TEXT : TranslationUtils.formatPercent(ratio);
    }

    public static boolean shouldRender(class_746 player) {
        for (ShouldRenderEventListener listener : SHOULD_RENDER_EVENT.getListeners()) {
            if (!listener.shouldRender(player)) continue;
            return true;
        }
        return false;
    }

    public static void renderHud(class_332 guiGraphics, float partialTick) {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null || player.method_7325()) {
            return;
        }
        if (minecraft.field_1690.field_1866) {
            return;
        }
        if (SpaceSuitItem.hasFullSet((class_1309)player) && player.method_6118(class_1304.field_6174).method_7909() instanceof SpaceSuitItem) {
            OxygenStorageUtils.getStoredRatio(OxygenStorageUtils.stream((class_1309)player).filter(item -> {
                IOxygenCharger oxygenCharger = OxygenChargerUtils.get(item);
                return oxygenCharger != null && oxygenCharger.getChargeMode().contains(class_1304.field_6174);
            })).ifPresent(ratio -> {
                class_327 font = minecraft.field_1772;
                class_2561 text = OxygenCanOverlay.getOxygenComponent(ratio);
                int textureWidth = 62;
                int textureHeight = 52;
                int textWidth = font.method_27525((class_5348)text);
                int textX = (int)((float)AdAstraConfigClient.oxygenBarX + (float)(textureWidth - textWidth) / 2.0f);
                Objects.requireNonNull(font);
                int textY = AdAstraConfigClient.oxygenBarY + textureHeight + 9 + 3;
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_22905(AdAstraConfigClient.oxygenBarScale, AdAstraConfigClient.oxygenBarScale, AdAstraConfigClient.oxygenBarScale);
                guiGraphics.method_27535(font, text, Math.max(textX, 0), textY, 0xFFFFFF);
                guiGraphics.method_51448().method_22909();
            });
        } else if (OxygenCanOverlay.shouldRender(player)) {
            OxygenStorageUtils.getStoredRatio((class_1309)player).ifPresent(ratio -> OxygenCanOverlay.renderOxygenCanTank(guiGraphics, minecraft, ratio));
        }
    }

    public static void renderOxygenCanTank(class_332 graphics, class_310 minecraft, double oxygenRatio) {
        int textureWidth = 62;
        int textureHeight = 52;
        int barHeight = (int)(Math.min(oxygenRatio, 1.0) * (double)textureHeight);
        int x = AdAstraConfigClient.oxygenBarX;
        int y = AdAstraConfigClient.oxygenBarY;
        float scale = AdAstraConfigClient.oxygenBarScale;
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22905(scale, scale, scale);
        graphics.method_25290(OverlayScreen.OXYGEN_TANK_EMPTY, x, y, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
        graphics.method_25290(OverlayScreen.OXYGEN_TANK, x, y + textureHeight - barHeight, 0.0f, (float)(textureHeight - barHeight), textureWidth, barHeight, textureWidth, textureHeight);
        class_327 font = minecraft.field_1772;
        class_2561 text = OxygenCanOverlay.getOxygenComponent(oxygenRatio);
        int textWidth = font.method_27525((class_5348)text);
        int textX = (int)((float)x + (float)(textureWidth - textWidth) / 2.0f);
        int textY = y + textureHeight + 3;
        graphics.method_27535(font, text, Math.max(textX, 0), textY, 0xFFFFFF);
        poseStack.method_22909();
    }

    static {
        SHOULD_RENDER_EVENT.register(player -> class_1890.method_8203((class_1887)AddonEnchantments.OXYGEN_PROOF.get(), (class_1309)player) > 0);
    }

    @FunctionalInterface
    public static interface ShouldRenderEventListener {
        public boolean shouldRender(class_746 var1);
    }
}

