/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.config;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.config.Config;
import com.bawnorton.neruina.platform.Platform;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class ConfigManager {
    public static final Path CONFIG_PATH = Platform.getConfigDir().resolve("neruina.json");
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();

    private ConfigManager() {
    }

    public static void loadConfig() {
        Config config = ConfigManager.load();
        if (config.minPermissionLevelForMessages == null) {
            config.minPermissionLevelForMessages = 0;
        }
        if (config.minPermissionLevelForCommands == null) {
            config.minPermissionLevelForCommands = 2;
        }
        if (config.autoKillTickingEntities == null) {
            config.autoKillTickingEntities = false;
        }
        if (config.tickingExceptionThreshold == null) {
            config.tickingExceptionThreshold = 10;
        }
        if (config.handleTickingEntities == null) {
            config.handleTickingEntities = true;
        }
        if (config.handleTickingBlockEntities == null) {
            config.handleTickingBlockEntities = true;
        }
        if (config.handleTickingBlockStates == null) {
            config.handleTickingBlockStates = true;
        }
        if (config.handleTickingItemStacks == null) {
            config.handleTickingItemStacks = true;
        }
        if (config.handleTickingPlayers == null) {
            config.handleTickingPlayers = true;
        }
        Config.update(config);
        ConfigManager.saveConfig();
    }

    private static Config load() {
        Config config = Config.getInstance();
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                Files.createFile(CONFIG_PATH, new FileAttribute[0]);
                return config;
            }
            try {
                config = (Config)GSON.fromJson((Reader)Files.newBufferedReader(CONFIG_PATH), Config.class);
            }
            catch (JsonSyntaxException e) {
                Neruina.LOGGER.error("Failed to parse config file, using default config");
                config = new Config();
            }
        }
        catch (IOException e) {
            Neruina.LOGGER.error("Failed to load config", (Throwable)e);
        }
        return config;
    }

    private static void save() {
        try {
            Files.write(CONFIG_PATH, GSON.toJson((Object)Config.getInstance()).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Neruina.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static void saveConfig() {
        ConfigManager.save();
    }
}

