/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.command;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.config.Config;
import com.bawnorton.neruina.extend.Errorable;
import com.bawnorton.neruina.handler.MessageHandler;
import com.bawnorton.neruina.handler.TickHandler;
import com.bawnorton.neruina.report.GithubAuthManager;
import com.bawnorton.neruina.report.ReportStatus;
import com.bawnorton.neruina.util.ErroredType;
import com.bawnorton.neruina.util.TickingEntry;
import com.bawnorton.neruina.version.Texter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2248;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5242;

public final class NeruinaCommandHandler {
    private static final MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"neruina").requires(source -> source.method_9259(Config.getInstance().minPermissionLevelForCommands.intValue()))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"resume").then(class_2170.method_9247((String)"entity").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(NeruinaCommandHandler::executeResumeEntity)))).then(class_2170.method_9247((String)"block_entity").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(NeruinaCommandHandler::executeResumeBlockEntity)))).then(class_2170.method_9247((String)"block_state").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(NeruinaCommandHandler::executeResumeBlockState)))).then(class_2170.method_9247((String)"item_stack").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9309()).executes(NeruinaCommandHandler::executeResumeHeldItem))))).then(class_2170.method_9247((String)"kill").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9306()).executes(NeruinaCommandHandler::executeKill)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"report").then(class_2170.method_9244((String)"id", (ArgumentType)class_5242.method_27643()).executes(NeruinaCommandHandler::executeReport))).then(class_2170.method_9247((String)"test").executes(NeruinaCommandHandler::executeTestReport)))).then(class_2170.method_9247((String)"cancel_login").executes(NeruinaCommandHandler::executeCancelLogin))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"id").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(NeruinaCommandHandler::executeIdEntity))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(NeruinaCommandHandler::executeIdBlock)))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"id", (ArgumentType)class_5242.method_27643()).executes(NeruinaCommandHandler::executeInfo)))).then(class_2170.method_9247((String)"clear_tracked").executes(NeruinaCommandHandler::executeClear))).then(class_2170.method_9247((String)"show_suspended").executes(NeruinaCommandHandler::executeShowSuspended)));
    }

    private static int executeResumeEntity(CommandContext<class_2168> context) {
        try {
            class_1297 entity = class_2186.method_9313(context, (String)"entity");
            if (!((Errorable)entity).neruina$isErrored()) {
                ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.resume.entity.not_errored", entity.method_5477().getString()));
                return 0;
            }
            Neruina.getInstance().getTickHandler().removeErrored(entity);
            NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.resume.entity", entity.method_5477().getString()));
        }
        catch (CommandSyntaxException ignored) {
            ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.resume.entity.not_found", new Object[0]));
        }
        return 1;
    }

    private static int executeResumeBlockEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 pos = class_2262.method_48299(context, (String)"pos");
        class_2586 blockEntity = ((class_2168)context.getSource()).method_9225().method_8321(pos);
        if (blockEntity == null) {
            ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.resume.block_entity.not_found", messageHandler.posAsNums(pos)));
            return 0;
        }
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_2818 worldChunk = world.method_8500(pos);
        class_2680 state = worldChunk.method_8320(pos);
        class_2248 block = state.method_26204();
        String name = block.method_9518().getString();
        if (!((Errorable)blockEntity).neruina$isErrored()) {
            ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.resume.block_entity.not_errored", name, messageHandler.posAsNums(pos)));
            return 0;
        }
        Neruina.getInstance().getTickHandler().removeErrored(blockEntity);
        worldChunk.method_12216(blockEntity);
        NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.resume.block_entity", name, messageHandler.posAsNums(pos)));
        return 1;
    }

    private static int executeResumeBlockState(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 pos = class_2262.method_48299(context, (String)"pos");
        class_2680 blockState = ((class_2168)context.getSource()).method_9225().method_8320(pos);
        String name = blockState.method_26204().method_9518().getString();
        if (!Neruina.getInstance().getTickHandler().isErrored(blockState, pos)) {
            ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.resume.block_state.not_errored", name, messageHandler.posAsNums(pos)));
            return 0;
        }
        Neruina.getInstance().getTickHandler().removeErrored(blockState, pos);
        NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.resume.block_state", name, messageHandler.posAsNums(pos)));
        return 1;
    }

    private static int executeResumeHeldItem(CommandContext<class_2168> context) {
        try {
            class_3222 player = class_2186.method_9315(context, (String)"player");
            class_1799 stack = player.method_5998(player.method_6058());
            if (!((Errorable)stack).neruina$isErrored()) {
                ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.resume.item_stack.not_errored", player.method_5477().getString(), stack.method_7964().getString()));
                return 0;
            }
            Neruina.getInstance().getTickHandler().removeErrored(stack);
            NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.resume.item_stack", player.method_5477().getString(), stack.method_7964().getString()));
        }
        catch (CommandSyntaxException ignored) {
            ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.resume.entity.not_found", new Object[0]));
        }
        return 1;
    }

    private static int executeKill(CommandContext<class_2168> context) {
        try {
            Collection entities = class_2186.method_9317(context, (String)"entity");
            if (entities.size() == 1) {
                class_1297 entity = (class_1297)entities.iterator().next();
                String name = entity.method_5477().getString();
                if (!((Errorable)entity).neruina$isErrored()) {
                    ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.kill.not_errored", name));
                    return 0;
                }
                Neruina.getInstance().getTickHandler().killEntity(entity, messageHandler.formatText("commands.neruina.kill", name));
            } else {
                int killed = 0;
                for (class_1297 entity : entities) {
                    if (!((Errorable)entity).neruina$isErrored()) continue;
                    Neruina.getInstance().getTickHandler().killEntity(entity, null);
                    ++killed;
                }
                NeruinaCommandHandler.sendFeedback(context, NeruinaCommandHandler.getKilledResultMessage(entities, killed));
            }
        }
        catch (CommandSyntaxException ignored) {
            ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.kill.not_found", new Object[0]));
        }
        return 1;
    }

    private static class_2561 getKilledResultMessage(Collection<? extends class_1297> entities, int killed) {
        int missed = entities.size() - killed;
        class_2561 message = killed == 1 && missed == 1 ? messageHandler.formatText("commands.neruina.kill.multiple.singular_singular", new Object[0]) : (killed == 1 ? messageHandler.formatText("commands.neruina.kill.multiple.singular_plural", missed) : (missed == 1 ? messageHandler.formatText("commands.neruina.kill.multiple.plural_singular", killed) : messageHandler.formatText("commands.neruina.kill.multiple", killed, missed)));
        return message;
    }

    private static int executeReport(CommandContext<class_2168> context) throws CommandSyntaxException {
        UUID id = class_5242.method_27645(context, (String)"id");
        TickingEntry entry = Neruina.getInstance().getTickHandler().getTickingEntry(id);
        if (entry == null) {
            ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.report.not_found", id.toString()));
            return 0;
        }
        try {
            Neruina.getInstance().getAutoReportHandler().createReports(((class_2168)context.getSource()).method_9207(), entry).thenAccept(result -> {
                ReportStatus.Code reportCode = result.code();
                switch (reportCode) {
                    case SUCCESS: {
                        NeruinaCommandHandler.sendFeedback(context, Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(Texter.translatable("commands.neruina.report.success", new Object[0])), messageHandler.generateOpenReportAction(result.message())));
                        break;
                    }
                    case ALREADY_EXISTS: {
                        ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.report.already_exists", new Object[0]));
                        break;
                    }
                    case FAILURE: {
                        ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.report.failure", new Object[0]));
                        break;
                    }
                    case TIMEOUT: {
                        ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.report.timeout", new Object[0]));
                        break;
                    }
                    case ABORTED: {
                        ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.report.aborted", new Object[0]));
                        break;
                    }
                    case IN_PROGRESS: {
                        ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.report.in_progress", new Object[0]));
                        break;
                    }
                }
            });
        }
        catch (Throwable e) {
            ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.report.failure", new Object[0]));
            Neruina.LOGGER.error("Failed to create report", e);
        }
        return 1;
    }

    private static int executeTestReport(CommandContext<class_2168> context) {
        try {
            if (!((class_2168)context.getSource()).method_43737()) {
                return 0;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (!player.method_7334().getId().equals(UUID.fromString("17c06cabbf054adea8d6ed14aaf70545"))) {
                return 0;
            }
            Neruina.getInstance().getAutoReportHandler().testReporting(((class_2168)context.getSource()).method_9207());
            ((class_2168)context.getSource()).method_45068(messageHandler.formatText("commands.neruina.report.test.pass", new Object[0]));
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_45068(messageHandler.formatText("commands.neruina.report.test.fail", new Object[0]));
        }
        return 1;
    }

    private static int executeCancelLogin(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean wasLoggingIn = GithubAuthManager.cancelLogin(((class_2168)context.getSource()).method_9207());
        if (!wasLoggingIn) {
            ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.cancel.not_logging_in", new Object[0]));
            return 0;
        }
        return 1;
    }

    private static int executeIdBlock(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 pos = class_2262.method_48299(context, (String)"pos");
        class_2586 blockEntity = ((class_2168)context.getSource()).method_9225().method_8321(pos);
        Neruina.getInstance().getTickHandler().getTickingEntryId(blockEntity).ifPresentOrElse(uuid -> NeruinaCommandHandler.sendFeedback(context, Texter.withStyle(messageHandler.formatText("commands.neruina.id", uuid.toString()), style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, uuid.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Texter.translatable("commands.neruina.id.tooltip", new Object[0]))))), () -> ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.id.block.not_errored", ((class_2168)context.getSource()).method_9225().method_8320(pos).method_26204().method_9518().getString(), messageHandler.posAsNums(pos))));
        return 1;
    }

    private static int executeIdEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(context, (String)"entity");
        TickHandler tickHandler = Neruina.getInstance().getTickHandler();
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_1799 stack = player.method_5998(player.method_6058());
            tickHandler.getTickingEntryId(stack).ifPresentOrElse(uuid -> NeruinaCommandHandler.sendFeedback(context, Texter.withStyle(messageHandler.formatText("commands.neruina.id", uuid.toString()), style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, uuid.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Texter.translatable("commands.neruina.id.tooltip", new Object[0]))))), () -> ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.id.item_stack.not_errored", player.method_5477().getString(), stack.method_7964().getString())));
        } else {
            tickHandler.getTickingEntryId(entity).ifPresentOrElse(uuid -> NeruinaCommandHandler.sendFeedback(context, Texter.withStyle(messageHandler.formatText("commands.neruina.id", uuid.toString()), style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, uuid.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Texter.translatable("commands.neruina.id.tooltip", new Object[0]))))), () -> ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.id.entity.not_errored", entity.method_5477().getString())));
        }
        return 1;
    }

    private static int executeInfo(CommandContext<class_2168> context) {
        UUID id = class_5242.method_27645(context, (String)"id");
        TickingEntry entry = Neruina.getInstance().getTickHandler().getTickingEntry(id);
        if (entry == null) {
            ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.info.not_found", id.toString()));
            return 0;
        }
        Object cause = entry.getCause();
        if (cause == null) {
            NeruinaCommandHandler.sendFeedback(context, Texter.pad(Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(Texter.translatable("commands.neruina.info.null_cause", entry.getCauseName(), messageHandler.posAsNums(entry.pos()))), messageHandler.generateTeleportAction(ErroredType.UNKNOWN, entry.dimension(), entry.pos()), messageHandler.generateResourceActions(entry))));
        } else if (cause instanceof class_1297) {
            class_1297 entity = (class_1297)cause;
            NeruinaCommandHandler.sendFeedback(context, Texter.pad(Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(Texter.translatable("commands.neruina.info.entity", entry.getCauseName(), messageHandler.posAsNums(entry.pos()))), messageHandler.generateEntityActions(entity), messageHandler.generateResourceActions(entry))));
        } else if (cause instanceof class_2586) {
            NeruinaCommandHandler.sendFeedback(context, Texter.pad(Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(Texter.translatable("commands.neruina.info.block_entity", entry.getCauseName(), messageHandler.posAsNums(entry.pos()))), messageHandler.generateHandlingActions(ErroredType.BLOCK_ENTITY, entry.dimension(), entry.pos()), messageHandler.generateResourceActions(entry))));
        } else if (cause instanceof class_1799) {
            NeruinaCommandHandler.sendFeedback(context, Texter.pad(Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(Texter.translatable("commands.neruina.info.item_stack", entry.getCauseName())), messageHandler.generateResumeAction(ErroredType.ITEM_STACK, entry.uuid().toString()), messageHandler.generateResourceActions(entry))));
        } else {
            NeruinaCommandHandler.sendFeedback(context, Texter.pad(Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(Texter.translatable("commands.neruina.info.unknown", entry.getCauseName())), messageHandler.generateResourceActions(entry))));
        }
        return 1;
    }

    private static int executeClear(CommandContext<class_2168> context) {
        int count = Neruina.getInstance().getTickHandler().clearTracked();
        if (count == 0) {
            ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.clear.none", new Object[0]));
            return 0;
        }
        NeruinaCommandHandler.sendFeedback(context, messageHandler.formatText("commands.neruina.clear", count));
        return 1;
    }

    private static int executeShowSuspended(CommandContext<class_2168> context) {
        int count = Neruina.getInstance().getTickHandler().getTickingEntries().size();
        if (count == 0) {
            ((class_2168)context.getSource()).method_9213(messageHandler.formatText("commands.neruina.show_suspended.none", new Object[0]));
            return 0;
        }
        class_2561 message = messageHandler.generateSuspendedInfo();
        NeruinaCommandHandler.sendFeedback(context, message);
        return 1;
    }

    private static void sendFeedback(CommandContext<class_2168> context, class_2561 text) {
        ((class_2168)context.getSource()).method_9226(() -> text, true);
    }
}

