/*
 * Decompiled with CFR 0.152.
 */
package appbot.botania;

import appbot.AppliedBotanics;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.impl.corporea.AbstractCorporeaNode;

public class MECorporeaNode
extends AbstractCorporeaNode {
    private final MEStorage storage;

    public MECorporeaNode(class_1937 level, class_2338 pos, CorporeaSpark spark, MEStorage storage) {
        super(level, pos, spark);
        this.storage = storage;
    }

    @Nullable
    public static CorporeaNode getNode(class_1937 level, CorporeaSpark spark) {
        if (!(level instanceof class_3218)) {
            return null;
        }
        class_3218 serverLevel = (class_3218)level;
        MEStorage accessor = AppliedBotanics.getInstance().meStorage(serverLevel, spark.getAttachPos()).find(class_2350.field_11036);
        if (accessor != null) {
            return new MECorporeaNode(level, spark.getAttachPos(), spark, accessor);
        }
        return null;
    }

    public List<class_1799> countItems(CorporeaRequest request) {
        return this.work(request, false);
    }

    public List<class_1799> extractItems(CorporeaRequest request) {
        return this.work(request, true);
    }

    protected List<class_1799> work(CorporeaRequest request, boolean execute) {
        IActionSource source;
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        class_1309 class_13092 = request.getEntity();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            source = IActionSource.ofPlayer((class_1657)player);
        } else {
            source = IActionSource.empty();
        }
        if (this.storage == null) {
            return list;
        }
        for (Object2LongMap.Entry entry : this.storage.getAvailableStacks()) {
            int amount = Ints.saturatedCast((long)entry.getLongValue());
            Object object = entry.getKey();
            if (!(object instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)object;
            class_1799 stack = itemKey.toStack();
            if (!request.getMatcher().test(stack)) continue;
            request.trackFound(amount);
            int remainder = Math.min(amount, request.getStillNeeded() == -1 ? amount : request.getStillNeeded());
            if (remainder <= 0) continue;
            request.trackSatisfied(remainder);
            if (execute) {
                if (!this.getSpark().isCreative()) {
                    remainder = (int)this.storage.extract((AEKey)entry.getKey(), (long)remainder, Actionable.MODULATE, source);
                }
                this.getSpark().onItemExtracted(stack);
                request.trackExtracted(remainder);
            }
            while (remainder > 0) {
                int taken = Math.min(remainder, stack.method_7914());
                remainder -= taken;
                list.add(itemKey.toStack(taken));
            }
        }
        return list;
    }
}

