/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.utility;

import com.copycatsplus.copycats.foundation.copycat.CopycatExternalContext;
import com.copycatsplus.copycats.foundation.copycat.model.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.mixin.copycat.VoxelShapeAccessor;
import com.copycatsplus.copycats.utility.MathUtils;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_263;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class BlockFaceUtils {
    private static final ThreadLocal<Map<BiFunction<class_265, class_265, Boolean>, Object2ByteLinkedOpenHashMap<ShapeKey>>> SHAPE_OP_CACHE = ThreadLocal.withInitial(HashMap::new);

    private static boolean invokeCachedOperation(BiFunction<class_265, class_265, Boolean> operation, class_265 fromShape, class_265 toShape) {
        ShapeKey key;
        Object2ByteLinkedOpenHashMap cache = SHAPE_OP_CACHE.get().computeIfAbsent(operation, op -> {
            Object2ByteLinkedOpenHashMap<ShapeKey> cacheMap = new Object2ByteLinkedOpenHashMap<ShapeKey>(2048, 0.25f){

                protected void rehash(int i) {
                }
            };
            cacheMap.defaultReturnValue((byte)127);
            return cacheMap;
        });
        byte result = cache.getAndMoveToFirst((Object)(key = new ShapeKey(fromShape, toShape)));
        if (result == 127) {
            boolean value = operation.apply(fromShape, toShape);
            if (cache.size() >= 2048) {
                cache.removeLastByte();
            }
            cache.putAndMoveToFirst((Object)key, (byte)(value ? 1 : 0));
            return value;
        }
        return result == 1;
    }

    private static boolean processBlockFace(class_1922 level, class_2680 fromState, class_2338 fromPos, class_2680 toState, class_2338 toPos, class_2350 fromFace, BiFunction<class_265, class_265, Boolean> operation) {
        class_265 fromShape = null;
        class_2382 scale = new class_2382(1, 1, 1);
        class_2382 inner = new class_2382(0, 0, 0);
        class_2338 truePos = fromPos;
        if (level instanceof ScaledBlockAndTintGetter) {
            IMultiStateCopycatBlock copycatBlock;
            ScaledBlockAndTintGetter scaledWorld = (ScaledBlockAndTintGetter)level;
            scale = scaledWorld.getScale();
            truePos = scaledWorld.getTruePos(fromPos);
            class_2248 class_22482 = fromState.method_26204();
            if (class_22482 instanceof IMultiStateCopycatBlock && (copycatBlock = (IMultiStateCopycatBlock)class_22482).vectorScale(fromState).equals((Object)scaledWorld.getScale())) {
                String property = scaledWorld.getPropertyForRender(fromState, fromPos);
                if (!copycatBlock.partExists(fromState, property)) {
                    return false;
                }
                inner = copycatBlock.getVectorFromProperty(fromState, property);
                fromShape = copycatBlock.getPartialFaceShape((class_1922)scaledWorld, fromState, property, fromFace);
            }
        }
        if (fromShape == null) {
            fromShape = fromState.method_26173(level, fromPos, fromFace);
        }
        if (fromShape.method_1110()) {
            return false;
        }
        class_265 toShape = null;
        List<Object> potentialParts = null;
        class_2248 class_22483 = toState.method_26204();
        if (class_22483 instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)class_22483;
            class_2382 toScale = copycatBlock.vectorScale(toState);
            class_2350.class_2351 connectingAxis = fromFace.method_10166();
            class_1922 world = level;
            class_2338 toTruePos = toPos;
            String fallbackProperty = copycatBlock.defaultProperty();
            if (level instanceof ScaledBlockAndTintGetter) {
                ScaledBlockAndTintGetter scaledWorld = (ScaledBlockAndTintGetter)level;
                world = scaledWorld.getWrapped();
                toTruePos = scaledWorld.getTruePos(toPos);
                fallbackProperty = scaledWorld.getRenderingProperty();
                if (toTruePos.equals((Object)truePos)) {
                    potentialParts = List.of(scaledWorld.getPropertyForRender(toState, toPos));
                }
            }
            if (potentialParts == null) {
                if (MathUtils.replaceAxis(scale, connectingAxis, 0).equals((Object)MathUtils.replaceAxis(toScale, connectingAxis, 0))) {
                    potentialParts = List.of(copycatBlock.getPropertyFromRender(fallbackProperty, toState, world, MathUtils.replaceAxis(inner, connectingAxis, fromFace.method_10171() == class_2350.class_2352.field_11056 ? 0 : toScale.method_30558(connectingAxis) - 1), toTruePos));
                } else {
                    potentialParts = new ArrayList(4);
                    int connectingPart = fromFace.method_10171() == class_2350.class_2352.field_11056 ? 0 : toScale.method_30558(connectingAxis) - 1;
                    class_2350.class_2351 class_23512 = switch (connectingAxis) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2350.class_2351.field_11048 -> class_2350.class_2351.field_11052;
                        case class_2350.class_2351.field_11052 -> class_2350.class_2351.field_11051;
                        case class_2350.class_2351.field_11051 -> class_2350.class_2351.field_11048;
                    };
                    class_2350.class_2351 axis2 = switch (connectingAxis) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2350.class_2351.field_11048 -> class_2350.class_2351.field_11051;
                        case class_2350.class_2351.field_11052 -> class_2350.class_2351.field_11048;
                        case class_2350.class_2351.field_11051 -> class_2350.class_2351.field_11052;
                    };
                    for (int i = 0; i < toScale.method_30558(class_23512); ++i) {
                        for (int j = 0; j < toScale.method_30558(axis2); ++j) {
                            potentialParts.add(copycatBlock.getPropertyFromRender(fallbackProperty, toState, world, MathUtils.replaceAxis(MathUtils.replaceAxis(new class_2382(connectingPart, connectingPart, connectingPart), class_23512, i), axis2, j), toTruePos));
                        }
                    }
                }
            }
            for (String string : potentialParts) {
                toShape = copycatBlock.getPartialFaceShape(world, toState, string, fromFace.method_10153());
                if (!BlockFaceUtils.invokeCachedOperation(operation, fromShape, toShape)) continue;
                String property = CopycatExternalContext.getPropertyForAppearance();
                if (property == null) {
                    property = copycatBlock.defaultProperty();
                }
                CopycatExternalContext.setPropertyForAppearance(copycatBlock.getPropertyFromRender(property, toState, world, copycatBlock.getVectorFromProperty(toState, string), toTruePos));
                return true;
            }
        }
        if (toShape == null) {
            toShape = toState.method_26173(level, toPos, fromFace.method_10153());
        }
        CopycatExternalContext.setPropertyForAppearance(null);
        return BlockFaceUtils.invokeCachedOperation(operation, fromShape, toShape);
    }

    public static boolean canOcclude(class_1922 level, class_2680 occludedState, class_2338 occludedPos, class_2680 occludingState, class_2338 occludingPos, class_2350 occludedFace) {
        return BlockFaceUtils.processBlockFace(level, occludedState, occludedPos, occludingState, occludingPos, occludedFace, (occluded, occluding) -> !class_259.method_1074((class_265)occluded, (class_265)occluding, (class_247)class_247.field_16886));
    }

    public static boolean faceMatch(class_1922 level, class_2680 fromState, class_2338 fromPos, class_2680 toState, class_2338 toPos, class_2350 fromFace) {
        return BlockFaceUtils.processBlockFace(level, fromState, fromPos, toState, toPos, fromFace, (from, to) -> !class_259.method_1074((class_265)from, (class_265)to, (class_247)class_247.field_16892));
    }

    public static class_265 getPartialFaceShape(class_1922 level, class_2680 state, String property, class_2350 face) {
        IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)state.method_26204();
        class_2382 scale = copycatBlock.vectorScale(state);
        class_2382 part = copycatBlock.getVectorFromProperty(state, property);
        return BlockFaceUtils.getPartialFaceShape(state.method_26201(level, class_2338.field_10980), face, part, scale);
    }

    public static class_265 getPartialFaceShape(class_265 voxelShape, class_2350 direction, class_2382 part, class_2382 scale) {
        int i;
        class_2350.class_2351 axis = direction.method_10166();
        double startX = (double)part.method_10263() / (double)scale.method_10263();
        double startY = (double)part.method_10264() / (double)scale.method_10264();
        double startZ = (double)part.method_10260() / (double)scale.method_10260();
        double sizeX = 1.0 / (double)scale.method_10263();
        double sizeY = 1.0 / (double)scale.method_10264();
        double sizeZ = 1.0 / (double)scale.method_10260();
        double endX = startX + sizeX;
        double endY = startY + sizeY;
        double endZ = startZ + sizeZ;
        class_265 bounds = class_259.method_1081((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ);
        voxelShape = class_259.method_1082((class_265)voxelShape, (class_265)bounds, (class_247)class_247.field_16896);
        int axisSize = ((VoxelShapeAccessor)voxelShape).copycats$getShape().method_1051(axis);
        boolean isEmpty = false;
        if (direction.method_10171() == class_2350.class_2352.field_11056) {
            double d = voxelShape.method_1105(axis);
            isEmpty = DoubleMath.fuzzyCompare((double)d, (double)(switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.class_2351.field_11048 -> endX;
                case class_2350.class_2351.field_11052 -> endY;
                case class_2350.class_2351.field_11051 -> endZ;
            }), (double)1.0E-7) < 0;
            i = class_3532.method_15357((double)class_3532.method_15350((double)((double)axisSize * axis.method_10172(endX, endY, endZ)), (double)-1.0, (double)axisSize)) - 1;
        } else {
            double d = voxelShape.method_1091(axis);
            isEmpty = DoubleMath.fuzzyCompare((double)d, (double)(switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.class_2351.field_11048 -> startX;
                case class_2350.class_2351.field_11052 -> startY;
                case class_2350.class_2351.field_11051 -> startZ;
            }), (double)1.0E-7) > 0;
            i = class_3532.method_15357((double)class_3532.method_15350((double)((double)axisSize * axis.method_10172(startX, startY, startZ)), (double)-1.0, (double)axisSize));
        }
        if (isEmpty) {
            return class_259.method_1073();
        }
        return new class_263(voxelShape, axis, i);
    }

    public record ShapeKey(class_265 fromShape, class_265 toShape) {
    }
}

