/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.stackdeobf.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.booky.stackdeobf.mappings.providers.AbstractMappingProvider;
import dev.booky.stackdeobf.mappings.providers.CustomMappingProvider;
import dev.booky.stackdeobf.mappings.providers.MojangMappingProvider;
import dev.booky.stackdeobf.mappings.providers.QuiltMappingProvider;
import dev.booky.stackdeobf.mappings.providers.YarnMappingProvider;
import dev.booky.stackdeobf.util.VersionData;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.mappingio.format.MappingFormat;

public final class MappingProviderSerializer
implements JsonSerializer<AbstractMappingProvider>,
JsonDeserializer<AbstractMappingProvider> {
    private final VersionData versionData;

    public MappingProviderSerializer(VersionData versionData) {
        this.versionData = versionData;
    }

    public AbstractMappingProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
        String id;
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            Path path = Path.of(obj.get("path").getAsString(), new String[0]);
            MappingFormat format = (MappingFormat)ctx.deserialize(obj.get("mapping-format"), MappingFormat.class);
            return new CustomMappingProvider(this.versionData, path, format);
        }
        EnvType env = FabricLoader.getInstance().getEnvironmentType();
        String envName = env.name().toLowerCase(Locale.ROOT);
        return switch (id = json.getAsString().trim().toLowerCase(Locale.ROOT)) {
            case "mojang" -> new MojangMappingProvider(this.versionData, envName);
            case "yarn" -> new YarnMappingProvider(this.versionData);
            case "quilt" -> new QuiltMappingProvider(this.versionData);
            default -> throw new JsonParseException("Invalid mappings id: " + id);
        };
    }

    public JsonElement serialize(AbstractMappingProvider src, Type typeOfSrc, JsonSerializationContext context) {
        if (src instanceof MojangMappingProvider) {
            return new JsonPrimitive("mojang");
        }
        if (src instanceof YarnMappingProvider) {
            return new JsonPrimitive("yarn");
        }
        if (src instanceof QuiltMappingProvider) {
            return new JsonPrimitive("quilt");
        }
        if (src instanceof CustomMappingProvider) {
            CustomMappingProvider custom = (CustomMappingProvider)src;
            JsonObject obj = new JsonObject();
            obj.addProperty("path", custom.getPath().toString());
            obj.addProperty("mapping-format", custom.getFormat().name());
            return obj;
        }
        throw new UnsupportedOperationException("Unsupported mapping provider: " + src.getName());
    }
}

