/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwSpear;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import org.jetbrains.annotations.NotNull;

public enum SpearsID implements IMeleeWeaponID,
IInnateEnchantment
{
    SPEAR_SPEAR(true, (class_1832)class_1834.field_8923, 4, -2.5f, "minecraft:iron_ingot"),
    SPEAR_WHISPERING_SPEAR(true, (class_1832)class_1834.field_8923, 5, -2.5f, "minecraft:iron_ingot"),
    SPEAR_FORTUNE(true, (class_1832)class_1834.field_8923, 5, -2.5f, "minecraft:iron_ingot");

    private final boolean isEnabled;
    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private SpearsID(boolean isEnabled, class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<SpearsID, McdwSpear> getItemsEnum() {
        return ItemsRegistry.SPEAR_ITEMS;
    }

    public static HashMap<SpearsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SPEAR_SPAWN_RATES;
    }

    public static HashMap<SpearsID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.spearStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.spearStats.get((Object)this).isEnabled;
    }

    public McdwSpear getItem() {
        return SpearsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return SpearsID.getSpawnRates().get(this);
    }

    public HashMap<SpearsID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.spearStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return SpearsID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.spearStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    @Override
    public Map<class_1887, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SPEAR_SPEAR -> Map.of();
            case SPEAR_WHISPERING_SPEAR -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.ECHO});
            case SPEAR_FORTUNE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, class_1893.field_9110);
        };
    }

    @Override
    @NotNull
    public class_1799 getInnateEnchantedStack(class_1792 item) {
        return item.method_7854();
    }

    public McdwSpear makeWeapon() {
        McdwSpear mcdwSpear = new McdwSpear(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        SpearsID.getItemsEnum().put(this, mcdwSpear);
        return mcdwSpear;
    }
}

