/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.api.util;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1887;

public final class EnchantmentRestriction {
    private static final ArrayListMultimap<class_1887, Condition> PERMISSIONS = ArrayListMultimap.create();
    private static final ArrayList<TypeCondition> PERMISSIBLE_TARGETS = new ArrayList();
    private static final ArrayListMultimap<class_1887, Condition> PROHIBITIONS = ArrayListMultimap.create();
    private static final ArrayList<TypeCondition> PROHIBITED_TARGETS = new ArrayList();

    public static void permit(class_1887 enchantment, Condition condition) {
        PERMISSIONS.put((Object)enchantment, (Object)condition);
    }

    public static void permitTarget(TypeCondition typeCondition) {
        PERMISSIBLE_TARGETS.add(typeCondition);
    }

    public static void prohibit(class_1887 enchantment, Condition condition) {
        PROHIBITIONS.put((Object)enchantment, (Object)condition);
    }

    public static void prohibitTarget(TypeCondition typeCondition) {
        PROHIBITED_TARGETS.add(typeCondition);
    }

    public static boolean isPermitted(class_1887 enchantment, class_1799 itemStack) {
        List conditions = PERMISSIONS.get((Object)enchantment);
        for (Condition condition : conditions) {
            if (!condition.isAcceptableItem(itemStack)) continue;
            return true;
        }
        for (TypeCondition typeCondition : PERMISSIBLE_TARGETS) {
            if (!typeCondition.isAcceptableItem(enchantment, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProhibited(class_1887 enchantment, class_1799 itemStack) {
        List conditions = PROHIBITIONS.get((Object)enchantment);
        for (Condition condition : conditions) {
            if (!condition.isAcceptableItem(itemStack)) continue;
            return true;
        }
        for (TypeCondition typeCondition : PROHIBITED_TARGETS) {
            if (!typeCondition.isAcceptableItem(enchantment, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static interface Condition {
        public boolean isAcceptableItem(class_1799 var1);
    }

    public static interface TypeCondition {
        public boolean isAcceptableItem(class_1887 var1, class_1799 var2);
    }
}

