/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.dynamic_resource_bars.DynamicResourceBars;
import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import dev.muon.dynamic_resource_bars.util.EditModeManager;
import dev.muon.dynamic_resource_bars.util.FillDirection;
import dev.muon.dynamic_resource_bars.util.HUDPositioning;
import dev.muon.dynamic_resource_bars.util.HorizontalAlignment;
import dev.muon.dynamic_resource_bars.util.Position;
import dev.muon.dynamic_resource_bars.util.RenderUtil;
import dev.muon.dynamic_resource_bars.util.ScreenRect;
import dev.muon.dynamic_resource_bars.util.SubElementType;
import dev.muon.dynamic_resource_bars.util.TextBehavior;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class AirBarRenderer {
    private static long airTextStartTime = 0L;
    private static boolean shouldShowAirText = false;
    private static boolean airBarSetVisible = true;
    private static long airBarDisabledStartTime = 0L;

    public static ScreenRect getScreenRect(class_1657 player) {
        if (player == null) {
            return new ScreenRect(0, 0, 0, 0);
        }
        ClientConfig config = ModConfigManager.getClient();
        Position anchorPos = HUDPositioning.getPositionFromAnchor(config.airBarAnchor);
        Position finalPos = anchorPos.offset(config.airTotalXOffset, config.airTotalYOffset);
        int backgroundWidth = config.airBackgroundWidth;
        int backgroundHeight = config.airBackgroundHeight;
        return new ScreenRect(finalPos.x(), finalPos.y(), backgroundWidth, backgroundHeight);
    }

    public static ScreenRect getSubElementRect(SubElementType type, class_1657 player) {
        ScreenRect complexRect = AirBarRenderer.getScreenRect(player);
        if (complexRect == null || complexRect.width() == 0 && complexRect.height() == 0) {
            return new ScreenRect(0, 0, 0, 0);
        }
        ClientConfig config = ModConfigManager.getClient();
        int x = complexRect.x();
        int y = complexRect.y();
        switch (type) {
            case BACKGROUND: {
                return new ScreenRect(x + config.airBackgroundXOffset, y + config.airBackgroundYOffset, config.airBackgroundWidth, config.airBackgroundHeight);
            }
            case BAR_MAIN: {
                return new ScreenRect(x + config.airBarXOffset, y + config.airBarYOffset, config.airBarWidth, config.airBarHeight);
            }
            case TEXT: {
                return new ScreenRect(x + config.airTextXOffset, y + config.airTextYOffset, config.airBarWidth, config.airBarHeight);
            }
            case ICON: {
                return new ScreenRect(x + config.airIconXOffset, y + config.airIconYOffset, config.airIconSize, config.airIconSize);
            }
        }
        return new ScreenRect(0, 0, 0, 0);
    }

    public static void render(class_332 graphics, class_1657 player, float partialTicks) {
        float airPercent;
        ClientConfig config = ModConfigManager.getClient();
        int maxAir = player.method_5748();
        int currentAir = player.method_5669();
        AirBarRenderer.setAirBarVisibility(currentAir < maxAir || player.method_5869() || EditModeManager.isEditModeEnabled());
        if (!AirBarRenderer.isAirBarVisible() && !EditModeManager.isEditModeEnabled() && System.currentTimeMillis() - airBarDisabledStartTime > 1500L) {
            return;
        }
        float currentAlphaForRender = AirBarRenderer.getAirBarAlpha();
        if (EditModeManager.isEditModeEnabled() && !AirBarRenderer.isAirBarVisible()) {
            currentAlphaForRender = 1.0f;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)currentAlphaForRender);
        Position airPos = HUDPositioning.getPositionFromAnchor(config.airBarAnchor);
        boolean isRightAnchored = config.airBarAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT;
        airPos = airPos.offset(config.airTotalXOffset, config.airTotalYOffset);
        int backgroundWidth = config.airBackgroundWidth;
        int backgroundHeight = config.airBackgroundHeight;
        int barWidth = config.airBarWidth;
        int barHeight = config.airBarHeight;
        int barOnlyXOffset = config.airBarXOffset;
        int barOnlyYOffset = config.airBarYOffset;
        int iconSize = config.airIconSize;
        int animationCycles = config.airBarAnimationCycles;
        int frameHeightForAnim = config.airBarFrameHeight;
        FillDirection fillDirection = config.airFillDirection;
        int xPos = airPos.x();
        int yPos = airPos.y();
        float ticks = (float)player.field_6012 + partialTicks;
        int animOffset = (int)(ticks / 3.0f % (float)animationCycles) * frameHeightForAnim;
        graphics.method_25290(DynamicResourceBars.loc("textures/gui/air_background.png"), xPos + config.airBackgroundXOffset, yPos + config.airBackgroundYOffset, 0.0f, 0.0f, backgroundWidth, backgroundHeight, 256, 256);
        float f = airPercent = maxAir == 0 ? 0.0f : Math.min(1.0f, (float)currentAir / (float)maxAir);
        if (fillDirection == FillDirection.VERTICAL) {
            int filledHeight = Math.round((float)barHeight * airPercent);
            if (currentAir > 0 && filledHeight == 0) {
                filledHeight = 1;
            }
            if (filledHeight > 0) {
                barRenderX = xPos + barOnlyXOffset;
                int barRenderY = yPos + barOnlyYOffset + (barHeight - filledHeight);
                int textureVOffset = animOffset + (barHeight - filledHeight);
                graphics.method_25290(DynamicResourceBars.loc("textures/gui/air_bar.png"), barRenderX, barRenderY, 0.0f, (float)textureVOffset, barWidth, filledHeight, 256, 1024);
            }
        } else {
            int filledWidth = Math.round((float)barWidth * airPercent);
            if (currentAir > 0 && filledWidth == 0) {
                filledWidth = 1;
            }
            if (filledWidth > 0) {
                int uTexOffset;
                if (isRightAnchored) {
                    barRenderX = xPos + barOnlyXOffset + barWidth - filledWidth;
                    uTexOffset = barWidth - filledWidth;
                } else {
                    barRenderX = xPos + barOnlyXOffset;
                    uTexOffset = 0;
                }
                graphics.method_25290(DynamicResourceBars.loc("textures/gui/air_bar.png"), barRenderX, yPos + barOnlyYOffset, (float)uTexOffset, (float)animOffset, filledWidth, barHeight, 256, 1024);
            }
        }
        if (AirBarRenderer.shouldRenderText() || EditModeManager.isEditModeEnabled()) {
            ScreenRect textRect = AirBarRenderer.getSubElementRect(SubElementType.TEXT, player);
            int textX = textRect.x() + textRect.width() / 2;
            int textY = textRect.y() + textRect.height() / 2;
            int color = AirBarRenderer.getTextColor();
            HorizontalAlignment alignment = config.airTextAlign;
            int baseX = textRect.x();
            if (alignment == HorizontalAlignment.CENTER) {
                baseX = textX;
            } else if (alignment == HorizontalAlignment.RIGHT) {
                baseX = textRect.x() + textRect.width();
            }
            RenderUtil.renderText(currentAir, maxAir, graphics, baseX, textY, color, alignment);
        }
        if (config.enableAirIcon || EditModeManager.isEditModeEnabled()) {
            int displayAir = EditModeManager.isEditModeEnabled() && currentAir >= maxAir ? maxAir / 2 : currentAir;
            AirIcon icon = AirIcon.fromAirValue(displayAir, maxAir);
            ScreenRect iconRect = AirBarRenderer.getSubElementRect(SubElementType.ICON, player);
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/air/" + icon.getTexture() + ".png"), iconRect.x(), iconRect.y(), 0.0f, 0.0f, iconRect.width(), iconRect.height(), iconRect.width(), iconRect.height());
        }
        if (EditModeManager.isEditModeEnabled()) {
            ScreenRect complexRect = AirBarRenderer.getScreenRect(player);
            if (EditModeManager.getFocusedElement() == DraggableElement.AIR_BAR) {
                int focusedBorderColor = -1593835776;
                ScreenRect bgRect = AirBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                graphics.method_49601(bgRect.x() - 1, bgRect.y() - 1, bgRect.width() + 2, bgRect.height() + 2, focusedBorderColor);
                ScreenRect barRect = AirBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                graphics.method_49601(barRect.x() - 1, barRect.y() - 1, barRect.width() + 2, barRect.height() + 2, -1599219482);
                graphics.method_49601(complexRect.x() - 2, complexRect.y() - 2, complexRect.width() + 4, complexRect.height() + 4, -2130706433);
            } else {
                int borderColor = -2130706433;
                graphics.method_49601(complexRect.x() - 1, complexRect.y() - 1, complexRect.width() + 2, complexRect.height() + 2, borderColor);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static int getTextColor() {
        ClientConfig config = ModConfigManager.getClient();
        TextBehavior behavior = config.showAirText;
        long timeSinceNotFull = airTextStartTime > 0L ? System.currentTimeMillis() - airTextStartTime : 0L;
        int baseColor = config.airTextColor & 0xFFFFFF;
        int alpha = config.airTextOpacity;
        if (!(behavior == TextBehavior.WHEN_NOT_FULL && shouldShowAirText || behavior != TextBehavior.WHEN_NOT_FULL || shouldShowAirText)) {
            alpha = (int)((float)alpha * ((float)RenderUtil.calculateTextAlpha(timeSinceNotFull) / 200.0f));
        }
        alpha = (int)((float)alpha * AirBarRenderer.getAirBarAlpha());
        alpha = Math.max(10, Math.min(255, alpha));
        return alpha << 24 | baseColor;
    }

    private static boolean shouldRenderText() {
        long timeSinceFull;
        int maxAir;
        boolean isNotFull;
        TextBehavior behavior = ModConfigManager.getClient().showAirText;
        if (EditModeManager.isEditModeEnabled() && (behavior == TextBehavior.ALWAYS || behavior == TextBehavior.WHEN_NOT_FULL)) {
            return true;
        }
        if (behavior == TextBehavior.NEVER) {
            return false;
        }
        if (behavior == TextBehavior.ALWAYS) {
            return true;
        }
        int currentAir = class_310.method_1551().field_1724.method_5669();
        boolean bl = isNotFull = currentAir < (maxAir = class_310.method_1551().field_1724.method_5748());
        if (isNotFull) {
            shouldShowAirText = true;
            airTextStartTime = System.currentTimeMillis();
            return true;
        }
        if (shouldShowAirText) {
            shouldShowAirText = false;
        }
        return (timeSinceFull = System.currentTimeMillis() - airTextStartTime) < 2000L;
    }

    public static void triggerTextDisplay() {
        airTextStartTime = System.currentTimeMillis();
        shouldShowAirText = true;
    }

    public static void stopTextDisplay() {
        shouldShowAirText = false;
    }

    private static void setAirBarVisibility(boolean visible) {
        if (airBarSetVisible != visible) {
            if (!visible) {
                airBarDisabledStartTime = System.currentTimeMillis();
            }
            airBarSetVisible = visible;
        }
    }

    private static boolean isAirBarVisible() {
        return airBarSetVisible;
    }

    private static float getAirBarAlpha() {
        if (AirBarRenderer.isAirBarVisible()) {
            return 1.0f;
        }
        long timeSinceDisabled = System.currentTimeMillis() - airBarDisabledStartTime;
        if (timeSinceDisabled >= 1500L) {
            return 0.0f;
        }
        return Math.max(0.0f, 1.0f - (float)timeSinceDisabled / 1500.0f);
    }

    private static enum AirIcon {
        NONE("air_0"),
        LOW("air_1"),
        LOW_POP("air_1_pop"),
        MEDIUM("air_2"),
        MEDIUM_POP("air_2_pop"),
        HIGH("air_3"),
        HIGH_POP("air_3_pop"),
        FULL("air_4"),
        FULL_POP("air_4_pop");

        private final String texture;

        private AirIcon(String texture) {
            this.texture = texture;
        }

        public String getTexture() {
            return this.texture;
        }

        public static AirIcon fromAirValue(int airValue, int maxAir) {
            if (airValue <= 0) {
                return NONE;
            }
            if (maxAir <= 0) {
                return NONE;
            }
            float percent = (float)airValue / (float)maxAir;
            float POP_RANGE_RATIO = 0.1f;
            float LOW_UPPER_BOUND = 0.25f;
            float MEDIUM_UPPER_BOUND = 0.5f;
            float HIGH_UPPER_BOUND = 0.75f;
            if (percent > 0.75f) {
                if (percent <= 0.775f) {
                    return FULL_POP;
                }
                return FULL;
            }
            if (percent > 0.5f) {
                if (percent <= 0.525f) {
                    return HIGH_POP;
                }
                return HIGH;
            }
            if (percent > 0.25f) {
                if (percent <= 0.275f) {
                    return MEDIUM_POP;
                }
                return MEDIUM;
            }
            if (percent <= 0.025f) {
                return LOW_POP;
            }
            return LOW;
        }
    }
}

