/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.config.gui;

import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import dev.muon.dynamic_resource_bars.util.ScreenRect;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_8030;

public class ResizeElementScreen
extends class_437 {
    private final class_437 parentScreen;
    private final DraggableElement elementToResize;
    private class_342 bgWidthBox;
    private class_342 bgHeightBox;
    private class_342 bgXOffsetBox;
    private class_342 bgYOffsetBox;
    private class_342 barWidthBox;
    private class_342 barHeightBox;
    private class_342 overlayWidthBox;
    private class_342 overlayHeightBox;

    public ResizeElementScreen(class_437 parent, DraggableElement element) {
        super((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.resize.title_format", (Object[])new Object[]{ResizeElementScreen.getFriendlyElementName(element)}));
        this.parentScreen = parent;
        this.elementToResize = element;
    }

    protected void method_25426() {
        int overlayHeightConf;
        int overlayWidthConf;
        int barHeightConf;
        int barWidthConf;
        int bgYOffsetConf;
        int bgXOffsetConf;
        int bgHeightConf;
        int bgWidthConf;
        super.method_25426();
        ClientConfig config = ModConfigManager.getClient();
        switch (this.elementToResize) {
            case HEALTH_BAR: {
                bgWidthConf = config.healthBackgroundWidth;
                bgHeightConf = config.healthBackgroundHeight;
                bgXOffsetConf = config.healthBackgroundXOffset;
                bgYOffsetConf = config.healthBackgroundYOffset;
                barWidthConf = config.healthBarWidth;
                barHeightConf = config.healthBarHeight;
                overlayWidthConf = config.healthOverlayWidth;
                overlayHeightConf = config.healthOverlayHeight;
                break;
            }
            case STAMINA_BAR: {
                bgWidthConf = config.staminaBackgroundWidth;
                bgHeightConf = config.staminaBackgroundHeight;
                bgXOffsetConf = config.staminaBackgroundXOffset;
                bgYOffsetConf = config.staminaBackgroundYOffset;
                barWidthConf = config.staminaBarWidth;
                barHeightConf = config.staminaBarHeight;
                overlayWidthConf = config.staminaOverlayWidth;
                overlayHeightConf = config.staminaOverlayHeight;
                break;
            }
            case MANA_BAR: {
                bgWidthConf = config.manaBackgroundWidth;
                bgHeightConf = config.manaBackgroundHeight;
                bgXOffsetConf = config.manaBackgroundXOffset;
                bgYOffsetConf = config.manaBackgroundYOffset;
                barWidthConf = config.manaBarWidth;
                barHeightConf = config.manaBarHeight;
                overlayWidthConf = config.manaOverlayWidth;
                overlayHeightConf = config.manaOverlayHeight;
                break;
            }
            default: {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(this.parentScreen);
                }
                return;
            }
        }
        int boxWidth = 50;
        int boxHeight = 20;
        int labelWidth = 100;
        int componentBlockWidth = labelWidth + 5 + boxWidth;
        int startX = this.field_22789 / 2 - componentBlockWidth / 2;
        int editBoxX = startX + labelWidth + 5;
        int currentY = 40;
        int rowSpacing = 5;
        this.bgWidthBox = this.createIntEditBox(editBoxX, currentY, boxWidth, boxHeight, bgWidthConf);
        this.bgHeightBox = this.createIntEditBox(editBoxX, currentY + boxHeight + rowSpacing, boxWidth, boxHeight, bgHeightConf);
        this.bgXOffsetBox = this.createIntEditBox(editBoxX, currentY + 2 * (boxHeight + rowSpacing), boxWidth, boxHeight, bgXOffsetConf, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.bgYOffsetBox = this.createIntEditBox(editBoxX, currentY + 3 * (boxHeight + rowSpacing), boxWidth, boxHeight, bgYOffsetConf, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.method_37063((class_364)this.bgWidthBox);
        this.method_37063((class_364)this.bgHeightBox);
        this.method_37063((class_364)this.bgXOffsetBox);
        this.method_37063((class_364)this.bgYOffsetBox);
        this.barWidthBox = this.createIntEditBox(editBoxX, currentY += 4 * (boxHeight + rowSpacing) + rowSpacing, boxWidth, boxHeight, barWidthConf, 0, 256);
        this.barHeightBox = this.createIntEditBox(editBoxX, currentY + boxHeight + rowSpacing, boxWidth, boxHeight, barHeightConf, 0, 32);
        this.method_37063((class_364)this.barWidthBox);
        this.method_37063((class_364)this.barHeightBox);
        this.overlayWidthBox = this.createIntEditBox(editBoxX, currentY += 2 * (boxHeight + rowSpacing) + rowSpacing, boxWidth, boxHeight, overlayWidthConf, 0, 256);
        this.overlayHeightBox = this.createIntEditBox(editBoxX, currentY + boxHeight + rowSpacing, boxWidth, boxHeight, overlayHeightConf, 0, 256);
        this.method_37063((class_364)this.overlayWidthBox);
        this.method_37063((class_364)this.overlayHeightBox);
        int doneButtonWidth = 100;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - doneButtonWidth / 2, this.field_22790 - boxHeight - 20, doneButtonWidth, boxHeight).method_46431());
    }

    private class_342 createIntEditBox(int x, int y, int width, int height, int configIntValue) {
        return this.createIntEditBox(x, y, width, height, configIntValue, 1, Integer.MAX_VALUE);
    }

    private class_342 createIntEditBox(int x, int y, int width, int height, int configIntValue, int minValue, int maxValue) {
        class_342 editBox = new class_342(this.field_22793, x, y, width, height, (class_2561)class_2561.method_43473());
        editBox.method_1852(String.valueOf(configIntValue));
        editBox.method_1863(text -> {
            try {
                int value = Integer.parseInt(text);
                if (value >= minValue && value <= maxValue) {
                    editBox.method_1868(0xE0E0E0);
                } else {
                    editBox.method_1868(0xFF5555);
                }
            }
            catch (NumberFormatException e) {
                editBox.method_1868(0xFF5555);
            }
        });
        return editBox;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        if (this.bgWidthBox != null) {
            int labelX = this.bgWidthBox.method_46426() - 5 - 100;
            class_5250 class_52502 = class_2561.method_43471((String)"gui.dynamic_resource_bars.resize.label.background_width");
            int n = this.bgWidthBox.method_46427();
            int n2 = this.bgWidthBox.method_25364();
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, (class_2561)class_52502, labelX, n + (n2 - 9) / 2, 0xFFFFFF);
            class_5250 class_52503 = class_2561.method_43471((String)"gui.dynamic_resource_bars.resize.label.background_height");
            int n3 = this.bgHeightBox.method_46427();
            int n4 = this.bgHeightBox.method_25364();
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, (class_2561)class_52503, labelX, n3 + (n4 - 9) / 2, 0xFFFFFF);
            class_5250 class_52504 = class_2561.method_43471((String)"gui.dynamic_resource_bars.resize.label.background_x_offset");
            int n5 = this.bgXOffsetBox.method_46427();
            int n6 = this.bgXOffsetBox.method_25364();
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, (class_2561)class_52504, labelX, n5 + (n6 - 9) / 2, 0xFFFFFF);
            class_5250 class_52505 = class_2561.method_43471((String)"gui.dynamic_resource_bars.resize.label.background_y_offset");
            int n7 = this.bgYOffsetBox.method_46427();
            int n8 = this.bgYOffsetBox.method_25364();
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, (class_2561)class_52505, labelX, n7 + (n8 - 9) / 2, 0xFFFFFF);
            class_5250 class_52506 = class_2561.method_43471((String)"gui.dynamic_resource_bars.resize.label.bar_width");
            int n9 = this.barWidthBox.method_46427();
            int n10 = this.barWidthBox.method_25364();
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, (class_2561)class_52506, labelX, n9 + (n10 - 9) / 2, 0xFFFFFF);
            class_5250 class_52507 = class_2561.method_43471((String)"gui.dynamic_resource_bars.resize.label.bar_height");
            int n11 = this.barHeightBox.method_46427();
            int n12 = this.barHeightBox.method_25364();
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, (class_2561)class_52507, labelX, n11 + (n12 - 9) / 2, 0xFFFFFF);
            class_5250 class_52508 = class_2561.method_43471((String)"gui.dynamic_resource_bars.resize.label.overlay_width");
            int n13 = this.overlayWidthBox.method_46427();
            int n14 = this.overlayWidthBox.method_25364();
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, (class_2561)class_52508, labelX, n13 + (n14 - 9) / 2, 0xFFFFFF);
            class_5250 class_52509 = class_2561.method_43471((String)"gui.dynamic_resource_bars.resize.label.overlay_height");
            int n15 = this.overlayHeightBox.method_46427();
            int n16 = this.overlayHeightBox.method_25364();
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, (class_2561)class_52509, labelX, n15 + (n16 - 9) / 2, 0xFFFFFF);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        boolean unfocusedAny = false;
        for (class_364 listener : this.method_25396()) {
            if (!(listener instanceof class_342)) continue;
            class_342 box = (class_342)listener;
            class_8030 vanillaRect = box.method_48202();
            ScreenRect customRect = new ScreenRect(vanillaRect.method_49620(), vanillaRect.method_49618(), vanillaRect.comp_1196(), vanillaRect.comp_1197());
            if (!box.method_25370() || customRect.contains((int)mouseX, (int)mouseY)) continue;
            box.method_25365(false);
            unfocusedAny = true;
        }
        return unfocusedAny;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.method_25399() != null && this.method_25399().method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        ClientConfig config = ModConfigManager.getClient();
        try {
            switch (this.elementToResize) {
                case HEALTH_BAR: {
                    config.healthBackgroundWidth = this.parseIntSafely(this.bgWidthBox.method_1882(), config.healthBackgroundWidth, 1, Integer.MAX_VALUE);
                    config.healthBackgroundHeight = this.parseIntSafely(this.bgHeightBox.method_1882(), config.healthBackgroundHeight, 1, Integer.MAX_VALUE);
                    config.healthBarWidth = this.parseIntSafely(this.barWidthBox.method_1882(), config.healthBarWidth, 1, 256);
                    config.healthBarHeight = this.parseIntSafely(this.barHeightBox.method_1882(), config.healthBarHeight, 1, 32);
                    config.healthOverlayWidth = this.parseIntSafely(this.overlayWidthBox.method_1882(), config.healthOverlayWidth, 1, 256);
                    config.healthOverlayHeight = this.parseIntSafely(this.overlayHeightBox.method_1882(), config.healthOverlayHeight, 1, 256);
                    config.healthBackgroundXOffset = this.parseIntSafely(this.bgXOffsetBox.method_1882(), config.healthBackgroundXOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    config.healthBackgroundYOffset = this.parseIntSafely(this.bgYOffsetBox.method_1882(), config.healthBackgroundYOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    break;
                }
                case STAMINA_BAR: {
                    config.staminaBackgroundWidth = this.parseIntSafely(this.bgWidthBox.method_1882(), config.staminaBackgroundWidth, 1, Integer.MAX_VALUE);
                    config.staminaBackgroundHeight = this.parseIntSafely(this.bgHeightBox.method_1882(), config.staminaBackgroundHeight, 1, Integer.MAX_VALUE);
                    config.staminaBarWidth = this.parseIntSafely(this.barWidthBox.method_1882(), config.staminaBarWidth, 1, 256);
                    config.staminaBarHeight = this.parseIntSafely(this.barHeightBox.method_1882(), config.staminaBarHeight, 1, 32);
                    config.staminaOverlayWidth = this.parseIntSafely(this.overlayWidthBox.method_1882(), config.staminaOverlayWidth, 1, 256);
                    config.staminaOverlayHeight = this.parseIntSafely(this.overlayHeightBox.method_1882(), config.staminaOverlayHeight, 1, 256);
                    config.staminaBackgroundXOffset = this.parseIntSafely(this.bgXOffsetBox.method_1882(), config.staminaBackgroundXOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    config.staminaBackgroundYOffset = this.parseIntSafely(this.bgYOffsetBox.method_1882(), config.staminaBackgroundYOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    break;
                }
                case MANA_BAR: {
                    config.manaBackgroundWidth = this.parseIntSafely(this.bgWidthBox.method_1882(), config.manaBackgroundWidth, 1, Integer.MAX_VALUE);
                    config.manaBackgroundHeight = this.parseIntSafely(this.bgHeightBox.method_1882(), config.manaBackgroundHeight, 1, Integer.MAX_VALUE);
                    config.manaBarWidth = this.parseIntSafely(this.barWidthBox.method_1882(), config.manaBarWidth, 1, 256);
                    config.manaBarHeight = this.parseIntSafely(this.barHeightBox.method_1882(), config.manaBarHeight, 1, 32);
                    config.manaOverlayWidth = this.parseIntSafely(this.overlayWidthBox.method_1882(), config.manaOverlayWidth, 1, 256);
                    config.manaOverlayHeight = this.parseIntSafely(this.overlayHeightBox.method_1882(), config.manaOverlayHeight, 1, 256);
                    config.manaBackgroundXOffset = this.parseIntSafely(this.bgXOffsetBox.method_1882(), config.manaBackgroundXOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    config.manaBackgroundYOffset = this.parseIntSafely(this.bgYOffsetBox.method_1882(), config.manaBackgroundYOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                }
            }
            config.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parentScreen);
        }
    }

    private int parseIntSafely(String value, int defaultValue, int minValue, int maxValue) {
        try {
            int parsed = Integer.parseInt(value);
            if (parsed < minValue) {
                return minValue;
            }
            if (parsed > maxValue) {
                return maxValue;
            }
            return parsed;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean method_25421() {
        return false;
    }

    private static String getFriendlyElementName(DraggableElement element) {
        if (element == null) {
            return "";
        }
        return switch (element) {
            case DraggableElement.HEALTH_BAR -> class_2561.method_43471((String)"gui.dynamic_resource_bars.element.health_bar").getString();
            case DraggableElement.MANA_BAR -> class_2561.method_43471((String)"gui.dynamic_resource_bars.element.mana_bar").getString();
            case DraggableElement.STAMINA_BAR -> class_2561.method_43471((String)"gui.dynamic_resource_bars.element.stamina_bar").getString();
            default -> element.name();
        };
    }
}

