/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.compat;

import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.api.handler.EventHandler;
import squeek.appleskin.helpers.FoodHelper;

public class AppleSkinCompat {
    private static final boolean APPLESKIN_LOADED = PlatformUtil.isModLoaded("appleskin");

    public static boolean isLoaded() {
        return APPLESKIN_LOADED;
    }

    public static FoodData getFoodValues(class_1799 stack, class_1657 player) {
        if (!APPLESKIN_LOADED || stack.method_7960() || !AppleSkinCompat.canConsume(stack, player)) {
            return FoodData.EMPTY;
        }
        FoodValues modifiedValues = FoodHelper.getModifiedFoodValues((class_1799)stack, (class_1657)player);
        FoodValues defaultValues = FoodHelper.getDefaultFoodValues((class_1799)stack);
        FoodValuesEvent event = new FoodValuesEvent(player, stack, defaultValues, modifiedValues);
        ((EventHandler)FoodValuesEvent.EVENT.invoker()).interact((Object)event);
        modifiedValues = event.modifiedFoodValues;
        return new FoodData(modifiedValues.hunger, modifiedValues.getSaturationIncrement());
    }

    public static boolean canConsume(class_1799 stack, class_1657 player) {
        if (!APPLESKIN_LOADED || stack.method_7960()) {
            return false;
        }
        return FoodHelper.canConsume((class_1799)stack, (class_1657)player);
    }

    public static float getEstimatedHealthRestoration(class_1799 stack, class_1657 player) {
        if (!APPLESKIN_LOADED || !AppleSkinCompat.canConsume(stack, player)) {
            return 0.0f;
        }
        FoodValues modifiedValues = FoodHelper.getModifiedFoodValues((class_1799)stack, (class_1657)player);
        return FoodHelper.getEstimatedHealthIncrement((class_1799)stack, (FoodValues)modifiedValues, (class_1657)player);
    }

    public static class FoodData {
        public static final FoodData EMPTY = new FoodData(0, 0.0f);
        public final int hunger;
        public final float saturation;

        public FoodData(int hunger, float saturation) {
            this.hunger = hunger;
            this.saturation = saturation;
        }

        public boolean isEmpty() {
            return this.hunger <= 0 && this.saturation <= 0.0f;
        }
    }
}

