/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.soulsweaponry.util.LuckChosenObject;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class WeaponUtil {
    public static final class_1887[] DAMAGE_ENCHANTS = new class_1887[]{class_1893.field_9118, class_1893.field_9123, class_1893.field_9112};

    public static int getEnchantDamageBonus(class_1799 stack) {
        for (class_1887 ench : DAMAGE_ENCHANTS) {
            if (class_1890.method_8225((class_1887)ench, (class_1799)stack) <= 0) continue;
            return class_1890.method_8225((class_1887)ench, (class_1799)stack);
        }
        return 0;
    }

    public static boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static boolean isFightModLoaded() {
        return WeaponUtil.isModLoaded("bettercombat") || WeaponUtil.isModLoaded("epicfight");
    }

    public static List<Integer> arrayToList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int t : array) {
            list.add(t);
        }
        return list;
    }

    public static int getChargeTime(class_1799 stack, int remainingUseTicks) {
        int i = WeaponUtil.isModLoaded("epicfight") ? Integer.MAX_VALUE - remainingUseTicks : stack.method_7909().method_7881(stack) - remainingUseTicks;
        return i;
    }

    public static void doConsumerOnCircle(class_1937 world, float yaw, class_243 startPos, double maxYOffset, int ripples, class_241 radiusAndMod, TriConsumer<class_243, Integer, Float> consumer) {
        double minY = startPos.method_10214() - maxYOffset;
        double maxY = startPos.method_10214() + maxYOffset;
        float yawRad = (float)Math.toRadians(yaw);
        for (int wave = 0; wave < ripples; ++wave) {
            double radius = radiusAndMod.field_1343 + (float)wave * radiusAndMod.field_1342;
            int step = class_3532.method_15375((float)(80.0f / ((float)wave + 1.0f)));
            for (int angleDeg = 0; angleDeg < 360; angleDeg += step) {
                float totalRad = yawRad + (float)angleDeg * (float)Math.PI / 180.0f;
                double x = startPos.method_10216() + radius * Math.cos(totalRad);
                double z = startPos.method_10215() + radius * Math.sin(totalRad);
                int warmup = 3 * (wave + 1);
                float spawnYaw = yaw + (float)angleDeg;
                WeaponUtil.doConsumerOnPoint(world, x, z, minY, maxY, warmup, spawnYaw, consumer);
            }
        }
    }

    public static void doConsumerOnLine(class_1937 world, float yaw, class_243 startPos, double maxYOffset, int amount, float spacingModifier, TriConsumer<class_243, Integer, Float> consumer) {
        double minY = startPos.method_10214() - maxYOffset;
        double maxY = startPos.method_10214() + maxYOffset;
        float f = (float)Math.toRadians(yaw);
        for (int i = 0; i < amount; ++i) {
            double h = (double)spacingModifier * (double)(i + 1);
            WeaponUtil.doConsumerOnPoint(world, startPos.method_10216() + (double)class_3532.method_15362((float)f) * h, startPos.method_10215() + (double)class_3532.method_15374((float)f) * h, minY, maxY, -6 + i * 2, yaw, consumer);
        }
    }

    public static void doConsumerOnPoint(class_1937 world, double x, double z, double minY, double maxY, int warmup, float yaw, TriConsumer<class_243, Integer, Float> consumer) {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)maxY, (double)z);
        boolean valid = false;
        double shapeOffset = 0.0;
        do {
            class_2680 blockState2;
            class_265 voxelShape;
            class_2338 blockPos2;
            class_2680 blockState;
            if (!(blockState = world.method_8320(blockPos2 = blockPos.method_10074())).method_26206((class_1922)world, blockPos2, class_2350.field_11036)) continue;
            if (!world.method_22347(blockPos) && !(voxelShape = (blockState2 = world.method_8320(blockPos)).method_26220((class_1922)world, blockPos)).method_1110()) {
                shapeOffset = voxelShape.method_1105(class_2350.class_2351.field_11052);
            }
            valid = true;
            break;
        } while ((blockPos = blockPos.method_10074()).method_10264() >= class_3532.method_15357((double)minY) - 1);
        if (valid) {
            consumer.accept((Object)new class_243(x, (double)blockPos.method_10264() + shapeOffset, z), (Object)warmup, (Object)Float.valueOf(yaw));
        }
    }

    public static int getLuckFactor(class_1309 entity) {
        return class_3532.method_15357((double)(entity.method_26825(class_5134.field_23726) * 2.0 + 2.0));
    }

    @Nullable
    public static <T> T getRandomlyChosenObject(class_1309 user, List<LuckChosenObject<T>> list, boolean flipLuckTypes) {
        ArrayList<LuckChosenObject<T>> projectileList = new ArrayList<LuckChosenObject<T>>();
        int modifier = flipLuckTypes ? -1 : 1;
        for (LuckChosenObject<T> luckChosenObject : list) {
            switch (luckChosenObject.getLuckType().ordinal()) {
                case 2: {
                    luckChosenObject.setLuckFactor(luckChosenObject.getLuckFactor() + modifier * -WeaponUtil.getLuckFactor(user));
                    break;
                }
                case 0: {
                    luckChosenObject.setLuckFactor(luckChosenObject.getLuckFactor() + modifier * WeaponUtil.getLuckFactor(user));
                }
            }
            if (luckChosenObject.getLuckFactor() <= 0) continue;
            projectileList.add(luckChosenObject);
        }
        int totalChance = 0;
        for (LuckChosenObject luckChosenObject : projectileList) {
            totalChance += luckChosenObject.getLuckFactor();
        }
        int n = user.method_6051().method_43048(totalChance);
        boolean bl = false;
        for (LuckChosenObject luckChosenObject : projectileList) {
            if (n >= (var7_12 += luckChosenObject.getLuckFactor())) continue;
            return luckChosenObject.getObject();
        }
        return null;
    }

    public static void launchTarget(class_1309 target, float launchPower, boolean reverse) {
        float f = target.method_36454();
        float g = target.method_36455();
        float rad = (float)Math.PI / 180;
        float h = -class_3532.method_15374((float)(f * rad)) * class_3532.method_15362((float)(g * rad));
        float k = -class_3532.method_15374((float)(g * rad));
        float l = class_3532.method_15362((float)(f * rad)) * class_3532.method_15362((float)(g * rad));
        float m = class_3532.method_15355((float)(h * h + k * k + l * l));
        float n = 3.0f * (launchPower / 4.0f);
        h *= n / m;
        k *= n / m;
        l *= n / m;
        if (reverse) {
            h = -h;
            k = -k;
            l = -l;
        }
        target.method_5762((double)h, (double)k, (double)l);
    }

    @Nullable
    public static class_1322 makeAttribute(class_1320 attr, class_1304 slot, float amount) {
        if (amount == 0.0f) {
            return null;
        }
        String seed = String.format("soulsweapons:%s:%s", attr.method_26830(), slot.method_5923().toUpperCase());
        UUID uuid = UUID.nameUUIDFromBytes(seed.getBytes(StandardCharsets.UTF_8));
        return new class_1322(uuid, attr.method_26830() + " " + slot.method_5923(), (double)amount, class_1322.class_1323.field_6328);
    }

    @Nullable
    public static class_1322 makeAttribute(class_1320 attr, class_1304 slot, float[] perSlotValues) {
        int idx = switch (slot) {
            case class_1304.field_6169 -> 3;
            case class_1304.field_6174 -> 2;
            case class_1304.field_6172 -> 1;
            case class_1304.field_6166 -> 0;
            default -> throw new IllegalArgumentException("Unexpected slot " + String.valueOf(slot));
        };
        double amount = perSlotValues[idx];
        return WeaponUtil.makeAttribute(attr, slot, (float)amount);
    }

    public static List<class_1299<?>> getEntityListOffArray(String[] array) {
        Set<String> stringSet = Set.of(array);
        return stringSet.stream().map(str -> {
            class_2960 entityId = new class_2960((String)(str.contains(":") ? str : "minecraft:" + str));
            return (class_1299)class_7923.field_41177.method_10223(entityId);
        }).collect(Collectors.toList());
    }

    public static enum LuckType {
        GOOD,
        NEUTRAL,
        BAD;

    }
}

