/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.BleedData;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class Skofnung
extends ModdedSword {
    public static final String EMPOWERED = "empowered_attacks_left";

    public Skofnung(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, (int)ConfigConstructor.skofnung_damage, ConfigConstructor.skofnung_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.DISABLE_HEAL, TooltipAbilities.SHARPEN, TooltipAbilities.IS_SHARPENED);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (this.isDisabled(stack)) {
            return super.method_7873(stack, target, attacker);
        }
        int duration = (int)(ConfigConstructor.skofnung_disable_heal_duration + (float)(WeaponUtil.getEnchantDamageBonus(stack) * 40));
        target.method_6092(new class_1293(EffectRegistry.DISABLE_HEAL, duration, 0));
        if (Skofnung.isEmpowered(stack)) {
            BleedData.addBleed(target, (int)ConfigConstructor.skofnung_empowered_bleed_post_hit);
            target.method_6092(new class_1293(EffectRegistry.BLEED, (int)ConfigConstructor.skofnung_empowered_bleed_effect_duration, (int)ConfigConstructor.skofnung_empowered_bleed_effect_amp));
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                if (!player.method_7357().method_7904((class_1792)this)) {
                    this.reduceEmpowered(stack, player.method_37908(), attacker);
                    player.method_7357().method_7906((class_1792)this, 5);
                }
            } else {
                this.reduceEmpowered(stack, attacker.method_37908(), attacker);
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        if (slot == class_1304.field_6173 && Skofnung.isEmpowered(stack)) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)(ConfigConstructor.skofnung_damage + (ConfigConstructor.skofnung_bonus_damage - 1.0f)), class_1322.class_1323.field_6328));
            builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)this.getAttackSpeed(), class_1322.class_1323.field_6328));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.getAttributeModifiers(stack, slot);
    }

    public static boolean isEmpowered(class_1799 stack) {
        return stack.method_7985() && stack.method_7969().method_10545(EMPOWERED) && stack.method_7969().method_10550(EMPOWERED) > 0 && !ConfigConstructor.disable_use_skofnung;
    }

    public static Integer empAttacksLeft(class_1799 stack) {
        if (Skofnung.isEmpowered(stack)) {
            return stack.method_7969().method_10550(EMPOWERED);
        }
        return 0;
    }

    private void reduceEmpowered(class_1799 stack, class_1937 world, class_1309 attacker) {
        if (Skofnung.isEmpowered(stack)) {
            stack.method_7969().method_10569(EMPOWERED, stack.method_7969().method_10550(EMPOWERED) - 1);
            if (stack.method_7969().method_10550(EMPOWERED) <= 0) {
                world.method_8396(null, attacker.method_24515(), class_3417.field_14905, class_3419.field_15248, 0.75f, 1.0f);
            }
        }
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_skofnung;
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_skofnung;
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return null;
    }
}

