/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.gun;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5819;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.SilverBulletEntity;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.items.ITooltipInfo;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import org.jetbrains.annotations.Nullable;

public abstract class GunItem
extends class_1811
implements IConfigDisable,
ITooltipInfo {
    protected final List<TooltipAbilities> tooltipAbilities = new ArrayList<TooltipAbilities>();

    public GunItem(class_1792.class_1793 settings) {
        super(settings);
        this.addTooltipAbility(TooltipAbilities.GUN_ITEM);
    }

    public Predicate<class_1799> method_19268() {
        return stack -> stack.method_31574(ItemRegistry.SILVER_BULLET) && stack.method_7947() >= this.getBulletsNeeded((class_1799)stack);
    }

    public int getReducedCooldown(class_1799 stack) {
        return class_1890.method_8225((class_1887)EnchantRegistry.FAST_HANDS, (class_1799)stack) * 8;
    }

    public abstract int getPostureLoss(class_1799 var1);

    public abstract float getBulletDamage(class_1799 var1);

    public abstract float getBulletVelocity(class_1799 var1);

    public abstract float getBulletDivergence(class_1799 var1);

    public abstract int getCooldown(class_1799 var1);

    public abstract boolean method_24358();

    public int method_7881(class_1799 stack) {
        return 0;
    }

    public int getBulletsNeeded(class_1799 stack) {
        return 1;
    }

    public int getBulletsNeededWithInfinity(class_1799 stack) {
        return 1;
    }

    public class_1665 createSilverBulletEntity(class_1937 world, class_1309 shooter, class_1799 gunStack) {
        if (class_1890.method_8225((class_1887)EnchantRegistry.MISFIRE_CURSE, (class_1799)gunStack) > 0 && !world.field_9236 && shooter.method_6051().method_43058() < ConfigConstructor.misfire_curse_enchant_trigger_chance) {
            world.method_8537(null, shooter.method_23317(), shooter.method_23323(0.5), shooter.method_23321(), 3.0f, true, class_1937.class_7867.field_40890);
            shooter.method_5639(3);
        }
        float power = this.getCalculatedDamage(this.getBulletDamage(gunStack), gunStack);
        int ethereal = class_1890.method_8225((class_1887)EnchantRegistry.ETHEREAL, (class_1799)gunStack);
        int explosivePower = class_1890.method_8225((class_1887)EnchantRegistry.EXPLOSIVE_ROUNDS, (class_1799)gunStack);
        int chainLightningLevel = class_1890.method_8225((class_1887)EnchantRegistry.CHAIN_LIGHTNING, (class_1799)gunStack);
        int blightCarrierLevel = class_1890.method_8225((class_1887)EnchantRegistry.BLIGHT_CARRIER, (class_1799)gunStack);
        int freezeLevel = class_1890.method_8225((class_1887)EnchantRegistry.FROSTSILVER, (class_1799)gunStack);
        int phantomTraceLevel = class_1890.method_8225((class_1887)EnchantRegistry.PHANTOM_TRACE, (class_1799)gunStack);
        int tetherLevel = class_1890.method_8225((class_1887)EnchantRegistry.TETHER, (class_1799)gunStack);
        int ricochetLevel = class_1890.method_8225((class_1887)EnchantRegistry.RICOCHET, (class_1799)gunStack);
        SilverBulletEntity entity = this.getModdedProjectile(world, shooter, gunStack);
        entity.method_23327(shooter.method_23317(), shooter.method_23320() - (double)0.4f, shooter.method_23321());
        entity.field_7572 = class_1665.class_1666.field_7592;
        entity.setMaxAge(this.getProjectileMaxAge());
        if (ethereal > 0) {
            entity.method_7433(true);
            entity.setEthereal(true);
            entity.setMaxAge(this.getProjectileMaxAgeEthereal());
        }
        entity.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454(), 0.0f, this.getBulletVelocity(gunStack), this.getBulletDivergence(gunStack));
        entity.setPostureLoss(this.getPostureLoss(gunStack));
        entity.method_7438(power);
        if (explosivePower > 0) {
            entity.setExplosionPower(explosivePower);
        }
        if (chainLightningLevel > 0) {
            entity.setChainLightningDamage(this.getBulletDamage(gunStack) * (float)chainLightningLevel * ConfigConstructor.chain_lightning_enchant_damage_mod_per_level);
            entity.setChainLightningRange((float)chainLightningLevel * ConfigConstructor.chain_lightning_enchant_range_per_level);
        }
        if (blightCarrierLevel > 0) {
            entity.setBlightCarrier((int)((float)blightCarrierLevel * ConfigConstructor.blight_carrier_enchant_blight_per_level));
        }
        if (freezeLevel > 0) {
            entity.setFreezeAmplifier((int)((float)freezeLevel * ConfigConstructor.frostsilver_enchant_permafrost_per_level));
        }
        if (tetherLevel > 0 && ricochetLevel == 0) {
            entity.setTether(tetherLevel);
        }
        if (ricochetLevel > 0) {
            entity.setRicochetBounces((int)((float)ricochetLevel * ConfigConstructor.ricochet_enchant_bounce_per_level));
        }
        if (phantomTraceLevel > 0) {
            for (int i = 1; i < phantomTraceLevel + 1; ++i) {
                SilverBulletEntity copy = this.getModdedProjectile(world, shooter, gunStack);
                copy.method_5878((class_1297)entity);
                copy.method_7433(ethereal > 0);
                copy.setEthereal(ethereal > 0);
                copy.method_5826(UUID.randomUUID());
                copy.setEchoCopy(true);
                copy.setEchoCopyTimer(10 * i);
                copy.setMaxEchoDelay(10 * i);
                copy.method_7438(this.getCalculatedDamage(this.getBulletDamage(gunStack) * ConfigConstructor.phantom_trace_enchant_phantom_projectile_damage_mod, gunStack));
                world.method_8649((class_1297)copy);
            }
        }
        return entity;
    }

    @Nullable
    public class_1799 canShoot(class_1657 user, class_1799 stack) {
        boolean infinity = class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)stack) > 0;
        boolean bl = user.method_31549().field_7477 || infinity && this.getBulletsNeededWithInfinity(stack) <= 0;
        class_1799 bullet = this.getProjectileType(user, stack);
        if (!bullet.method_7960() || bl) {
            if (bullet.method_7960()) {
                return new class_1799((class_1935)ItemRegistry.SILVER_BULLET);
            }
            int toRemove = bl ? 0 : this.getBulletsNeeded(stack);
            class_1792 bulletItem = ItemRegistry.SILVER_BULLET;
            if (infinity) {
                return bullet;
            }
            for (int slot = 0; slot < user.method_31548().method_5439() && toRemove > 0; ++slot) {
                class_1799 slotStack = user.method_31548().method_5438(slot);
                if (!slotStack.method_31574(bulletItem)) continue;
                int removed = Math.min(slotStack.method_7947(), toRemove);
                slotStack.method_7934(removed);
                toRemove -= removed;
            }
            return bullet;
        }
        return null;
    }

    public class_1799 getProjectileType(class_1657 player, class_1799 stack) {
        class_1799 slotStack;
        int needed = this.getBulletsNeeded(stack);
        class_1792 bulletItem = ItemRegistry.SILVER_BULLET;
        Predicate heldPred = this.method_20310();
        class_1799 held = class_1811.method_18815((class_1309)player, (Predicate)heldPred);
        if (!held.method_7960()) {
            return held;
        }
        int totalFound = 0;
        for (int slot = 0; !(slot >= player.method_31548().method_5439() || (slotStack = player.method_31548().method_5438(slot)).method_31574(bulletItem) && (totalFound += slotStack.method_7947()) >= needed); ++slot) {
        }
        if (totalFound < needed) {
            if (player.method_31549().field_7477) {
                return new class_1799((class_1935)bulletItem, needed);
            }
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)bulletItem, needed);
    }

    public SilverBulletEntity getModdedProjectile(class_1937 world, class_1309 shooter, class_1799 gunStack) {
        return new SilverBulletEntity(world, shooter, gunStack);
    }

    public void spawnShotParticles(class_1937 world, class_1657 user, int amount, float spread) {
        class_243 look = user.method_5720();
        class_243 eyePos = user.method_33571();
        class_243 muzzle = eyePos.method_1019(look);
        class_5819 rand = user.method_6051();
        for (int i = 0; i < amount; ++i) {
            double vx = look.field_1352 + rand.method_43059() * (double)spread;
            double vy = look.field_1351 + rand.method_43059() * (double)spread;
            double vz = look.field_1350 + rand.method_43059() * (double)spread;
            if (i % 2 == 0) {
                world.method_8466((class_2394)class_2398.field_11240, true, muzzle.field_1352, muzzle.field_1351, muzzle.field_1350, vx, vy, vz);
            } else {
                world.method_8466((class_2394)class_2398.field_11251, true, muzzle.field_1352, muzzle.field_1351, muzzle.field_1350, vx, vy, vz);
            }
            world.method_8466((class_2394)class_2398.field_11251, true, muzzle.field_1352, muzzle.field_1351, muzzle.field_1350, vx, vy, vz);
        }
    }

    public void postShot(class_1937 world, class_1657 user, class_1799 stack) {
        world.method_8396(user, user.method_24515(), class_3417.field_15152, class_3419.field_15248, 1.0f, 1.0f);
        stack.method_7956(this.getStackDamageToApply(), (class_1309)user, p_220045_0_ -> p_220045_0_.method_20236(user.method_6058()));
        user.method_7259(class_3468.field_15372.method_14956((Object)this));
        if (!user.method_7337()) {
            user.method_7357().method_7906((class_1792)this, this.getCooldown(stack));
        }
    }

    public float getCalculatedDamage(float resultDamage, class_1799 gunStack) {
        return resultDamage / this.getBulletVelocity(gunStack) + (float)class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)gunStack) / 2.0f;
    }

    public int getStackDamageToApply() {
        return 1;
    }

    public int getProjectileMaxAge() {
        return 60;
    }

    public int getProjectileMaxAgeEthereal() {
        return 25;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (this.isDisabled(stack)) {
            tooltip.add((class_2561)class_2561.method_48321((String)"tooltip.soulsweapons.disabled", (String)"Disabled"));
        }
        this.appendTooltipAbilities(stack, world, tooltip, context);
        super.method_7851(stack, world, tooltip, context);
    }

    @Override
    public List<TooltipAbilities> getTooltipAbilities() {
        return this.tooltipAbilities;
    }

    @Override
    public void addTooltipAbility(TooltipAbilities ... abilities) {
        Collections.addAll(this.tooltipAbilities, abilities);
    }

    @Override
    public class_2561[] getAdditionalTooltips() {
        return new class_2561[0];
    }

    public int method_24792() {
        return 15;
    }

    public int method_7837() {
        return 7;
    }
}

