/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.bow;

import java.util.function.Supplier;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_638;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.arrow.ChargedArrow;
import net.soulsweaponry.items.ModdedBow;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;

public class Galeforce
extends ModdedBow
implements IKeybindAbility {
    public Galeforce(class_1792.class_1793 settings, Supplier<class_1856> repairIngredientSupplier) {
        super(settings, repairIngredientSupplier);
        this.addTooltipAbility(TooltipAbilities.GALEFORCE);
        this.configure(new RangedConfig((int)ConfigConstructor.galeforce_pull_time_ticks, ConfigConstructor.galeforce_damage, ConfigConstructor.galeforce_max_velocity));
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_galeforce;
    }

    @Override
    @Nullable
    public class_1665 getModifiedProjectile(class_1937 world, class_1799 bowStack, class_1799 arrowStack, class_1309 shooter, class_1665 originalArrow) {
        shooter.method_6092(new class_1293(class_1294.field_5904, (int)ConfigConstructor.galeforce_speed_effect_duration_ticks, (int)(ConfigConstructor.galeforce_speed_effect_amplifier - 1.0f)));
        return new ChargedArrow(world, shooter, false);
    }

    @Override
    public void useKeybindAbilityServer(class_3218 world, class_1799 stack, class_1657 player) {
        if (!player.method_6059(EffectRegistry.COOLDOWN)) {
            class_1799 arrowStack;
            if (!player.method_7337()) {
                int cooldown = (int)Math.max(ConfigConstructor.galeforce_dash_min_cooldown, ConfigConstructor.galeforce_dash_cooldown - (float)(this.getReduceCooldownEnchantLevel(stack) * 8));
                player.method_6092(new class_1293(EffectRegistry.COOLDOWN, cooldown, 0));
            }
            if ((arrowStack = player.method_18808(stack)).method_7960()) {
                arrowStack = new class_1799((class_1935)class_1802.field_8107);
            }
            if (player.method_6052() != null) {
                class_1309 target = player.method_6052();
                double x = target.method_23317() - player.method_23317();
                double y = target.method_23320() - player.method_23323(1.0);
                double z = target.method_23321() - player.method_23321();
                this.shootArrow(world, stack, arrowStack, player, new class_243(x, y, z));
            } else {
                this.shootArrow(world, stack, arrowStack, player, null);
            }
        }
    }

    private void shootArrow(class_3218 world, class_1799 stack, class_1799 arrowStack, class_1657 player, @Nullable class_243 currentTargetPos) {
        player.method_6092(new class_1293(class_1294.field_5904, (int)ConfigConstructor.galeforce_speed_effect_duration_ticks, (int)(ConfigConstructor.galeforce_speed_effect_amplifier - 1.0f)));
        ChargedArrow chargedArrow = new ChargedArrow((class_1937)world, (class_1309)player, true);
        if (chargedArrow.canHaveArrowEffects(arrowStack, stack)) {
            chargedArrow.method_7459(arrowStack);
        }
        chargedArrow.method_23327(player.method_23317(), player.method_23318() + 1.5, player.method_23321());
        if (currentTargetPos != null) {
            chargedArrow.method_7485(currentTargetPos.method_10216(), currentTargetPos.method_10214(), currentTargetPos.method_10215(), ConfigConstructor.galeforce_max_velocity, 1.0f);
        } else {
            chargedArrow.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, ConfigConstructor.galeforce_max_velocity, 1.0f);
        }
        chargedArrow.method_7439(true);
        double damage = (float)class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)stack) * 0.6f + ConfigConstructor.galeforce_damage / ConfigConstructor.galeforce_max_velocity;
        chargedArrow.method_7438(damage);
        int punch = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)stack);
        if (punch > 0) {
            chargedArrow.method_7449(punch);
        }
        if (class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)stack) > 0) {
            chargedArrow.method_5639(8);
        }
        stack.method_7956(1, (class_1309)player, p_220045_0_ -> p_220045_0_.method_20236(player.method_6058()));
        chargedArrow.field_7572 = class_1665.class_1666.field_7594;
        world.method_8649((class_1297)chargedArrow);
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.4f + 1.2f) + 0.5f);
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
    }

    @Override
    public void useKeybindAbilityClient(class_638 world, class_1799 stack, class_1657 player) {
        if (!player.method_6059(EffectRegistry.COOLDOWN)) {
            WeaponUtil.launchTarget((class_1309)player, 2.0f, false);
        }
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_galeforce;
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return ConfigConstructor.galeforce_dash_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return ConfigConstructor.galeforce_dash_enchant_reduces_cooldown_ids;
    }
}

