/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_5134;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public abstract class BladeDanceItem
extends ModdedSword {
    public BladeDanceItem(class_1832 toolMaterial, int attackDamage, float ingameAttackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, ingameAttackSpeed, settings);
        this.addTooltipAbility(TooltipAbilities.GLAIVE_DANCE);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (this.isDisabled(stack)) {
            return super.method_7873(stack, target, attacker);
        }
        int amp = attacker.method_6059(EffectRegistry.BLADE_DANCE) ? attacker.method_6112(EffectRegistry.BLADE_DANCE).method_5578() + 1 : 0;
        amp = Math.min(amp, this.getMaxStacks() - 1);
        attacker.method_6092(new class_1293(EffectRegistry.BLADE_DANCE, 160, amp));
        if (!WeaponUtil.isFightModLoaded() && amp + 1 == this.getMaxStacks()) {
            int counter = 0;
            if (stack.method_7985()) {
                counter = stack.method_7969().method_10545("AOECounter") ? stack.method_7969().method_10550("AOECounter") : 0;
            }
            stack.method_7948().method_10569("AOECounter", counter + 1);
            if (stack.method_7969().method_10550("AOECounter") >= 3) {
                for (class_1297 entity : attacker.method_37908().method_8335((class_1297)attacker, attacker.method_5829().method_1009(2.0, 1.0, 2.0))) {
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 living = (class_1309)entity;
                    living.method_5643(attacker.method_48923().method_48812(attacker), this.getTotalDamage(stack));
                }
                for (int i = 0; i < 360; i += 30) {
                    float r = 2.0f;
                    double x0 = attacker.method_23317();
                    double z0 = attacker.method_23321();
                    double x = x0 + (double)r * Math.cos((double)i * Math.PI / 180.0);
                    double z = z0 + (double)r * Math.sin((double)i * Math.PI / 180.0);
                    ParticleHandler.singleParticle(attacker.method_37908(), (class_2394)class_2398.field_11227, x, attacker.method_23323(0.5), z, 0.0, 0.0, 0.0);
                }
                stack.method_7969().method_10569("AOECounter", 0);
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        if (slot == class_1304.field_6173) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)this.getTotalDamage(stack), class_1322.class_1323.field_6328));
            builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)this.getTotalAttackSpeed(stack), class_1322.class_1323.field_6328));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.method_7844(slot);
    }

    public static void updateBladeDanceItem(class_1799 stack, int effectAmplifier) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BladeDanceItem) {
            BladeDanceItem item = (BladeDanceItem)class_17922;
            stack.method_7948().method_10548("BladeDanceBonusDamage", item.getBonusDamagePerStack() * (float)effectAmplifier);
            stack.method_7948().method_10548("BladeDanceBonusAttackSpeed", item.getBonusAttackSpeedPerStack() * (float)effectAmplifier);
        }
    }

    public abstract float getBonusDamagePerStack();

    public abstract float getBonusAttackSpeedPerStack();

    public abstract int getMaxStacks();

    public abstract void applyMaxStacksEffects(class_1309 var1, class_1799 var2);

    public abstract int getMaxStacksCooldown();

    public float getTotalDamage(class_1799 stack) {
        float damage = this.method_8020();
        if (stack.method_7985() && stack.method_7969().method_10545("BladeDanceBonusDamage")) {
            damage += stack.method_7969().method_10583("BladeDanceBonusDamage");
        }
        return damage;
    }

    public float getTotalAttackSpeed(class_1799 stack) {
        float attackSpeed = this.getAttackSpeed();
        if (stack.method_7985() && stack.method_7969().method_10545("BladeDanceBonusAttackSpeed")) {
            attackSpeed += stack.method_7969().method_10583("BladeDanceBonusAttackSpeed");
        }
        return attackSpeed;
    }
}

