/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entitydata;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.soulsweaponry.api.entitystats.EntityPosture;
import net.soulsweaponry.entitydata.IEntityDataSaver;
import net.soulsweaponry.networking.PacketIds;

public class PostureData {
    public static final String POSTURE_ID = "posture";
    public static final String MAX_POSTURE_ID = "max_posture";

    public static void addPostureLoss(class_1309 entity, int amount) {
        if (!(EntityPosture.isPostureDisabled(entity) || entity.method_29504() || entity.method_37908().field_9236)) {
            int newAmount = EntityPosture.getPostureLoss(entity, amount);
            PostureData.addPostureLoss((IEntityDataSaver)entity, newAmount);
        }
    }

    private static void addPostureLoss(IEntityDataSaver entity, int amount) {
        int posture;
        class_2487 nbt = entity.getPersistentData();
        if (!nbt.method_10545(POSTURE_ID)) {
            nbt.method_10569(POSTURE_ID, 0);
        }
        posture = (posture = nbt.method_10550(POSTURE_ID)) < 0 ? 0 : (posture += amount);
        nbt.method_10569(POSTURE_ID, posture);
        if (entity instanceof class_3222) {
            PostureData.syncData(posture, (class_3222)entity);
        }
    }

    public static int getPosture(class_1309 entity) {
        IEntityDataSaver target = (IEntityDataSaver)entity;
        if (!target.getPersistentData().method_10545(POSTURE_ID)) {
            target.getPersistentData().method_10569(POSTURE_ID, 0);
        }
        return target.getPersistentData().method_10550(POSTURE_ID);
    }

    public static void reducePosture(class_1309 entity, int amount) {
        PostureData.addPostureLoss(entity, -amount);
    }

    public static void setPosture(IEntityDataSaver entity, int amount) {
        class_2487 nbt = entity.getPersistentData();
        nbt.method_10569(POSTURE_ID, amount);
        if (entity instanceof class_3222) {
            PostureData.syncData(amount, (class_3222)entity);
        }
    }

    public static void syncData(int data, class_3222 entity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(data);
        ServerPlayNetworking.send((class_3222)entity, (class_2960)PacketIds.POSTURE_SYNC, (class_2540)buf);
    }

    public static int getMaxPosture(class_1657 entity) {
        IEntityDataSaver target = (IEntityDataSaver)entity;
        if (!target.getPersistentData().method_10545(MAX_POSTURE_ID)) {
            target.getPersistentData().method_10569(MAX_POSTURE_ID, 0);
        }
        return target.getPersistentData().method_10550(MAX_POSTURE_ID);
    }

    public static void updateMaxPosture(class_1657 entity, int amount) {
        class_2487 nbt = ((IEntityDataSaver)entity).getPersistentData();
        nbt.method_10569(MAX_POSTURE_ID, amount);
        if (entity instanceof class_3222) {
            PostureData.syncMaxPosture(amount, (class_3222)entity);
        }
    }

    public static void syncMaxPosture(int data, class_3222 entity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(data);
        ServerPlayNetworking.send((class_3222)entity, (class_2960)PacketIds.MAX_POSTURE_SYNC, (class_2540)buf);
    }
}

