/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.util;

import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class RandomSummonPos {
    private final class_1937 world;
    private final class_5819 random;
    private final int spawnAmount;
    private final int maxFails;
    private final class_2338 start;
    private final int radius;
    private final int minYOffset;
    private final int maxYOffset;
    private final Consumer<class_243> consumer;

    public RandomSummonPos(class_1937 world, class_5819 random, int spawnAmount, int maxFails, class_2338 start, int radius, int minYOffset, int maxYOffset, Consumer<class_243> consumer) {
        this.world = world;
        this.random = random;
        this.spawnAmount = spawnAmount;
        this.maxFails = maxFails;
        this.start = start;
        this.radius = radius;
        this.minYOffset = minYOffset;
        this.maxYOffset = maxYOffset;
        this.consumer = consumer;
    }

    public void applySummonSpawns() {
        int spawns = 0;
        int fails = 0;
        while (spawns < this.spawnAmount && fails < this.maxFails) {
            class_2338 blockPos = this.getRandomValidSpawn();
            if (blockPos != null) {
                class_243 pos = blockPos.method_46558();
                this.consumer.accept(pos);
                ++spawns;
                continue;
            }
            ++fails;
        }
    }

    @Nullable
    public class_2338 getRandomValidSpawn() {
        int xOffset = this.random.method_43048(this.radius * 2) - this.radius;
        int zOffset = this.random.method_43048(this.radius * 2) - this.radius;
        int spawnX = this.start.method_10263() + xOffset;
        int spawnZ = this.start.method_10260() + zOffset;
        int minY = this.start.method_10264() - this.minYOffset;
        int maxY = this.start.method_10264() + this.maxYOffset;
        class_2338 spawnPos = null;
        for (int y = maxY; y >= minY; --y) {
            class_2338 currentPos = new class_2338(spawnX, y, spawnZ);
            if (!this.isValidSpawn(currentPos)) continue;
            spawnPos = currentPos;
            break;
        }
        return spawnPos;
    }

    public boolean isValidSpawn(class_2338 pos) {
        return this.world.method_8320(pos).method_26215() && !this.world.method_8320(pos.method_10074()).method_26215();
    }
}

