/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.soulsweaponry.api.entitystats.EntityPosture;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.IPostureLossProjectile;
import net.soulsweaponry.entity.projectile.NonArrowProjectile;
import net.soulsweaponry.entitydata.PostureData;
import net.soulsweaponry.items.abilities.ChainLightning;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class SilverBulletEntity
extends NonArrowProjectile
implements GeoEntity,
IPostureLossProjectile {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int postureLoss;
    private boolean isEthereal;
    private float explosionPower;
    private float chainLightningDamage;
    private float chainLightningRange;
    private int blightCarrier;
    private int freezeAmplifier;
    private int tether;
    private int maxEchoDelay;
    private int maxAge = 60;
    private static final class_2940<Boolean> ECHO_COPY = class_2945.method_12791(SilverBulletEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ECHO_TIMER = class_2945.method_12791(SilverBulletEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> RICOCHET_BOUNCES = class_2945.method_12791(SilverBulletEntity.class, (class_2941)class_2943.field_13327);

    public SilverBulletEntity(class_1299<? extends SilverBulletEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public SilverBulletEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(EntityRegistry.SILVER_BULLET_ENTITY_TYPE, owner, world, stack);
    }

    public SilverBulletEntity(class_1299<? extends SilverBulletEntity> entityType, class_1937 world, class_1309 owner, class_1799 stack) {
        super(entityType, owner, world, stack);
    }

    public void method_5773() {
        if (this.isEchoCopy()) {
            this.reduceEchoCopyTimer();
            if (this.getEchoCopyTimer() > 0) {
                float spread = this.method_17681() * 0.1f;
                if (this.method_37908().field_9236) {
                    this.method_37908().method_8406((class_2394)class_2398.field_22246, this.method_23317(), this.method_23323(0.5), this.method_23321(), (double)(this.field_5974.method_43057() * spread - spread / 2.0f), (double)(this.field_5974.method_43057() * spread - spread / 2.0f), (double)(this.field_5974.method_43057() * spread - spread / 2.0f));
                }
                return;
            }
        }
        if (this.method_7441()) {
            this.method_36457(0.0f);
            this.method_36456(0.0f);
            class_243 currentPos = this.method_19538();
            class_243 velocity = this.method_18798();
            class_243 nextPos = currentPos.method_1019(velocity);
            class_3966 entityHit = class_1675.method_18075((class_1297)this, (class_243)currentPos, (class_243)nextPos, (class_238)this.method_5829().method_18804(velocity).method_1014(1.0), e -> e instanceof class_1309 && e != this.method_24921(), (double)5.0);
            if (entityHit != null) {
                this.method_7454(entityHit);
                return;
            }
        }
        super.method_5773();
        if (this.method_7441()) {
            this.method_36457(0.0f);
            this.method_36456(0.0f);
        }
        if (!this.field_7588) {
            class_243 vec3d = this.method_18798();
            double e2 = vec3d.field_1352;
            double f = vec3d.field_1351;
            double g = vec3d.field_1350;
            for (int i = 0; i < 2; ++i) {
                this.method_37908().method_8406((class_2394)(this.isEchoCopy() ? ParticleRegistry.ECHO_SMOKE : class_2398.field_11251), this.method_23317() + e2 * (double)i / 4.0, this.method_23318() + f * (double)i / 4.0 + 0.25, this.method_23321() + g * (double)i / 4.0, -e2 * 0.2, (-f + 0.2) * 0.2, -g * 0.2);
            }
        }
        if (this.field_6012 > this.getMaxAge() || this.field_7576 >= 10) {
            this.method_31472();
        }
    }

    public void method_36209() {
        super.method_36209();
        for (int i = 0; i < 4; ++i) {
            float spread = this.method_17681() * 0.3f;
            this.method_37908().method_8406((class_2394)class_2398.field_22246, this.method_23317(), this.method_23323(0.5), this.method_23321(), (double)(this.field_5974.method_43057() * spread - spread / 2.0f), (double)(this.field_5974.method_43057() * spread - spread / 2.0f), (double)(this.field_5974.method_43057() * spread - spread / 2.0f));
        }
    }

    protected void method_7488(class_239 hitResult) {
        class_3966 entityHitResult;
        class_239.class_240 type = hitResult.method_17783();
        if (this.isEchoCopy() && type == class_239.class_240.field_1331 && (entityHitResult = (class_3966)hitResult).method_17782() == this.method_24921()) {
            return;
        }
        super.method_7488(hitResult);
    }

    public boolean method_5740() {
        return true;
    }

    protected class_3414 method_7440() {
        return class_3417.field_15026;
    }

    public boolean method_5753() {
        return true;
    }

    protected void method_24920(class_3965 blockHitResult) {
        if (this.getRicochetBounces() > 0) {
            class_243 newDir;
            class_1309 owner;
            class_1309 target;
            this.setRicochetBounces(this.getRicochetBounces() - 1);
            Predicate<class_1309> isPet = e -> {
                class_1297 patt0$temp = this.method_24921();
                if (!(patt0$temp instanceof class_1309)) return false;
                class_1309 owner = (class_1309)patt0$temp;
                if (!(e instanceof class_1321)) return false;
                class_1321 tame = (class_1321)e;
                if (tame.method_35057() == null) return false;
                if (!tame.method_35057().equals((Object)owner)) return false;
                return true;
            };
            class_1309 newTarget = null;
            class_1297 class_12972 = this.method_24921();
            if (class_12972 instanceof class_1309 && (target = (owner = (class_1309)class_12972).method_6052()) != null && target.method_5805() && !isPet.test(target) && this.canSee(target) && target != owner) {
                newTarget = target;
            }
            if (newTarget == null) {
                double searchRadius = 8.0;
                class_238 box = this.method_5829().method_1014(searchRadius);
                List candidates = this.method_37908().method_8390(class_1309.class, box, e -> e.method_5805() && e != this.method_24921() && !isPet.test((class_1309)e));
                newTarget = candidates.stream().filter(this::canSee).min(Comparator.comparingDouble(e -> e.method_5858((class_1297)this))).orElse(null);
            }
            if (newTarget != null) {
                class_243 from = this.method_19538();
                class_243 to = newTarget.method_19538().method_1031(0.0, (double)newTarget.method_17682() * 0.5, 0.0);
                newDir = to.method_1020(from).method_1029();
            } else {
                class_2382 face = blockHitResult.method_17780().method_10163();
                class_243 normal = new class_243((double)face.method_10263(), (double)face.method_10264(), (double)face.method_10260()).method_1029();
                class_243 incoming = this.method_18798().method_1029();
                class_243 reflect = incoming.method_1020(normal.method_1021(2.0 * incoming.method_1026(normal))).method_1029();
                double jitterStrength = 0.2;
                class_243 randVec = new class_243(this.field_5974.method_43059(), this.field_5974.method_43059(), this.field_5974.method_43059()).method_1029();
                class_243 perp = randVec.method_1020(reflect.method_1021(randVec.method_1026(reflect))).method_1029();
                newDir = reflect.method_1019(perp.method_1021(jitterStrength)).method_1029();
            }
            double oldSpeed = this.method_18798().method_1033();
            double newSpeed = Math.max(oldSpeed - 1.5, 1.5);
            class_243 vel = newDir.method_1021(newSpeed);
            this.method_18799(vel);
            this.field_6007 = true;
            return;
        }
        super.method_24920(blockHitResult);
        this.method_31472();
    }

    private boolean canSee(class_1309 e) {
        class_243 start = this.method_19538();
        class_243 end = e.method_19538().method_1031(0.0, (double)e.method_17682() * 0.5, 0.0);
        class_3965 ray = this.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        return ray.method_17783() == class_239.class_240.field_1333;
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        class_1297 posture2;
        class_1309 target;
        class_1297 class_12972 = entityHitResult.method_17782();
        if (class_12972 instanceof class_1309) {
            class_1297 class_12973;
            target = (class_1309)class_12972;
            this.applyPostureLoss(target);
            int posture2 = PostureData.getPosture(target);
            if (!EntityPosture.isPostureDisabled(target) && posture2 >= EntityPosture.getMaxPostureLoss(target)) {
                this.onPostureBreak(target);
            }
            if (target.method_5999()) {
                this.method_7438(this.method_7448() + (double)ConfigConstructor.silver_bullet_undead_bonus_damage / this.method_18798().method_1033());
            }
            if ((class_12973 = this.method_24921()) instanceof class_1309) {
                class_1309 owner = (class_1309)class_12973;
                if (this.chainLightningDamage > 0.0f) {
                    ChainLightning.trigger(this.method_37908(), target, owner, false, this.getChainLightningDamage(), this.getChainLightningRange());
                }
            }
            if (this.getBlightCarrier() > 0) {
                class_1293 instance = target.method_6112(EffectRegistry.BLIGHT);
                if (instance != null) {
                    target.method_6092(new class_1293(EffectRegistry.BLIGHT, (int)ConfigConstructor.blight_carrier_enchant_blight_duration, instance.method_5578() + this.getBlightCarrier() - 1));
                } else {
                    target.method_6092(new class_1293(EffectRegistry.BLIGHT, (int)ConfigConstructor.blight_carrier_enchant_blight_duration, this.getBlightCarrier() - 1));
                }
            }
        }
        super.method_7454(entityHitResult);
        if (this.getTether() > 0 && (posture2 = entityHitResult.method_17782()) instanceof class_1309) {
            target = (class_1309)posture2;
            class_1297 shooter = this.method_24921();
            if (shooter instanceof class_1309) {
                double minRange;
                double resistanceFactor = Math.max(0.0, 1.0 - target.method_26825(class_5134.field_23718));
                class_243 toShooter = new class_243(shooter.method_23317() - target.method_23317(), 0.0, shooter.method_23321() - target.method_23321());
                double distance = toShooter.method_1033();
                if (distance > (minRange = (double)(1.0f + (float)this.getTether() * ConfigConstructor.tether_enchant_min_activation_range_per_level))) {
                    double pullStrength = (double)((float)this.getTether() * ConfigConstructor.tether_enchant_drag_mod) * resistanceFactor;
                    class_243 pullVel = toShooter.method_1029().method_1021(pullStrength);
                    double maxAllowedPull = distance - minRange;
                    if (pullVel.method_1033() > maxAllowedPull) {
                        pullVel = pullVel.method_1029().method_1021(maxAllowedPull);
                    }
                    target.method_5762(pullVel.field_1352, 0.1, pullVel.field_1350);
                }
            }
        }
        if (this.explosionPower > 0.0f && !this.method_37908().field_9236) {
            ParticleHandler.particleOutburst(this.method_37908(), 30, this.method_23317(), this.method_23318(), this.method_23321(), (class_2394)class_2398.field_23114, new class_243(1.0, 1.0, 1.0), 0.6f);
            this.method_37908().method_8437(this.method_24921(), this.method_23317(), this.method_23318(), this.method_23321(), this.explosionPower, ConfigConstructor.explosive_rounds_enchant_destroys_blocks ? class_1937.class_7867.field_40890 : class_1937.class_7867.field_40888);
        }
        this.method_31472();
    }

    private void onPostureBreak(class_1309 target) {
        if (this.getFreezeAmplifier() > 0) {
            target.method_6092(new class_1293(EffectRegistry.FREEZING, (int)ConfigConstructor.frostsilver_enchant_permafrost_duration, this.getFreezeAmplifier() - 1));
            target.method_37908().method_8396(null, target.method_24515(), class_3417.field_28606, class_3419.field_15251, 1.0f, 1.0f);
        }
    }

    @Override
    public int getMaxAge() {
        return this.maxAge + this.getMaxEchoDelay();
    }

    @Override
    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("postureLoss")) {
            this.setPostureLoss(nbt.method_10550("postureLoss"));
        }
        if (nbt.method_10545("ethereal")) {
            this.isEthereal = nbt.method_10577("ethereal");
        }
        if (nbt.method_10545("explosionPower")) {
            this.explosionPower = nbt.method_10583("explosionPower");
        }
        if (nbt.method_10545("chainLightningDamage")) {
            this.chainLightningDamage = nbt.method_10583("chainLightningDamage");
        }
        if (nbt.method_10545("chainLightningRange")) {
            this.chainLightningRange = nbt.method_10583("chainLightningRange");
        }
        if (nbt.method_10545("blightCarrier")) {
            this.blightCarrier = nbt.method_10550("blightCarrier");
        }
        if (nbt.method_10545("freezeAmplifier")) {
            this.freezeAmplifier = nbt.method_10550("freezeAmplifier");
        }
        if (nbt.method_10545("echoCopy")) {
            this.setEchoCopy(nbt.method_10577("echoCopy"));
        }
        if (nbt.method_10545("echoCopyTimer")) {
            this.setEchoCopyTimer(nbt.method_10550("echoCopyTimer"));
        }
        if (nbt.method_10545("tether")) {
            this.tether = nbt.method_10550("tether");
        }
        if (nbt.method_10545("ricochetBounces")) {
            this.setRicochetBounces(nbt.method_10550("ricochetBounces"));
        }
        if (nbt.method_10545("maxEchoDelay")) {
            this.setMaxEchoDelay(nbt.method_10550("maxEchoDelay"));
        }
        if (nbt.method_10545("maxAge")) {
            this.maxAge = nbt.method_10550("maxAge");
        }
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("postureLoss", this.getPostureLoss());
        nbt.method_10556("ethereal", this.isEthereal);
        nbt.method_10548("explosionPower", this.explosionPower);
        nbt.method_10548("chainLightningDamage", this.chainLightningDamage);
        nbt.method_10548("chainLightningRange", this.chainLightningRange);
        nbt.method_10569("blightCarrier", this.blightCarrier);
        nbt.method_10569("freezeAmplifier", this.freezeAmplifier);
        nbt.method_10556("echoCopy", this.isEchoCopy());
        nbt.method_10569("echoCopyTimer", this.getEchoCopyTimer());
        nbt.method_10569("tether", this.tether);
        nbt.method_10569("ricochetBounces", this.getRicochetBounces());
        nbt.method_10569("maxEchoDelay", this.getMaxEchoDelay());
        nbt.method_10569("maxAge", this.maxAge);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ECHO_COPY, (Object)false);
        this.field_6011.method_12784(ECHO_TIMER, (Object)0);
        this.field_6011.method_12784(RICOCHET_BOUNCES, (Object)0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    protected class_1799 method_7445() {
        return ItemRegistry.SILVER_BULLET.method_7854();
    }

    public void setEthereal(boolean ethereal) {
        this.isEthereal = ethereal;
    }

    public boolean isEthereal() {
        return this.isEthereal;
    }

    @Override
    public void setPostureLoss(int postureLoss) {
        this.postureLoss = postureLoss;
    }

    @Override
    public int getPostureLoss() {
        return this.postureLoss;
    }

    public void setExplosionPower(float explosionPower) {
        this.explosionPower = explosionPower;
    }

    public void setChainLightningDamage(float chainLightningDamage) {
        this.chainLightningDamage = chainLightningDamage;
    }

    public float getChainLightningDamage() {
        return this.chainLightningDamage;
    }

    public void setChainLightningRange(float chainLightningRange) {
        this.chainLightningRange = chainLightningRange;
    }

    public float getChainLightningRange() {
        return this.chainLightningRange;
    }

    public void setBlightCarrier(int blightCarrier) {
        this.blightCarrier = blightCarrier;
    }

    public int getBlightCarrier() {
        return this.blightCarrier;
    }

    public void setFreezeAmplifier(int freezeAmplifier) {
        this.freezeAmplifier = freezeAmplifier;
    }

    public int getFreezeAmplifier() {
        return this.freezeAmplifier;
    }

    public void setEchoCopy(boolean bl) {
        this.field_6011.method_12778(ECHO_COPY, (Object)bl);
    }

    public boolean isEchoCopy() {
        return (Boolean)this.field_6011.method_12789(ECHO_COPY);
    }

    public void setEchoCopyTimer(int amount) {
        this.field_6011.method_12778(ECHO_TIMER, (Object)amount);
    }

    private void reduceEchoCopyTimer() {
        this.setEchoCopyTimer(this.getEchoCopyTimer() - 1);
    }

    private int getEchoCopyTimer() {
        return (Integer)this.field_6011.method_12789(ECHO_TIMER);
    }

    public void setTether(int tether) {
        this.tether = tether;
    }

    public int getTether() {
        return this.tether;
    }

    public void setRicochetBounces(int ricochetBounces) {
        this.field_6011.method_12778(RICOCHET_BOUNCES, (Object)ricochetBounces);
    }

    public int getRicochetBounces() {
        return (Integer)this.field_6011.method_12789(RICOCHET_BOUNCES);
    }

    public int getMaxEchoDelay() {
        return this.maxEchoDelay;
    }

    public void setMaxEchoDelay(int maxEchoDelay) {
        this.maxEchoDelay = maxEchoDelay;
    }
}

