/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1677;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.AccursedLordBoss;
import net.soulsweaponry.entity.projectile.ShadowOrb;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import org.jetbrains.annotations.Nullable;

public class AccursedLordGoal
extends class_1352 {
    private final AccursedLordBoss boss;
    private int attackCooldown;
    private int attackStatus;
    private class_2338 attackPos;
    private boolean cordsRegistered;
    private int targetNotVisibleTicks;
    private int specialCooldown;
    private int lavaRadius = 4;
    private int lavaTimer;

    public AccursedLordGoal(AccursedLordBoss boss) {
        this.boss = boss;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 target = this.boss.method_5968();
        return target != null && target.method_5805() && this.boss.method_18395(target);
    }

    public void resetAttackCooldown(float cooldownModifier) {
        this.attackStatus = 0;
        this.cordsRegistered = false;
        this.attackCooldown = (int)Math.floor(ConfigConstructor.decaying_king_attack_cooldown_ticks * cooldownModifier) - this.boss.getReducedCooldownAttackers();
    }

    public void resetSpecialCooldown(float cooldownModifier) {
        this.specialCooldown = (int)(Math.floor(ConfigConstructor.decaying_king_special_cooldown_ticks * cooldownModifier) - (double)this.boss.getReducedCooldownAttackers());
    }

    public float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.decaying_king_damage_modifier;
    }

    private void damageTarget(class_1309 target, class_1282 source, float amount) {
        if (target.method_5643(source, this.getModifiedDamage(amount))) {
            this.boss.method_6025(this.getModifiedDamage(amount) / 5.0f + (float)(this.boss.getAttackers().size() * 2));
        }
    }

    public void method_6270() {
        super.method_6270();
        this.boss.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.IDLE);
        this.attackCooldown = 10;
        this.attackStatus = 0;
        this.cordsRegistered = false;
        this.boss.removePlacedLava();
        this.lavaRadius = 4;
        this.lavaTimer = 0;
    }

    public void checkAndSetAttack(@Nullable AccursedLordBoss.AccursedLordAnimations specificAttack, class_1309 target) {
        if (target == null || specificAttack != null && specificAttack.equals((Object)AccursedLordBoss.AccursedLordAnimations.IDLE)) {
            this.boss.setAttackAnimation(specificAttack);
            return;
        }
        int rand = this.boss.method_6051().method_43048(AccursedLordBoss.AccursedLordAnimations.values().length);
        AccursedLordBoss.AccursedLordAnimations attack = AccursedLordBoss.AccursedLordAnimations.values()[rand];
        if (specificAttack != null) {
            attack = specificAttack;
        } else if (attack.equals((Object)AccursedLordBoss.AccursedLordAnimations.DEATH) || attack.equals((Object)AccursedLordBoss.AccursedLordAnimations.SPAWN) || attack.equals((Object)AccursedLordBoss.AccursedLordAnimations.IDLE)) {
            attack = AccursedLordBoss.AccursedLordAnimations.SWORDSLAM;
        }
        double distanceToEntity = this.boss.method_5858((class_1297)target);
        switch (attack) {
            case FIREBALLS: 
            case WITHERBALLS: {
                if (!(distanceToEntity < this.getFollowRange() * this.getFollowRange())) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case HAND_SLAM: 
            case HEATWAVE: 
            case SPIN: {
                if (distanceToEntity < 30.0 && this.specialCooldown < 0) {
                    this.boss.setAttackAnimation(attack);
                    break;
                }
                if (this.attackCooldown >= -30 && this.specialCooldown <= 10) break;
                this.boss.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.IDLE);
                break;
            }
            case PULL: {
                if (!(distanceToEntity < this.getFollowRange() * this.getFollowRange() * 2.0) || !(distanceToEntity > 60.0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case SWORDSLAM: {
                if (distanceToEntity < 40.0 && !this.cordsRegistered && target.method_24515() != null) {
                    this.attackPos = target.method_24515();
                    this.cordsRegistered = true;
                    this.boss.setAttackAnimation(attack);
                    break;
                }
                if (this.attackCooldown >= -30) break;
                this.boss.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.IDLE);
                break;
            }
            default: {
                this.boss.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.IDLE);
            }
        }
    }

    private double getFollowRange() {
        return this.boss.method_26825(class_5134.field_23717);
    }

    public void method_6268() {
        class_1309 target;
        --this.attackCooldown;
        --this.specialCooldown;
        if (this.lavaTimer > 0) {
            --this.lavaTimer;
            if (this.lavaTimer <= 0) {
                this.boss.removePlacedLava();
            }
        }
        if ((target = this.boss.method_5968()) != null && !this.boss.getAttackAnimation().equals((Object)AccursedLordBoss.AccursedLordAnimations.SPAWN) && !this.boss.getAttackAnimation().equals((Object)AccursedLordBoss.AccursedLordAnimations.DEATH)) {
            this.boss.method_19540(true);
            this.boss.method_5988().method_20248(target.method_23317(), target.method_23320(), target.method_23321());
            boolean entityInSight = this.boss.method_5985().method_6369((class_1297)target);
            this.targetNotVisibleTicks = entityInSight ? 0 : ++this.targetNotVisibleTicks;
            double distanceToEntity = this.boss.method_5858((class_1297)target);
            if (this.attackCooldown > 0) {
                this.boss.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.IDLE);
            }
            if (this.attackCooldown < 0 && this.boss.getAttackAnimation().equals((Object)AccursedLordBoss.AccursedLordAnimations.IDLE)) {
                this.checkAndSetAttack(null, target);
            }
            switch (this.boss.getAttackAnimation()) {
                case FIREBALLS: {
                    this.projectileBarrage(target, distanceToEntity, BarrageProjectiles.FIREBALLS);
                    break;
                }
                case WITHERBALLS: {
                    this.projectileBarrage(target, distanceToEntity, BarrageProjectiles.WITHERBALLS);
                    break;
                }
                case HEATWAVE: {
                    this.heatWaveAttack();
                    break;
                }
                case PULL: {
                    this.pullAttack(target);
                    break;
                }
                case SPIN: {
                    this.spinAttack();
                    break;
                }
                case SWORDSLAM: {
                    this.swordSlam();
                    break;
                }
                case HAND_SLAM: {
                    this.handSlamLava();
                    break;
                }
                default: {
                    this.boss.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.IDLE);
                }
            }
            if (this.targetNotVisibleTicks < 5) {
                this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
            }
            super.method_6268();
        }
    }

    private void handSlamLava() {
        ++this.attackStatus;
        if (this.attackStatus == 13 || this.attackStatus == 18 || this.attackStatus == 24) {
            this.summonLava(this.lavaRadius);
            if (!this.boss.method_37908().field_9236) {
                ParticleHandler.particleOutburstMap(this.boss.method_37908(), 200, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), ParticleEvents.DARKIN_BLADE_SLAM_MAP, 1.0f);
            }
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_15152, class_3419.field_15251, 1.0f, 1.0f);
            ++this.lavaRadius;
        }
        if (this.attackStatus >= 25) {
            this.resetAttackCooldown(0.5f);
            this.resetSpecialCooldown(1.2f);
            this.checkAndSetAttack(null, this.boss.method_5968());
            this.lavaRadius = 4;
        }
    }

    private void summonLava(int r) {
        for (int theta = 0; theta < 360; theta += 15) {
            double x0 = this.boss.method_23317();
            double z0 = this.boss.method_23321();
            double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
            double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
            class_2338 pos = class_2338.method_49637((double)x, (double)this.boss.method_23318(), (double)z);
            if (!this.boss.method_37908().method_8320(pos).method_26215()) continue;
            this.boss.method_37908().method_8501(pos, class_2246.field_10164.method_9564());
            this.boss.lavaPos.add(pos);
        }
        this.lavaTimer = 30;
    }

    private void spinAttack() {
        ++this.attackStatus;
        if (this.attackStatus >= 7 && this.attackStatus <= 40) {
            class_238 chunkBox = new class_238(this.boss.method_24515()).method_1014(6.0);
            List nearbyEntities = this.boss.method_37908().method_8335((class_1297)this.boss, chunkBox);
            for (class_1297 nearbyEntity : nearbyEntities) {
                if (!(nearbyEntity instanceof class_1309)) continue;
                class_1309 closestTarget = (class_1309)nearbyEntity;
                double x = closestTarget.method_23317() - this.boss.method_23317();
                double z = closestTarget.method_23321() - this.boss.method_23321();
                this.damageTarget(closestTarget, this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), 10.0f);
                closestTarget.method_6005(4.0, -x, -z);
            }
        }
        if (this.attackStatus >= 45) {
            this.resetAttackCooldown(0.5f);
            this.resetSpecialCooldown(1.2f);
            this.checkAndSetAttack(null, this.boss.method_5968());
        }
    }

    private void heatWaveAttack() {
        ++this.attackStatus;
        if (this.attackStatus >= 16 && this.attackStatus <= 18) {
            if (this.attackStatus == 17) {
                this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_15152, class_3419.field_15251, 5.0f, 1.0f);
            }
            class_238 chunkBox = new class_238(this.boss.method_24515()).method_1014(5.0);
            List nearbyEntities = this.boss.method_37908().method_8335((class_1297)this.boss, chunkBox);
            for (class_1297 nearbyEntity : nearbyEntities) {
                if (!(nearbyEntity instanceof class_1309)) continue;
                class_1309 closestTarget = (class_1309)nearbyEntity;
                double x = closestTarget.method_23317() - this.boss.method_23317();
                double z = closestTarget.method_23321() - this.boss.method_23321();
                closestTarget.method_6005(10.0, -x, -z);
                this.damageTarget(closestTarget, this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), 50.0f);
            }
            if (!this.boss.method_37908().field_9236) {
                ParticleHandler.particleSphere(this.boss.method_37908(), 1000, this.boss.method_23317(), this.boss.method_23318() + (double)0.4f, this.boss.method_23321(), (class_2394)class_2398.field_11240, 1.0f);
                ParticleHandler.particleOutburstMap(this.boss.method_37908(), 200, this.boss.method_23317(), this.boss.method_23318() + (double)0.1f, this.boss.method_23321(), ParticleEvents.DAWNBREAKER_MAP, 1.0f);
            }
        }
        if (this.attackStatus >= 30) {
            this.resetAttackCooldown(1.5f);
            this.checkAndSetAttack(null, this.boss.method_5968());
            this.resetSpecialCooldown(1.0f);
        }
    }

    private void pullAttack(class_1309 target) {
        ++this.attackStatus;
        if (this.attackStatus == 20) {
            double x = target.method_23317() - this.boss.method_23317();
            double z = target.method_23321() - this.boss.method_23321();
            this.damageTarget(target, this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), 5.0f);
            target.method_6005(5.0, x, z);
        }
        if (this.attackStatus >= 25) {
            this.attackStatus = 0;
            this.resetAttackCooldown(0.25f);
            this.checkAndSetAttack(null, this.boss.method_5968());
        }
    }

    private void swordSlam() {
        ++this.attackStatus;
        this.boss.method_5988().method_20248((double)this.attackPos.method_10263(), (double)this.attackPos.method_10264(), (double)this.attackPos.method_10260());
        this.boss.method_5942().method_6337((double)this.attackPos.method_10263(), (double)this.attackPos.method_10264(), (double)this.attackPos.method_10260(), 0.0);
        this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
        class_238 aoe = new class_238(this.attackPos).method_1014(3.0);
        List entities = this.boss.method_37908().method_8335((class_1297)this.boss, aoe);
        if (this.attackStatus == 17) {
            if (!this.boss.method_37908().field_9236) {
                ParticleHandler.particleOutburstMap(this.boss.method_37908(), 200, this.attackPos.method_10263(), this.attackPos.method_10264(), this.attackPos.method_10260(), ParticleEvents.DARKIN_BLADE_SLAM_MAP, 1.0f);
            }
            for (class_1297 entity : entities) {
                if (!(entity instanceof class_1309)) continue;
                this.damageTarget((class_1309)entity, CustomDamageSource.create(this.boss.method_37908(), CustomDamageSource.OBLITERATED, (class_1297)this.boss), 30.0f);
                entity.method_18800(entity.method_18798().field_1352, (double)0.3f, entity.method_18798().field_1350);
            }
            this.boss.method_37908().method_8396(null, this.attackPos, class_3417.field_15152, class_3419.field_15251, 1.0f, 1.0f);
        }
        if (this.attackStatus >= 20) {
            this.resetAttackCooldown(0.5f);
            this.cordsRegistered = false;
            this.boss.method_5942().method_6340();
            this.checkAndSetAttack(null, this.boss.method_5968());
        }
    }

    private void projectileBarrage(class_1309 target, double distanceToEntity, BarrageProjectiles entity) {
        int fireSprayCount = 8;
        ++this.attackStatus;
        double e = target.method_23317() - this.boss.method_23317();
        double f = target.method_23323(0.5) - this.boss.method_23323(1.0);
        double g = target.method_23321() - this.boss.method_23321();
        if (this.attackStatus % 2 == 0 && this.attackStatus > 8) {
            double h = Math.sqrt(Math.sqrt(distanceToEntity)) * 0.5;
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_14970, class_3419.field_15251, 2.0f, 1.0f);
            for (int i = 0; i < fireSprayCount; ++i) {
                new class_1677(this.boss.method_37908(), (class_1309)this.boss, e + this.boss.method_6051().method_43059() * h, f, g + this.boss.method_6051().method_43059() * h);
                Object projectile = switch (entity.ordinal()) {
                    default -> throw new IncompatibleClassChangeError();
                    case 0 -> new class_1677(this.boss.method_37908(), (class_1309)this.boss, e + this.boss.method_6051().method_43059() * h, f, g + this.boss.method_6051().method_43059() * h);
                    case 1 -> new ShadowOrb(this.boss.method_37908(), (class_1309)this.boss, e + this.boss.method_6051().method_43059() * h, f, g + this.boss.method_6051().method_43059() * h, class_1294.field_5920, EffectRegistry.DECAY);
                };
                projectile.method_5814(projectile.method_23317(), this.boss.method_23323(1.0) - 1.5, projectile.method_23321());
                this.boss.method_37908().method_8649((class_1297)projectile);
            }
        }
        if (this.attackStatus >= 30) {
            this.resetAttackCooldown(1.0f);
            this.checkAndSetAttack(null, this.boss.method_5968());
        }
    }

    static enum BarrageProjectiles {
        FIREBALLS,
        WITHERBALLS;

    }
}

