/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.api.entitystats;

import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3483;
import net.soulsweaponry.api.entitystats.EntityStats;
import net.soulsweaponry.api.entitystats.EntityStatsUtil;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.BleedData;
import net.soulsweaponry.entitydata.IEntityDataSaver;
import net.soulsweaponry.registry.AttributeRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.ModTags;

public class EntityBleed {
    public static int getBleedBuildup(class_1309 entity, int amount) {
        float resistance = EntityBleed.getBleedBuildupResistance(entity);
        return Math.round(EntityStatsUtil.calculateResistance(resistance, amount));
    }

    public static void triggerBloodLoss(class_1309 entity) {
        entity.method_5643(CustomDamageSource.create(entity.method_37908(), CustomDamageSource.BLEED), EntityBleed.getBleedDamage(entity, ConfigConstructor.bleed_base_damage + entity.method_6063() * ConfigConstructor.bleed_percent_health_damage));
        entity.method_37908().method_8396(null, entity.method_24515(), SoundRegistry.BLOOD_LOSS, entity.method_5634(), 1.0f, 1.0f / (entity.method_6051().method_43057() * 0.4f + 0.8f));
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10002.method_9564()), entity.method_23322(0.5), entity.method_23323(0.5) + entity.method_6051().method_43058() * 2.0 - 1.0, entity.method_23325(0.5), 30, 0.0, 0.0, 0.0, 0.0);
        }
        BleedData.setBleed((IEntityDataSaver)entity, 0);
        for (class_1297 entity1 : entity.method_37908().method_8335((class_1297)entity, entity.method_5829().method_1014(20.0))) {
            if (!(entity1 instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity1;
            for (class_1268 hand : class_1268.values()) {
                if (!livingEntity.method_5998(hand).method_31574((class_1792)WeaponRegistry.BLOODLUST)) continue;
                livingEntity.method_6092(new class_1293(class_1294.field_5910, 600, (int)ConfigConstructor.bloodlust_bloodloss_in_vicinity_gives_strength_amp));
            }
        }
    }

    public static int getMaxBleed(class_1309 entity) {
        Optional<EntityStats> op = EntityStatsUtil.getStats((class_1297)entity);
        if (op.isPresent()) {
            EntityStats stats = op.get();
            int max = Math.round(stats.max_bleed);
            if (max != 0) {
                return max;
            }
        }
        return (int)ConfigConstructor.max_bleed;
    }

    public static float getBleedDamage(class_1309 entity, float amount) {
        float resistance = EntityBleed.getBleedDamageResistance(entity);
        return EntityStatsUtil.calculateResistance(resistance, amount);
    }

    public static float getBleedBuildupResistance(class_1309 entity) {
        float base = EntityStatsUtil.getStats((class_1297)entity).map(s -> Float.valueOf(s.bleed_buildup_resistance)).orElse(Float.valueOf(ConfigConstructor.base_bleed_buildup_resistance_unless_overridden)).floatValue();
        class_1324 inst = entity.method_5996(AttributeRegistry.BLEED_BUILDUP_RESISTANCE);
        float bonus = inst != null ? (float)inst.method_6194() : 0.0f;
        return base + bonus;
    }

    public static float getBleedDamageResistance(class_1309 entity) {
        float base = EntityStatsUtil.getStats((class_1297)entity).map(s -> Float.valueOf(s.bleed_damage_resistance)).orElse(Float.valueOf(ConfigConstructor.base_bleed_damage_resistance_unless_overridden)).floatValue();
        class_1324 inst = entity.method_5996(AttributeRegistry.BLEED_DAMAGE_RESISTANCE);
        float bonus = inst != null ? (float)inst.method_6194() : 0.0f;
        return base + bonus;
    }

    public static boolean isBleedDisabled(class_1309 entity) {
        Optional<EntityStats> op = EntityStatsUtil.getStats((class_1297)entity);
        return entity.method_5864().method_20210(class_3483.field_15507) || entity.method_5864().method_20210(ModTags.Entities.SKELETONS) || ConfigConstructor.disable_bleed_mechanic_for_all_mobs || op.isPresent() && op.get().max_bleed < 0.0f;
    }
}

