/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils;

import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import earth.terrarium.adastra.common.utils.ItemUtils;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3611;

public class FluidUtils {
    public static FluidHolder getTank(class_1799 stack) {
        return FluidUtils.getTank(stack, 0);
    }

    public static FluidHolder getTank(class_1799 stack, int tank) {
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)new ItemStackHolder(stack));
        if (container == null) {
            return FluidHolder.empty();
        }
        return (FluidHolder)container.getFluids().get(tank);
    }

    public static boolean hasFluid(class_1799 stack) {
        return FluidUtils.hasFluid(stack, 0);
    }

    public static boolean hasFluid(class_1799 stack, int tank) {
        return !FluidUtils.getTank(stack, tank).isEmpty();
    }

    public static long getTankCapacity(class_1799 stack) {
        return FluidUtils.getTankCapacity(stack, 0);
    }

    public static long getTankCapacity(class_1799 stack, int tank) {
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)new ItemStackHolder(stack));
        if (container == null) {
            return 0L;
        }
        return container.getTankCapacity(tank);
    }

    public static class_1799 fluidFilledItem(RegistryEntry<class_1792> item, RegistryEntry<class_3611> fluid) {
        ItemStackHolder stack = new ItemStackHolder(((class_1792)item.get()).method_7854());
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)stack);
        if (container == null) {
            return class_1799.field_8037;
        }
        FluidHolder holder = FluidHolder.ofMillibuckets((class_3611)((class_3611)fluid.get()), (long)container.getTankCapacity(0));
        container.insertFluid(holder, false);
        return stack.getStack();
    }

    public static void moveItemToContainer(class_1263 container, FluidContainer fluidContainer, int slot, int resultSlot, int tank) {
        class_1799 emptyStack;
        class_1799 stack = container.method_5438(slot);
        if (stack.method_7960() || !FluidContainer.holdsFluid((class_1799)stack)) {
            return;
        }
        class_1799 resultStack = container.method_5438(resultSlot);
        ItemStackHolder stackHolder = new ItemStackHolder(stack.method_46651(1));
        ItemFluidContainer itemFluidContainer = FluidContainer.of((ItemStackHolder)stackHolder);
        if (itemFluidContainer == null) {
            return;
        }
        FluidHolder amount = ((FluidHolder)itemFluidContainer.getFluids().get(tank)).copyHolder();
        if (amount.isEmpty()) {
            return;
        }
        if (!resultStack.method_7960() && !ItemUtils.canAddItem(emptyStack = FluidUtils.getEmptyStack(stackHolder, amount), resultStack)) {
            return;
        }
        if (FluidApi.moveFluid((FluidContainer)itemFluidContainer, (FluidContainer)fluidContainer, (FluidHolder)amount, (boolean)true) == 0L) {
            return;
        }
        FluidApi.moveFluid((FluidContainer)itemFluidContainer, (FluidContainer)fluidContainer, (FluidHolder)amount, (boolean)false);
        class_1799 result = stackHolder.getStack();
        if (resultStack.method_7960()) {
            stack.method_7934(1);
            container.method_5447(resultSlot, result);
        } else if (ItemUtils.canAddItem(result, resultStack)) {
            stack.method_7934(1);
            resultStack.method_7933(1);
        }
    }

    public static void moveContainerToItem(class_1263 container, FluidContainer fluidContainer, int slot, int resultSlot, int tank) {
        class_1799 filledStack;
        class_1799 stack = container.method_5438(slot);
        if (stack.method_7960() || !FluidContainer.holdsFluid((class_1799)stack)) {
            return;
        }
        class_1799 resultStack = container.method_5438(resultSlot);
        ItemStackHolder stackHolder = new ItemStackHolder(stack.method_46651(1));
        ItemFluidContainer itemFluidContainer = FluidContainer.of((ItemStackHolder)stackHolder);
        if (itemFluidContainer == null) {
            return;
        }
        FluidHolder amount = ((FluidHolder)fluidContainer.getFluids().get(tank)).copyHolder();
        if (amount.isEmpty()) {
            return;
        }
        if (!resultStack.method_7960() && !ItemUtils.canAddItem(filledStack = FluidUtils.getFilledStack(stackHolder, amount), resultStack)) {
            return;
        }
        if (FluidApi.moveFluid((FluidContainer)fluidContainer, (FluidContainer)itemFluidContainer, (FluidHolder)amount, (boolean)true) == 0L) {
            return;
        }
        FluidApi.moveFluid((FluidContainer)fluidContainer, (FluidContainer)itemFluidContainer, (FluidHolder)amount, (boolean)false);
        class_1799 result = stackHolder.getStack();
        if (resultStack.method_7960()) {
            stack.method_7934(1);
            container.method_5447(resultSlot, result);
        } else if (ItemUtils.canAddItem(result, resultStack)) {
            stack.method_7934(1);
            resultStack.method_7933(1);
        }
    }

    public static class_1799 getFilledStack(ItemStackHolder emptyStack, FluidHolder amount) {
        ItemStackHolder copy = emptyStack.copy();
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)copy);
        if (container == null) {
            return class_1799.field_8037;
        }
        container.insertFluid(amount, false);
        return copy.getStack();
    }

    public static class_1799 getEmptyStack(ItemStackHolder filledStack, FluidHolder amount) {
        ItemStackHolder copy = filledStack.copy();
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)copy);
        if (container == null) {
            return class_1799.field_8037;
        }
        container.extractFluid(amount, false);
        return copy.getStack();
    }
}

