/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.systems;

import earth.terrarium.adastra.api.events.AdAstraEvents;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.handlers.PlanetHandler;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import earth.terrarium.adastra.common.tags.ModEntityTypeTags;
import earth.terrarium.adastra.common.tags.ModItemTags;
import earth.terrarium.adastra.common.utils.ModUtils;
import java.util.Collection;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_8144;

public class TemperatureApiImpl
implements TemperatureApi {
    @Override
    public short getTemperature(class_1937 level) {
        return this.getTemperature((class_5321<class_1937>)level.method_27983());
    }

    @Override
    public short getTemperature(class_5321<class_1937> level) {
        return (Short)class_8144.method_49078((Object)PlanetApi.API.getPlanet(level), Planet::temperature, (Object)15);
    }

    @Override
    public short getTemperature(class_1937 level, class_2338 pos) {
        if (!(level instanceof class_3218)) {
            return this.getTemperature(level);
        }
        class_3218 serverLevel = (class_3218)level;
        return PlanetHandler.getTemperature(serverLevel, pos);
    }

    @Override
    public short getTemperature(class_1297 entity) {
        return this.getTemperature(entity.method_37908(), class_2338.method_49637((double)entity.method_23317(), (double)entity.method_23320(), (double)entity.method_23321()));
    }

    @Override
    public void setTemperature(class_1937 level, class_2338 pos, short temperature) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        PlanetHandler.setTemperature(serverLevel, pos, temperature);
    }

    @Override
    public void setTemperature(class_1937 level, Collection<class_2338> positions, short temperature) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        PlanetHandler.setTemperature(serverLevel, positions, temperature);
    }

    @Override
    public void removeTemperature(class_1937 level, class_2338 pos) {
        this.setTemperature(level, pos, this.getTemperature(level));
    }

    @Override
    public void removeTemperature(class_1937 level, Collection<class_2338> positions) {
        this.setTemperature(level, positions, this.getTemperature(level));
    }

    @Override
    public boolean isLiveable(class_1937 level, class_2338 pos) {
        short temperature = this.getTemperature(level, pos);
        return temperature >= -50 && temperature <= 70;
    }

    @Override
    public boolean isHot(class_1937 level, class_2338 pos) {
        return this.getTemperature(level, pos) > 70;
    }

    @Override
    public boolean isCold(class_1937 level, class_2338 pos) {
        return this.getTemperature(level, pos) < -50;
    }

    @Override
    public void entityTick(class_3218 level, class_1309 entity) {
        if (AdAstraConfig.disableTemperature) {
            return;
        }
        if (entity.method_5864().method_20210(ModEntityTypeTags.CAN_SURVIVE_IN_SPACE)) {
            return;
        }
        if (SpaceSuitItem.hasFullSet(entity, ModItemTags.SPACE_RESISTANT_ARMOR)) {
            return;
        }
        if (this.isHot((class_1937)level, entity.method_24515())) {
            if (entity.method_5864().method_20210(ModEntityTypeTags.CAN_SURVIVE_EXTREME_HEAT)) {
                return;
            }
            if (SpaceSuitItem.hasFullSet(entity, ModItemTags.HEAT_RESISTANT_ARMOR)) {
                return;
            }
            if (entity.method_6059(class_1294.field_5918)) {
                return;
            }
            if (AdAstraEvents.HotTemperatureTickEvent.fire(level, entity)) {
                this.burnEntity(entity);
            }
        } else if (this.isCold((class_1937)level, entity.method_24515())) {
            if (entity.method_5864().method_20210(ModEntityTypeTags.CAN_SURVIVE_EXTREME_COLD)) {
                return;
            }
            if (SpaceSuitItem.hasFullSet(entity, ModItemTags.FREEZE_RESISTANT_ARMOR)) {
                return;
            }
            if (AdAstraEvents.ColdTemperatureTickEvent.fire(level, entity)) {
                this.freezeEntity(entity, level);
            }
        }
    }

    private void burnEntity(class_1309 entity) {
        entity.method_5643(entity.method_48923().method_48813(), 6.0f);
        entity.method_5639(10);
    }

    private void freezeEntity(class_1309 entity, class_3218 level) {
        if (entity.method_5864().method_20210(ModEntityTypeTags.CAN_SURVIVE_EXTREME_COLD)) {
            return;
        }
        if (SpaceSuitItem.hasFullSet(entity, ModItemTags.FREEZE_RESISTANT_ARMOR)) {
            return;
        }
        if (AdAstraEvents.ColdTemperatureTickEvent.fire(level, entity)) {
            entity.method_5643(entity.method_48923().method_48836(), 3.0f);
            entity.method_32317(Math.min(entity.method_32315() + 20, entity.method_32312() + 50));
            ModUtils.sendParticles(level, class_2398.field_28013, entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321(), 1, class_3532.method_32750((class_5819)level.field_9229, (float)-1.0f, (float)1.0f) * 0.085f, 0.05, (double)class_3532.method_32750((class_5819)level.field_9229, (float)-1.0f, (float)1.0f) * 0.085, 0.0);
        }
    }
}

